package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesForLabCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;

public class ResourcesGrid extends FlexTable {
	public static final String	RESOURCE_COLUMN_NAMES[]	= { "Resource Name", "Type", "Date Added", "Status", "", "" };
	private String				type;
	private String				userUri;
	public EIInstance[]			aryInstance;
	private CheckBox[]			chkBoxRefAry;
	FilterPanel					filterPanel;
	private List<String>		editableReadableStates;
	/**
	 * 
	 * @param type
	 *            - uri of the resource
	 * @param fp
	 * @param userUri
	 */
	public ResourcesGrid(String type, FilterPanel fp, String userUri) {
		this.type = type;
		this.filterPanel = fp;
		this.userUri = userUri;
		this.initializeEditableStates();
		createGrid();
	}
	/**
	 * Creates a grid with resources of a particular lab
	 * 
	 * @param type
	 * @param isLab
	 */
	public ResourcesGrid(String userUri, String type, boolean isLab) {
		this.type = type;
		this.userUri = userUri;
		this.initializeEditableStates();
		setStyleName("listGrid");
		try {
			// Display the Loading image
			MainPanel.glasspane.show();
			MainPanel.glasspane.add(new Image("images/ajax-loader.gif"));
			ClientRepositoryToolsManager.INSTANCE.getInstancesForLab(userUri, type, new EIInstancesForLabCallback() {
				@Override
				public void onSuccess(List<EIInstance> eiInstanceList) {
					int i = 0;
					int row = 0;
					MainPanel.glasspane.hide();
					if (eiInstanceList.size() == 0) {
						setHTML(1, 0, "<font color='red'> No resources found for the given Lab. <br></font>");
					}
					makeResultGrid(eiInstanceList, i, row);
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public ResourcesGrid(List<EIInstance> instances, String type) {
		this.type = type;
		init(instances);
	}
	public ResourcesGrid(List<EIInstance> instances) {
		init(instances);
	}
	private void init(List<EIInstance> instances) {
		this.initializeEditableStates();
		// Header columns
		setStyleName("listGrid");
		int i = 0;
		int row = 0;
		makeResultGrid(instances, i, row);
	}
	private void makeResultGrid(List<EIInstance> instances, int i, int row) {
		for (String colName : RESOURCE_COLUMN_NAMES) {
			getCellFormatter().setStyleName(row, i, "listGridHeader");
			setHTML(row, i++, "<b>" + colName + "</b>");
		}
		if ((type == null || !type.equals("http://purl.obolibrary.org/obo/ERO_0000001")) && !History.getToken().contains("http://purl.obolibrary.org/obo/ERO_0000001")) {
			final ListBox actionList = makeListBoxOfAction();
			getCellFormatter().setStyleName(row, i, "listGridHeader");
			setWidget(row, i++, actionList);
		}
		row = getRowCount();
		aryInstance = new EIInstance[instances.size()];
		chkBoxRefAry = new CheckBox[instances.size()];
		for (EIInstance instance : instances) {
			aryInstance[row - 1] = instance;
			createInstanceRow(row, instance);
			row++;
		}
	}
	private ListBox makeListBoxOfAction() {
		WorkFlowConstants wfc = new WorkFlowConstants();
		List<String> stateList = ClientRepositoryToolsManager.INSTANCE.getEditableStates();
		Iterator<String> iter = stateList.iterator();
		final ListBox actionList = new ListBox();
		actionList.addItem("Workflow Action");
		while (iter.hasNext()) {
			String stateUri = iter.next();
			String state = wfc.getStatusTypeByStatusURI(stateUri);
			if (WorkFlowConstants.CURATION_STATE.equals(state)) {
				actionList.addItem(WorkFlowConstants.PUBLISH_ACTION);
			} else if (WorkFlowConstants.DRAFT_STATE.equals(state)) {
				actionList.addItem(WorkFlowConstants.CURATION_ACTION);
			} else if (WorkFlowConstants.WITHDRAW_STATE.equals(state)) {
				actionList.addItem(WorkFlowConstants.WITHDRAW_ACTION);
			}
		}
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.CURATION_STATE)) {
			actionList.addItem(WorkFlowConstants.DRAFT_ACTION);
		}
		actionList.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent event) {
				String selectedText = actionList.getItemText(actionList.getSelectedIndex());
				if (selectedText.equalsIgnoreCase(WorkFlowConstants.CURATION_ACTION)) {
					MainPanel.bulkOperation(WorkFlowAction.CurationAction);
				} else if (selectedText.equalsIgnoreCase(WorkFlowConstants.PUBLISH_ACTION)) {
					MainPanel.bulkOperation(WorkFlowAction.PublishAction);
				} else if (selectedText.equalsIgnoreCase(WorkFlowConstants.WITHDRAW_ACTION)) {
					MainPanel.bulkOperation(WorkFlowAction.WithdrawAction);
				} else if (selectedText.equalsIgnoreCase(WorkFlowConstants.DRAFT_ACTION)) {
					MainPanel.bulkOperation(WorkFlowAction.ReturnToDraftAction);
				}
				actionList.setSelectedIndex(0);
			}
		});
		return actionList;
	}
	private void initializeEditableStates() {
		editableReadableStates = new ArrayList<String>(4);
		WorkFlowConstants wfc = new WorkFlowConstants();
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.DRAFT_URI))
			editableReadableStates.add(wfc.getStatusType(WorkFlowConstants.DRAFT_URI));
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.CURATION_URI))
			editableReadableStates.add(wfc.getStatusType(WorkFlowConstants.CURATION_URI));
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.PUBLISH_URI))
			editableReadableStates.add(wfc.getStatusType(WorkFlowConstants.PUBLISH_URI));
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(WorkFlowConstants.WITHDRAW_URI))
			editableReadableStates.add(wfc.getStatusType(WorkFlowConstants.WITHDRAW_URI));
	}
	private void createGrid() {
		// Header columns
		setStyleName("listGrid");
		int i = 0;
		int row = 0;
		for (String colName : RESOURCE_COLUMN_NAMES) {
			getCellFormatter().setStyleName(row, i, "listGridHeader");
			setHTML(row, i++, "<b>" + colName + "</b>");
		}
		if ((type == null || !type.equals("http://purl.obolibrary.org/obo/ERO_0000001")) && !History.getToken().contains("http://purl.obolibrary.org/obo/ERO_0000001")) {
			final ListBox actionList = makeListBoxOfAction();
			getCellFormatter().setStyleName(row, i, "listGridHeader");
			setWidget(row, i++, actionList);
		}
		if (type != null) { // Get resources for a specific resource type
			// Display the Loading image
			MainPanel.glasspane.show();
			MainPanel.glasspane.add(new Image("images/ajax-loader.gif"));
			ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(userUri, EIURI.create(type), new EIInstancesCallback() {
				@Override
				public void onSuccess(final List<EIInstance> eiInstanceList) {
					ClientOntologyToolsManager.INSTANCE.getEIClass(EIURI.create(type), new EIClassCallback() {
						@Override
						public void onFailure(String result) {
							// TODO Auto-generated method stub
						}
						@Override
						public void onSuccess(EIClass result) {
							MainPanel.glasspane.hide();
							String resourceType = result.getEntity().getLabel();
							filterPanel.totalResources.setText("(" + eiInstanceList.size() + ") instances found");
							int row = getRowCount();
							if (eiInstanceList.size() == 0) {
								MainPanel.dataPanel.add(new Label("No resources found "));
							}
							aryInstance = new EIInstance[eiInstanceList.size()];
							chkBoxRefAry = new CheckBox[eiInstanceList.size()];
							for (EIInstance instance : eiInstanceList) {
								aryInstance[row - 1] = instance;
								createInstanceRow(row, instance);
								row++;
							}
						}
					});
				}
				@Override
				public void loginRequired() {
					handleLoginRequired();
				}
			});
		} else if (userUri != null) {
			// Display the loading image
			MainPanel.glasspane.show();
			MainPanel.glasspane.add(new Image("images/ajax-loader.gif"));
			// setHTML(row1, 1, "Loading");
			ClientRepositoryToolsManager.INSTANCE.getAllResources(userUri, new EIInstancesCallback() {
				@Override
				public void onSuccess(List<EIInstance> eiInstanceList) {
					MainPanel.glasspane.hide();
					int row = getRowCount();
					if (eiInstanceList.size() == 0) {
						MainPanel.dataPanel.add(new Label("No resources found "));
					}
					aryInstance = new EIInstance[eiInstanceList.size()];
					filterPanel.totalResources.setText("(" + eiInstanceList.size() + ") instances found");
					chkBoxRefAry = new CheckBox[eiInstanceList.size()];
					for (EIInstance instance : eiInstanceList) {
						aryInstance[row - 1] = instance;
						createInstanceRow(row, instance);
						row++;
					}
				}
				@Override
				public void loginRequired() {
					handleLoginRequired();
				}
			});
		}
	}
	public void createInstanceRow(int row, EIInstance instance) {
		final String deleteHtml = "<a>delete</a>";
		final String claimHtml = "<a>claim</a>";
		final String editHtml = "<a>edit</a>";
		final String withdrawHtml = "<a>withdraw</a>";
		final String publishHtml = "<a>publish</a>";
		WorkFlowConstants wfc = new WorkFlowConstants();
		EIURI ownerUri = instance.getWFOwner();
		int col = 0;
		setHTML(row, col++, "<a>" + instance.getInstanceLabel() + "</a>");
		setText(row, col++, instance.getInstanceType().getLabel());
		if (instance.getCreationDate() != null)
			setText(row, col++, formatDate(instance.getCreationDate()));
		String status = instance.getWFState() == null ? "" : wfc.getStatusType(instance.getWFState().toString());
		setText(row, col++, status);
		// TODO: pull out into a method.  This is stupid.
		if (status.equals(WorkFlowConstants.PUBLISH_STATE)) {
			if (editableReadableStates.contains(WorkFlowConstants.PUBLISH_STATE)) {
				setHTML(row, col++, editHtml);
				setHTML(row, col++, "");
			} else {
				setHTML(row, col++, "");
				setHTML(row, col++, "");
			}
		} else if (status.equals(WorkFlowConstants.WITHDRAW_STATE)) {
			if (editableReadableStates.contains(WorkFlowConstants.WITHDRAW_STATE)) {
				setHTML(row, col++, editHtml);
				setHTML(row, col++, "");
			} else {
				setHTML(row, col++, "");
				setHTML(row, col++, "");
			}
		} else if ((ownerUri == null) && editableReadableStates.contains(status)) {
			setHTML(row, col++, claimHtml);
			setHTML(row, col++, "");
		} else if (editableReadableStates.contains(status)) {
			setHTML(row, col++, editHtml);
			setHTML(row, col++, deleteHtml);
		} else {
			setHTML(row, col++, "");
			setHTML(row, col++, "");
		}
		if ((type == null || !type.equals("http://purl.obolibrary.org/obo/ERO_0000001")) && !History.getToken().contains("http://purl.obolibrary.org/obo/ERO_0000001")) {
			CheckBox checkBox = new CheckBox();
			setWidget(row, col++, checkBox);
			chkBoxRefAry[row - 1] = checkBox;
			/* checkbox visibilty */
			checkBox.setVisible(shouldDisplayCheckBox(ownerUri, status));
		}
		//This is to identify that it is a Lab Instance. If it is not, when the user clicks to view the resource, the resource selected wont be displayed  
		// on the Left panel. See DTOOLS-299 for details 
		if (type.equals("http://purl.obolibrary.org/obo/ERO_0000001")) {
			setText(row, col++, "LaboratoryInstance");
			getCellFormatter().setStyleName(row, col - 1, "hiddenURI");
		}
		setText(row, col++, instance.getEntity().getURI().toString());
		getCellFormatter().setStyleName(row, col - 1, "hiddenURI");
	}
	private boolean shouldDisplayCheckBox(EIURI ownerUri, String status) {
		if (!Datatools.canUserChangeState(status))
			return false;
		if (ownerUri != null)
			return true;
		return (WorkFlowConstants.PUBLISH_URI.equals(status) || WorkFlowConstants.WITHDRAW_URI.equals(status) || WorkFlowConstants.PUBLISH_STATE.equals(status) || WorkFlowConstants.WITHDRAW_STATE.equals(status));
	}
	public EIInstance getInstanceInGridByRow(int row) {
		return aryInstance[row];
	}
	String formatDate(String dt) {
		String date = "";
		if (dt != null)
			date = dt.substring(0, dt.indexOf("T"));
		return date;
	}
	private void handleLoginRequired() {
		// TODO: what's the real behavior?
		clear();
		MainPanel.handleLoginRequired();
	}
	public CheckBox[] getChkBoxRefAry() {
		return chkBoxRefAry;
	}
	public void setChkBoxRefAry(CheckBox[] chkBoxRefAry) {
		this.chkBoxRefAry = chkBoxRefAry;
	}
}
