package org.eaglei.datatools.client.ui;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;

public class TextWidget extends EditWidget {

	public interface OldValueHandler {
		public void replaceValue(EIInstance instance, EIEntity propertyEntity, String oldValue, String newValue);
		public void addValue(EIInstance instance, EIEntity propertyEntity, String newValue);
	}
	
	public static TextWidget makeDatatypeTextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue) {
		if (propertyEntity.getLabel().equalsIgnoreCase("email")) {
			return new ValidatedTextWidget(eiInstance, propertyEntity, propertyValue, getDatatypeOldValueHandler());
		}
		return new TextWidget(eiInstance, propertyEntity, propertyValue, getDatatypeOldValueHandler());
	}

	public static TextWidget makeLabelTextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue) {
		return new TextWidget(eiInstance, propertyEntity, propertyValue, new OldValueHandler() {
			
			@Override
			public void replaceValue(EIInstance instance, EIEntity propertyEntity,
					String oldValue, String newValue) {
				instance.getEntity().setLabel(newValue);
				
			}
			
			@Override
			public void addValue(EIInstance instance, EIEntity propertyEntity, String newValue) {
				instance.getEntity().setLabel(newValue);
				
			}
		});
	}
	
	public static TextWidget makeNonOntologyTextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue) {
		return new TextWidget(eiInstance, propertyEntity, propertyValue, new OldValueHandler() {
			
			@Override
			public void replaceValue(EIInstance instance, EIEntity propertyEntity,
					String oldValue, String newValue) {
				instance.replaceNonOntologyLiteralProperty(propertyEntity, oldValue, newValue);
				
			}
			
			@Override
			public void addValue(EIInstance instance, EIEntity propertyEntity,
					String newValue) {
				instance.addNonOntologyLiteralProperty(propertyEntity, newValue);
				
			}
		});
	}
	
	public static TextWidget makeNonOntologyTextWidget(EIInstance eiInstance, EIEntity propertyEntity, EIURI propertyValue) {
		return new TextWidget(eiInstance, propertyEntity, propertyValue.toString(), new OldValueHandler() {
			
			@Override
			public void replaceValue(EIInstance instance, EIEntity propertyEntity, String oldValue, String newValue) {
				instance.replaceNonOntologyResourcePropertyValue(propertyEntity, EIURI.create(oldValue), EIURI.create(newValue));		
			}
			
			@Override
			public void addValue(EIInstance instance, EIEntity propertyEntity, String newValue) {
				instance.addNonOntologyResourceProperty(propertyEntity, EIURI.create(newValue));	
			}
		});
	}
	
	protected static OldValueHandler getDatatypeOldValueHandler() {
		return new OldValueHandler() {
			
			@Override
			public void replaceValue(EIInstance instance, EIEntity propertyEntity,
					String oldValue, String newValue) {
				instance.replaceDatatypePropertyValue(propertyEntity, oldValue, newValue);
				
			}
			
			@Override
			public void addValue(EIInstance instance, EIEntity propertyEntity,
					String newValue) {
				instance.addDatattypeProperty(propertyEntity, newValue);
				
			}
			
		};
	}
	
	private TextBox valueField = WidgetUtils.createTextField();
	protected OldValueHandler oldValueHandler;
	final Label errLabel = new Label();

	protected TextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue, OldValueHandler handler) {
		super(eiInstance, propertyEntity);
		oldValue = propertyValue;
		oldValueHandler = handler;
		shouldShowLabel = true;
		setup();
	}
	
	
	protected void setup() {
		valueField.setName(propertyEntity.getLabel());
		if(hasOldValue()) {
			valueField.setText(WidgetUtils.formatText(oldValue));
		}
		//widgetPanel.add(propLabel);
		widgetPanel.add(valueField);
		errLabel.setStyleName("errorMsg");
		widgetPanel.add(errLabel);
		
		if (propertyEntity.getLabel().equalsIgnoreCase("phone number")) {
			valueField.setMaxLength(13);
			addPhoneValidations();
		}
		
		valueField.addValueChangeHandler(getValueChangeHandler());
	}

	protected ValueChangeHandler<String> getValueChangeHandler() {
		return new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> changedValue) {
				if(hasOldValue()) {
					oldValueHandler.replaceValue(eiInstance, propertyEntity, oldValue, changedValue.getValue());
				} else {
					oldValueHandler.addValue(eiInstance, propertyEntity, changedValue.getValue());
				}
				updateOldValue(changedValue.getValue());
			}
		};
	}
	
	@Override
	public void removeValue() {
		if (hasOldValue())
			oldValueHandler.replaceValue(eiInstance, propertyEntity, oldValue, null);
	}
	
	@Override
	public EditWidget duplicateBlank() {
		return new TextWidget(eiInstance, propertyEntity, "", oldValueHandler);
	}
	
	protected void setFieldValue(String newValue) {
		valueField.setValue(newValue);
	}
	
	protected String getValueText() {
		return valueField.getValue();
	}
	
	private void addPhoneValidations() {
		valueField.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				if (!Validations.OnlyPhoneFormat(valueField.getValue())) {
					valueField.setText(valueField.getText().replace(valueField.getText().toCharArray()[valueField.getText().length() - 1] + "", ""));
					return;
				}
				Validations.jsniPhoneValidation(valueField.getElement());
			}
		});
	}
}
