package org.eaglei.datatools.client.ui;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Displays the Form for viewing. All the fields are disabled and no editing is possible. 
 *
 */
public class ViewFormsPanel extends EIFormsPanel{


	public ViewFormsPanel(EIInstance instance) {
		super(instance);
		shouldShowReadOnlyProperties = true;
		finishSetup();
	}

	@Override
	public void onLogIn(String username, String userUri) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onLogOut() {
		// TODO Auto-generated method stub
		
	}

	@Override
	void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues) {
		
		LabelValuesWidget widget = new LabelValuesWidget(propertyEntity);
		formPanel.add(widget);
		
		for(String value: propertyValues) {
			widget.add(handleTextProperty(value));
		}
	}
	
	private Widget handleTextProperty(String value){
		Anchor resourceURL = null; // For values that have external URIs
		Label valueField = new Label();
		valueField.setStyleName("formLabelValue");
		if (value.startsWith("www") || value.startsWith("http")) {
			resourceURL = new Anchor(WidgetUtils.formatText(value), WidgetUtils.formatText(value), "_blank");
		} else {
			valueField.setText(WidgetUtils.formatText(value));
		}
		
		return resourceURL == null ? valueField : resourceURL;
	}
	
	@Override
	void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		String  propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
		
		LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for(String value:propertyValues) {
			widget.add(handleTextProperty(value));
		}
		nonOntologyPanel.add(widget); 
	}

	@Override
	void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIURI> propertyValues,  Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		String  propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
		
		LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for(EIURI propUri:propertyValues) {
			widget.add(handleTextProperty(propUri.toString()));
		}
		nonOntologyPanel.add(widget); 
	}

	@Override
	void drawObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues) {
		final LabelValuesWidget widget = new LabelValuesWidget(propertyEntity);
		
		formPanel.add(widget);
		
		// TODO: retrieve label*s* all at once
		for(final EIURI uri: propertyValues) {
			ClientRepositoryToolsManager.INSTANCE.retrieveLabel(uri, new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					// Deliberate no-op
				}
				@Override
				public void onSuccess(String arg0) {
					Anchor a = new Anchor(arg0);
					widget.add(a);
					a.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							try {
								ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
									@Override
									public void loginRequired() {
										//handleLoginRequired();
									}
									@Override
									public void onSuccess(EIInstance eiInstance) {
										if (eiInstance != null) {
											MainPanel.dataPanel.clear();
											MainPanel.instanceUri = eiInstance.getInstanceURI().toString();
											FilterPanel fp = new FilterPanel(WidgetUtils.getWFStateString(eiInstance), (eiInstance.getWFOwner() != null));
											MainPanel.dataPanel.add(fp);
											fp.editButton.setVisible(true);
											fp.saveButton.setVisible(false);
											MainPanel.dataPanel.add(new ViewFormsPanel(eiInstance));
											for (int i = 0; i < LeftListPanel.resourcesTable.getRowCount(); i++) {
												LeftListPanel.resourcesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
											}
											for (int i = 0; i < LeftListPanel.labsTable.getRowCount(); i++) {
												LeftListPanel.labsTable.getRowFormatter().setStyleName(i, "panelNotSelected");
											}
										} else {
											Window.open("http://search.eagle-i.net/model/#t=" + uri.toString(), "", "");
										}
									}
								});
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
					
				}
				@Override
				public void loginRequired() {
					//handleLoginRequired();
				}
			});
		}
		
	}

	@Override
	Collection<EIEntity> getDataTypeEntities() {
		return eiInstance.getDatatypeProperties().keySet();
	}

	@Override
	Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	Collection<EIEntity> getObjectTypeEntities() {
		return eiInstance.getObjectProperties().keySet();
	}

	@Override
	protected void drawExtraFields(
			Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		// deliberate no-op
	}

}
