/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.LabelValuesWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public abstract class EIFormsPanel
extends Composite
implements ClientRepositoryToolsManager.SessionListener {
    protected VerticalPanel formPanel = new VerticalPanel();
    protected EIInstance eiInstance;
    protected final EIEntity propertyName = EIEntity.create((String)"", (String)"Resource Name");
    protected final EIEntity propertyType = EIEntity.create((String)"", (String)"Type");
    protected boolean shouldShowReadOnlyProperties;

    abstract void drawDataProperty(EIEntity var1, Set<String> var2);

    abstract void drawObjectProperty(EIEntity var1, Set<EIURI> var2);

    abstract void drawNonOntologyLiteralProperty(EIEntity var1, Set<String> var2, Map<EIEntity, String> var3, VerticalPanel var4);

    abstract void drawNonOntologyResourceProperty(EIEntity var1, Set<EIURI> var2, Map<EIEntity, String> var3, VerticalPanel var4);

    protected abstract void drawExtraFields(Map<EIEntity, Set<String>> var1);

    abstract Collection<EIEntity> getDataTypeEntities();

    abstract Collection<EIEntity> getObjectTypeEntities();

    abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

    abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

    public EIFormsPanel(EIInstance instance) {
        this.initWidget((Widget)this.formPanel);
        this.eiInstance = instance;
    }

    protected void finishSetup() {
        this.constructForm();
        this.formPanel.setStyleName("formPanel");
        this.formPanel.setSpacing(30);
        this.formPanel.setHeight("50");
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
    }

    public EIInstance getInstance() {
        return this.eiInstance;
    }

    protected void constructForm() {
        Map dataTypeProperties = this.eiInstance.getDatatypeProperties();
        Map objectTypeProperties = this.eiInstance.getObjectProperties();
        Map nonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        Map nonOntologyResourceProperties = this.eiInstance.getNonOntologyResourceProperties();
        this.drawDataProperty(this.propertyName, (Set)this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
        this.drawObjectProperty(this.propertyType, new HashSet<EIURI>(Arrays.asList(this.eiInstance.getInstanceType().getURI())));
        for (EIEntity propEntity : this.getDataTypeEntities()) {
            this.drawDataProperty(propEntity, (Set)dataTypeProperties.get(propEntity));
        }
        for (EIEntity propEntity : this.getObjectTypeEntities()) {
            this.drawObjectProperty(propEntity, (Set)objectTypeProperties.get(propEntity));
        }
        this.drawExtraFields(nonOntologyLiteralProperties);
        DisclosurePanel nonOntologyPanel = new DisclosurePanel("Information for data curators");
        Map nonOntLiteralList = this.eiInstance.getNonOntologyLiteralProperties();
        Map nonOntResourceList = this.eiInstance.getNonOntologyResourceProperties();
        ArrayList entityList = new ArrayList();
        entityList.addAll(this.eiInstance.getReadOnlyLiteralProperties().keySet());
        entityList.addAll(this.eiInstance.getReadOnlyResourceProperties().keySet());
        entityList.addAll(nonOntResourceList.keySet());
        entityList.addAll(nonOntLiteralList.keySet());
        VerticalPanel innerPanel = new VerticalPanel();
        ClientRepositoryToolsManager.INSTANCE.retrieveLabels(entityList, (ClientRepositoryToolsManager.LabelsCallback)new /* Unavailable Anonymous Inner Class!! */);
        nonOntologyPanel.add((Widget)innerPanel);
        this.formPanel.add((Widget)nonOntologyPanel);
    }

    private HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    private HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    protected void createNonOntologyPanel(Map<EIEntity, Set<String>> nonOntologyLiteralProperties, Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties, Map<EIEntity, String> labelMap, VerticalPanel innerPanel) {
        VerticalPanel metaPanel = new VerticalPanel();
        VerticalPanel otherPanel = new VerticalPanel();
        this.designPanel(metaPanel, "Metadata properties:");
        this.designPanel(otherPanel, "Other properties:");
        LabelValuesWidget eagleIUniqueId = new LabelValuesWidget("eagle-i unique ID");
        Anchor id = new Anchor(this.eiInstance.getInstanceURI().toString(), this.eiInstance.getInstanceURI().toString(), "_blank");
        eagleIUniqueId.add((Widget)id);
        innerPanel.add((Widget)eagleIUniqueId);
        if (this.shouldShowReadOnlyProperties) {
            innerPanel.add((Widget)metaPanel);
            innerPanel.add((Widget)otherPanel);
            Map readOnlyLiterals = this.eiInstance.getReadOnlyLiteralProperties();
            Map readOnlyResources = this.eiInstance.getReadOnlyResourceProperties();
            this.drawReadOnlyProperties(labelMap, metaPanel, readOnlyLiterals, readOnlyResources);
        }
        VerticalPanel panelToUse = this.shouldShowReadOnlyProperties ? otherPanel : innerPanel;
        for (EIEntity propEntity : nonOntologyLiteralProperties.keySet()) {
            this.drawNonOntologyLiteralProperty(propEntity, nonOntologyLiteralProperties.get(propEntity), labelMap, panelToUse);
        }
        for (EIEntity propEntity : nonOntologyResourceProperties.keySet()) {
            this.drawNonOntologyResourceProperty(propEntity, nonOntologyResourceProperties.get(propEntity), labelMap, panelToUse);
        }
    }

    private void drawReadOnlyProperties(Map<EIEntity, String> labelMap, VerticalPanel metaPanel, Map<EIEntity, String> readOnlyLiterals, Map<EIEntity, EIURI> readOnlyResources) {
        for (EIEntity propEntity : readOnlyLiterals.keySet()) {
            this.drawNonOntologyLiteralProperty(propEntity, (Set)this.makeSetFromSingle(readOnlyLiterals.get(propEntity)), labelMap, metaPanel);
        }
        for (EIEntity propEntity : readOnlyResources.keySet()) {
            this.drawNonOntologyResourceProperty(propEntity, (Set)this.makeSetFromSingleURI(readOnlyResources.get(propEntity)), labelMap, metaPanel);
        }
    }

    private void designPanel(VerticalPanel panel, String header) {
        panel.setStyleName("formPanel");
        Label propHeader = new Label(header);
        propHeader.setStyleName("nonOntologyPropertyLabel");
        panel.add((Widget)propHeader);
    }
}

