/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.ui.EIFormsPanel;
import org.eaglei.datatools.client.ui.EIResourceWidget;
import org.eaglei.datatools.client.ui.EditWidget;
import org.eaglei.datatools.client.ui.EditWidgetCollection;
import org.eaglei.datatools.client.ui.ObjectWidget;
import org.eaglei.datatools.client.ui.TextAreaWidget;
import org.eaglei.datatools.client.ui.TextWidget;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class EditFormsPanel
extends EIFormsPanel {
    private EIClass eiClass;
    private final List<EIEntity> dataPropEntityList = new ArrayList();
    private final List<EIEntity> booleanPropEntityList = new ArrayList();
    private final List<EIEntity> objPropEntityList = new ArrayList();
    private final Map<EIEntity, List<EIClass>> objectProperties = new HashMap();
    private final EIURI labUri;
    private final boolean isNew;
    public static final String EI_LAB = "http://purl.obolibrary.org/obo/ERO_0000001";
    public static final String EI_CORE_LAB = "http://purl.obolibrary.org/obo/ERO_0000002";

    public static EditFormsPanel createEditForm(EIInstance instance, EIClass eiClass, EIURI labUri) {
        return new EditFormsPanel(instance, eiClass, labUri, false);
    }

    public static EditFormsPanel createNewForm(EIInstance instance, EIClass eiClass, EIURI labUri) {
        return new EditFormsPanel(instance, eiClass, labUri, true);
    }

    private EditFormsPanel(EIInstance instance, EIClass eiClass, EIURI labUri, boolean isNew) {
        super(instance);
        this.shouldShowReadOnlyProperties = false;
        this.eiClass = eiClass;
        this.initializePropertyLists();
        this.isNew = isNew;
        this.labUri = labUri == null || labUri.toString().equals("") ? null : labUri;
        Log.info((String)("have lab? " + this.hasLabUri()));
    }

    public boolean isNewForm() {
        return this.isNew;
    }

    void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues) {
        if (propertyEntity == this.propertyName) {
            this.formPanel.add((Widget)TextWidget.makeLabelTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyValues.iterator().next()));
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (this.booleanPropEntityList.contains(propertyEntity)) {
                this.formPanel.add((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, null));
            } else {
                this.formPanel.add((Widget)new EditWidgetCollection(this.eiInstance, propertyEntity, (EditWidget)TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, null)));
            }
        } else {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            for (String value : propertyValues) {
                if (this.booleanPropEntityList.contains(propertyEntity)) {
                    fields.addWithoutModifiers((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
                    continue;
                }
                fields.addWidget((EditWidget)TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
            }
            this.formPanel.add((Widget)fields);
        }
    }

    void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        if (!propertyEntity.getURI().toString().equals("http://eagle-i.org/ont/datatools/1.0/user_comments") && !propertyEntity.getURI().toString().equals("http://purl.obolibrary.org/obo/IAO_0000232")) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            nonOntologyPanel.add((Widget)fields);
            for (String value : propertyValues) {
                fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
            }
        }
    }

    void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIURI> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
        nonOntologyPanel.add((Widget)fields);
        for (EIURI value : propertyValues) {
            fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (EIURI)value));
        }
    }

    void drawObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues) {
        if (propertyEntity.getLabel().equals("Type")) {
            this.drawTypeProperty();
        } else if (this.objectProperties.get(propertyEntity) != null && ((List)this.objectProperties.get(propertyEntity)).size() > 0) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            this.formPanel.add((Widget)fields);
            if (((List)this.objectProperties.get(propertyEntity)).size() == 1) {
                this.drawSingleObjectProperty(propertyEntity, propertyValues, fields);
            } else {
                Log.info((String)(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : Integer.valueOf(propertyValues.size())) + "entries"));
                if (propertyValues == null || propertyValues.size() == 0) {
                    this.createWidgetForMultiRanges(propertyEntity, "", fields);
                } else {
                    for (EIURI selectedUri : propertyValues) {
                        this.createWidgetForMultiRanges(propertyEntity, selectedUri.toString(), fields);
                    }
                }
            }
        }
    }

    private void drawSingleObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues, EditWidgetCollection fields) {
        EIClass range = (EIClass)((List)this.objectProperties.get(propertyEntity)).iterator().next();
        if (this.hasLabUri() && this.isLabProperty(range)) {
            Log.info((String)("making disabled widget for lab uri '" + this.labUri + "' property " + range.getEntity().getLabel()));
            this.eiInstance.addObjectProperty(propertyEntity, this.labUri);
            this.createWidgetForRange(propertyEntity, range, this.labUri.toString(), fields, true);
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (this.isLabProperty(range)) {
                Log.info((String)("drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab"));
            }
            this.createWidgetForRange(propertyEntity, range, "", fields, false);
        } else {
            if (this.isLabProperty(range)) {
                Log.info((String)("drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab"));
            }
            for (EIURI selectedUri : propertyValues) {
                this.createWidgetForRange(propertyEntity, range, selectedUri.toString(), fields, false);
            }
        }
    }

    private void drawTypeProperty() {
        HorizontalPanel temp = new HorizontalPanel();
        this.formPanel.add((Widget)temp);
        ClientOntologyToolsManager.INSTANCE.getRootSuperClass(this.eiInstance.getInstanceClass(), (ClientOntologyToolsManager.EISuperClassCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createWidgetForMultiRanges(EIEntity propertyEntity, String selectedUri, EditWidgetCollection fields) {
        Log.info((String)("making multi-range widget with " + ((List)this.objectProperties.get(propertyEntity)).size() + " ranges"));
        ObjectWidget widget = new ObjectWidget(this.eiInstance, propertyEntity, (List)this.objectProperties.get(propertyEntity), selectedUri);
        fields.addWidget((EditWidget)widget);
    }

    private void createWidgetForRange(EIEntity propertyEntity, EIClass range, String selectedUriString, EditWidgetCollection fields, boolean isLab) {
        if (range.isEagleIResource()) {
            EIResourceWidget resourceWidget = new EIResourceWidget(this.eiInstance, propertyEntity, range, selectedUriString, true);
            fields.addWidget((EditWidget)resourceWidget, isLab);
            if (isLab) {
                resourceWidget.disable();
            }
        } else {
            WidgetUtils.addTermWidgetToPanel((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (EIClass)range, (String)selectedUriString, (EditWidgetCollection)fields, (boolean)true);
        }
    }

    public void onLogIn(String username, String userUri) {
    }

    public void onLogOut() {
    }

    Collection<EIEntity> getDataTypeEntities() {
        return this.dataPropEntityList;
    }

    Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        return this.eiInstance.getNonOntologyLiteralProperties().keySet();
    }

    Collection<EIEntity> getNonOntologyResourcePropEntities() {
        return this.eiInstance.getNonOntologyResourceProperties().keySet();
    }

    Collection<EIEntity> getObjectTypeEntities() {
        return this.objPropEntityList;
    }

    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        EIEntity comments = EIEntity.create((String)"http://eagle-i.org/ont/datatools/1.0/user_comments", (String)"Comments");
        EIEntity curatorComments = EIEntity.create((String)"http://purl.obolibrary.org/obo/IAO_0000232", (String)"Curator note");
        String commentValue = nonOntologyLiteralProperties.containsKey(comments) ? nonOntologyLiteralProperties.get(comments).iterator().next() : null;
        TextAreaWidget commentsArea = new TextAreaWidget(this.eiInstance, comments, commentValue);
        this.formPanel.add((Widget)commentsArea);
        String curatorValue = nonOntologyLiteralProperties.containsKey(curatorComments) ? nonOntologyLiteralProperties.get(curatorComments).iterator().next() : null;
        TextAreaWidget curatorArea = new TextAreaWidget(this.eiInstance, curatorComments, curatorValue);
        this.formPanel.add((Widget)curatorArea);
    }

    private void initializePropertyLists() {
        this.dataPropEntityList.clear();
        this.objPropEntityList.clear();
        this.objectProperties.clear();
        this.booleanPropEntityList.clear();
        ClientOntologyToolsManager.INSTANCE.getProperties(this.eiClass, (ClientOntologyToolsManager.PropertyCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean isLabProperty(EIClass range) {
        EIEntity entity = range.getEntity();
        return entity.getURI().toString().equals(EI_LAB) || entity.getURI().toString().equals("core laboratory");
    }

    protected boolean hasLabUri() {
        return this.labUri != null && !this.labUri.toString().equals("");
    }

    static /* synthetic */ EIClass access$002(EditFormsPanel x0, EIClass x1) {
        x0.eiClass = x1;
        return x0.eiClass;
    }

    static /* synthetic */ void access$100(EditFormsPanel x0) {
        x0.initializePropertyLists();
    }

    static /* synthetic */ List access$200(EditFormsPanel x0) {
        return x0.dataPropEntityList;
    }

    static /* synthetic */ List access$300(EditFormsPanel x0) {
        return x0.booleanPropEntityList;
    }

    static /* synthetic */ List access$400(EditFormsPanel x0) {
        return x0.objPropEntityList;
    }

    static /* synthetic */ Map access$500(EditFormsPanel x0) {
        return x0.objectProperties;
    }
}

