/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.MainPanel;
import org.eaglei.datatools.client.ui.WorkFlowConstants;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class ResourcesGrid
extends FlexTable {
    public static final String[] RESOURCE_COLUMN_NAMES = new String[]{"Resource Name", "Type", "Date Added", "Status", "", ""};
    private String type;
    private String userUri;
    public EIInstance[] aryInstance;
    private CheckBox[] chkBoxRefAry;
    FilterPanel filterPanel;
    private List<String> editableReadableStates;

    public ResourcesGrid(String type, FilterPanel fp, String userUri) {
        this.type = type;
        this.filterPanel = fp;
        this.userUri = userUri;
        this.initializeEditableStates();
        this.createGrid();
    }

    public ResourcesGrid(String userUri, String type, boolean isLab) {
        this.type = type;
        this.userUri = userUri;
        this.initializeEditableStates();
        this.setStyleName("listGrid");
        try {
            MainPanel.glasspane.show();
            MainPanel.glasspane.add((Widget)new Image("images/ajax-loader.gif"));
            ClientRepositoryToolsManager.INSTANCE.getInstancesForLab(userUri, type, (ClientRepositoryToolsManager.EIInstancesForLabCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResourcesGrid(List<EIInstance> instances, String type) {
        this.type = type;
        this.init(instances);
    }

    public ResourcesGrid(List<EIInstance> instances) {
        this.init(instances);
    }

    private void init(List<EIInstance> instances) {
        this.initializeEditableStates();
        this.setStyleName("listGrid");
        int i = 0;
        int row = 0;
        this.makeResultGrid(instances, i, row);
    }

    private void makeResultGrid(List<EIInstance> instances, int i, int row) {
        for (String colName : RESOURCE_COLUMN_NAMES) {
            this.getCellFormatter().setStyleName(row, i, "listGridHeader");
            this.setHTML(row, i++, "<b>" + colName + "</b>");
        }
        if (!(this.type != null && this.type.equals("http://purl.obolibrary.org/obo/ERO_0000001") || History.getToken().contains("http://purl.obolibrary.org/obo/ERO_0000001"))) {
            ListBox actionList = this.makeListBoxOfAction();
            this.getCellFormatter().setStyleName(row, i, "listGridHeader");
            this.setWidget(row, i++, (Widget)actionList);
        }
        row = this.getRowCount();
        this.aryInstance = new EIInstance[instances.size()];
        this.chkBoxRefAry = new CheckBox[instances.size()];
        Iterator<EIInstance> i$ = instances.iterator();
        while (i$.hasNext()) {
            EIInstance instance;
            this.aryInstance[row - 1] = instance = i$.next();
            this.createInstanceRow(row, instance);
            ++row;
        }
    }

    private ListBox makeListBoxOfAction() {
        WorkFlowConstants wfc = new WorkFlowConstants();
        List stateList = ClientRepositoryToolsManager.INSTANCE.getEditableStates();
        Iterator iter = stateList.iterator();
        ListBox actionList = new ListBox();
        actionList.addItem("Workflow Action");
        while (iter.hasNext()) {
            String stateUri = (String)iter.next();
            String state = wfc.getStatusTypeByStatusURI(stateUri);
            if ("In curation".equals(state)) {
                actionList.addItem("Publish");
                continue;
            }
            if ("Draft".equals(state)) {
                actionList.addItem("Send to Curation");
                continue;
            }
            if (!"Withdrawn".equals(state)) continue;
            actionList.addItem("Withdraw");
        }
        if (ClientRepositoryToolsManager.INSTANCE.canEdit("In curation")) {
            actionList.addItem("Return to Draft");
        }
        actionList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionList;
    }

    private void initializeEditableStates() {
        this.editableReadableStates = new ArrayList(4);
        WorkFlowConstants wfc = new WorkFlowConstants();
        if (ClientRepositoryToolsManager.INSTANCE.canEdit("http://eagle-i.org/ont/repo/1.0/WFS_Draft")) {
            this.editableReadableStates.add(wfc.getStatusType("http://eagle-i.org/ont/repo/1.0/WFS_Draft"));
        }
        if (ClientRepositoryToolsManager.INSTANCE.canEdit("http://eagle-i.org/ont/repo/1.0/WFS_Curation")) {
            this.editableReadableStates.add(wfc.getStatusType("http://eagle-i.org/ont/repo/1.0/WFS_Curation"));
        }
        if (ClientRepositoryToolsManager.INSTANCE.canEdit("http://eagle-i.org/ont/repo/1.0/WFS_Published")) {
            this.editableReadableStates.add(wfc.getStatusType("http://eagle-i.org/ont/repo/1.0/WFS_Published"));
        }
        if (ClientRepositoryToolsManager.INSTANCE.canEdit("http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn")) {
            this.editableReadableStates.add(wfc.getStatusType("http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn"));
        }
    }

    private void createGrid() {
        this.setStyleName("listGrid");
        int i = 0;
        int row = 0;
        for (String colName : RESOURCE_COLUMN_NAMES) {
            this.getCellFormatter().setStyleName(row, i, "listGridHeader");
            this.setHTML(row, i++, "<b>" + colName + "</b>");
        }
        if (!(this.type != null && this.type.equals("http://purl.obolibrary.org/obo/ERO_0000001") || History.getToken().contains("http://purl.obolibrary.org/obo/ERO_0000001"))) {
            ListBox actionList = this.makeListBoxOfAction();
            this.getCellFormatter().setStyleName(row, i, "listGridHeader");
            this.setWidget(row, i++, (Widget)actionList);
        }
        if (this.type != null) {
            MainPanel.glasspane.show();
            MainPanel.glasspane.add((Widget)new Image("images/ajax-loader.gif"));
            ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(this.userUri, EIURI.create((String)this.type), (ClientRepositoryToolsManager.EIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (this.userUri != null) {
            MainPanel.glasspane.show();
            MainPanel.glasspane.add((Widget)new Image("images/ajax-loader.gif"));
            ClientRepositoryToolsManager.INSTANCE.getAllResources(this.userUri, (ClientRepositoryToolsManager.EIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void createInstanceRow(int row, EIInstance instance) {
        String deleteHtml = "<a>delete</a>";
        String claimHtml = "<a>claim</a>";
        String editHtml = "<a>edit</a>";
        String withdrawHtml = "<a>withdraw</a>";
        String publishHtml = "<a>publish</a>";
        WorkFlowConstants wfc = new WorkFlowConstants();
        EIURI ownerUri = instance.getWFOwner();
        int col = 0;
        this.setHTML(row, col++, "<a>" + instance.getInstanceLabel() + "</a>");
        this.setText(row, col++, instance.getInstanceType().getLabel());
        if (instance.getCreationDate() != null) {
            this.setText(row, col++, this.formatDate(instance.getCreationDate()));
        }
        String status = instance.getWFState() == null ? "" : wfc.getStatusType(instance.getWFState().toString());
        this.setText(row, col++, status);
        if (status.equals("Published")) {
            if (this.editableReadableStates.contains("Published")) {
                this.setHTML(row, col++, "<a>edit</a>");
                this.setHTML(row, col++, "");
            } else {
                this.setHTML(row, col++, "");
                this.setHTML(row, col++, "");
            }
        } else if (status.equals("Withdrawn")) {
            if (this.editableReadableStates.contains("Withdrawn")) {
                this.setHTML(row, col++, "<a>edit</a>");
                this.setHTML(row, col++, "");
            } else {
                this.setHTML(row, col++, "");
                this.setHTML(row, col++, "");
            }
        } else if (ownerUri == null && this.editableReadableStates.contains(status)) {
            this.setHTML(row, col++, "<a>claim</a>");
            this.setHTML(row, col++, "");
        } else if (this.editableReadableStates.contains(status)) {
            this.setHTML(row, col++, "<a>edit</a>");
            this.setHTML(row, col++, "<a>delete</a>");
        } else {
            this.setHTML(row, col++, "");
            this.setHTML(row, col++, "");
        }
        if (!(this.type != null && this.type.equals("http://purl.obolibrary.org/obo/ERO_0000001") || History.getToken().contains("http://purl.obolibrary.org/obo/ERO_0000001"))) {
            CheckBox checkBox = new CheckBox();
            this.setWidget(row, col++, (Widget)checkBox);
            this.chkBoxRefAry[row - 1] = checkBox;
            checkBox.setVisible(this.shouldDisplayCheckBox(ownerUri, status));
        }
        if (this.type.equals("http://purl.obolibrary.org/obo/ERO_0000001")) {
            this.setText(row, col++, "LaboratoryInstance");
            this.getCellFormatter().setStyleName(row, col - 1, "hiddenURI");
        }
        this.setText(row, col++, instance.getEntity().getURI().toString());
        this.getCellFormatter().setStyleName(row, col - 1, "hiddenURI");
    }

    private boolean shouldDisplayCheckBox(EIURI ownerUri, String status) {
        if (!Datatools.canUserChangeState((String)status)) {
            return false;
        }
        if (ownerUri != null) {
            return true;
        }
        return "http://eagle-i.org/ont/repo/1.0/WFS_Published".equals(status) || "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn".equals(status) || "Published".equals(status) || "Withdrawn".equals(status);
    }

    public EIInstance getInstanceInGridByRow(int row) {
        return this.aryInstance[row];
    }

    String formatDate(String dt) {
        String date = "";
        if (dt != null) {
            date = dt.substring(0, dt.indexOf("T"));
        }
        return date;
    }

    private void handleLoginRequired() {
        this.clear();
        MainPanel.handleLoginRequired();
    }

    public CheckBox[] getChkBoxRefAry() {
        return this.chkBoxRefAry;
    }

    public void setChkBoxRefAry(CheckBox[] chkBoxRefAry) {
        this.chkBoxRefAry = chkBoxRefAry;
    }

    static /* synthetic */ void access$000(ResourcesGrid x0, List x1, int x2, int x3) {
        x0.makeResultGrid(x1, x2, x3);
    }

    static /* synthetic */ String access$100(ResourcesGrid x0) {
        return x0.type;
    }

    static /* synthetic */ CheckBox[] access$202(ResourcesGrid x0, CheckBox[] x1) {
        x0.chkBoxRefAry = x1;
        return x1;
    }

    static /* synthetic */ void access$300(ResourcesGrid x0) {
        x0.handleLoginRequired();
    }
}

