/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.EIFormsPanel;
import org.eaglei.datatools.client.ui.LabelValuesWidget;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class ViewFormsPanel
extends EIFormsPanel {
    public ViewFormsPanel(EIInstance instance) {
        super(instance);
        this.shouldShowReadOnlyProperties = true;
        this.finishSetup();
    }

    public void onLogIn(String username, String userUri) {
    }

    public void onLogOut() {
    }

    void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity);
        this.formPanel.add((Widget)widget);
        for (String value : propertyValues) {
            widget.add(this.handleTextProperty(value));
        }
    }

    private Widget handleTextProperty(String value) {
        Anchor resourceURL = null;
        Label valueField = new Label();
        valueField.setStyleName("formLabelValue");
        if (value.startsWith("www") || value.startsWith("http")) {
            resourceURL = new Anchor(WidgetUtils.formatText((String)value), WidgetUtils.formatText((String)value), "_blank");
        } else {
            valueField.setText(WidgetUtils.formatText((String)value));
        }
        return resourceURL == null ? valueField : resourceURL;
    }

    void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (String value : propertyValues) {
            widget.add(this.handleTextProperty(value));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIURI> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (EIURI propUri : propertyValues) {
            widget.add(this.handleTextProperty(propUri.toString()));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    void drawObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity);
        this.formPanel.add((Widget)widget);
        for (EIURI uri : propertyValues) {
            ClientRepositoryToolsManager.INSTANCE.retrieveLabel(uri, (ClientRepositoryToolsManager.ResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    Collection<EIEntity> getDataTypeEntities() {
        return this.eiInstance.getDatatypeProperties().keySet();
    }

    Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        return this.eiInstance.getNonOntologyLiteralProperties().keySet();
    }

    Collection<EIEntity> getNonOntologyResourcePropEntities() {
        return this.eiInstance.getNonOntologyResourceProperties().keySet();
    }

    Collection<EIEntity> getObjectTypeEntities() {
        return this.eiInstance.getObjectProperties().keySet();
    }

    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
    }
}

