/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.client.rpc.OntologyToolsModelService;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.RESTRepositoryProviderFactory;
import org.eaglei.datatools.model.DataToolsEIOntModel;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProviderFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RepositoryToolsModelServlet
extends RemoteServiceServlet
implements RepositoryToolsModelService,
OntologyToolsModelService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryToolsModelServlet.class);
    private RepositoryProvider provider = null;
    private DataToolsEIOntModel datatoolsEIOntModel;
    private DatatoolsConfiguration config;

    public void init() throws ServletException {
        this.config = this.getConfiguration();
        try {
            if (this.config != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"about to create provider");
                }
                this.provider = this.createProvider();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"about to load defaults (null config)");
                }
                this.loadDefaults();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error initializing RepositoryToolsModelServlet: " + e));
            throw new ServletException((Throwable)e);
        }
        this.initializeOntology();
        this.lazyLoadFactories();
        log.info((Object)"init succesful");
    }

    private void initializeOntology() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        DataToolsEIOntModel.INSTANCE = this.datatoolsEIOntModel = (DataToolsEIOntModel)ctx.getBean(DataToolsEIOntModel.class);
    }

    private RepositoryProvider createProvider() throws Exception {
        String providerFactoryClass = this.config.getDatatoolsRepositoryProviderFactory();
        Class<?> factoryClass = Class.forName(providerFactoryClass);
        RepositoryProviderFactory factory = (RepositoryProviderFactory)factoryClass.newInstance();
        return factory.createRepositoryProvider(this.config);
    }

    private void lazyLoadFactories() {
        EIInstanceFactory.getInstance();
    }

    private void loadDefaults() throws Exception {
        log.info((Object)"Loading default provider, RESTProvider: ");
        RESTRepositoryProviderFactory factory = new RESTRepositoryProviderFactory();
        this.provider = factory.createRepositoryProvider(this.config);
        log.info((Object)("Loading default provider, RESTProvider: " + factory.toString()));
    }

    public void createInstance(String session, EIInstance instance) throws Exception {
        try {
            if (instance == null) {
                log.error((Object)"trying to create a null instance");
            }
            this.provider.createInstance(session, instance);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            for (StackTraceElement element : e.getStackTrace()) {
                log.error((Object)element.toString());
            }
            throw new LoggedException(e.getMessage());
        }
    }

    public void deleteInstance(String session, EIInstance instance) throws Exception {
        try {
            this.provider.deleteInstance(session, instance);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String updateInstance(String session, EIInstance instance, String token) throws Exception {
        try {
            return this.provider.updateInstance(session, instance, token);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] login(String user, String password) throws Exception {
        try {
            return this.provider.login(user, password);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void logout(String session) throws Exception {
        try {
            this.provider.logout(session);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] whoami(String session) throws Exception {
        try {
            return this.provider.whoami(session);
        }
        catch (Exception e) {
            log.error((Object)("whoami exception " + e));
            throw new LoggedException(e.getMessage());
        }
    }

    private DatatoolsConfiguration getConfiguration() throws ServletException {
        String propFile = System.getProperty("datatools.config.file");
        if (propFile == null) {
            propFile = "datatools.prop";
        }
        log.debug((Object)("Using properties file " + propFile));
        URL configURL = this.getClass().getClassLoader().getResource(propFile);
        if (configURL == null) {
            log.error((Object)("Could not locate " + propFile + " on classpath "));
            throw new ServletException("Could not locate " + propFile + " on classpath ");
        }
        try {
            File configFile = new File(configURL.toURI());
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            log.error((Object)("Error loading configuration from " + configURL + " " + e));
            throw new ServletException("Error loading configuration from " + configURL + " " + e);
        }
    }

    public boolean isOnline() {
        return this.provider.isOnline();
    }

    public List<EIInstance> getAllResources(String session, String rnav) throws Exception {
        try {
            return this.provider.getAllResources(session, rnav);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> getResourcesOfClass(String session, String rnav, EIURI classUri) throws Exception {
        try {
            return this.provider.getResourcesOfClass(session, rnav, classUri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> EIQuery(String session, String query) throws Exception {
        try {
            return this.provider.EIQuery(session, query);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> getInstancesForLab(String session, String rnav, String labURI) throws Exception {
        try {
            return this.provider.getInstancesForLab(session, rnav, labURI);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void uploadInstances(String session, String rdf) throws Exception {
        this.provider.uploadInstances(session, rdf);
    }

    public EIInstance getEmptyEIInstance(String session, EIURI classUri, EIEntity instanceEntity) throws Exception {
        try {
            return this.provider.getEmptyEIInstance(session, classUri, instanceEntity);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getEmptyEIInstance(String session, EIURI classUri) throws Exception {
        try {
            EIInstance instance = this.provider.getEmptyEIInstance(session, classUri);
            if (instance.getInstanceClass() == null) {
                instance.setInstanceClass(this.datatoolsEIOntModel.getClass(classUri));
            }
            return instance;
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance deepCopy(String session, EIURI originalUri) throws Exception {
        return this.provider.deepCopy(session, originalUri);
    }

    public List<EIURI> getNewInstanceID(String session, int count) throws Exception {
        try {
            return this.provider.getNewInstanceID(session, count);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String query(String session, String sparql) throws Exception {
        try {
            return this.provider.query(session, sparql);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getInstance(String session, EIURI instanceID) throws Exception {
        return this.provider.getInstance(session, instanceID);
    }

    public String claim(String session, String uri, String claimant) throws Exception {
        try {
            return this.provider.claim(session, uri, claimant);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String promote(String session, String uri, String newState) throws Exception {
        try {
            return this.provider.promote(session, uri, newState);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] bulkPromote(String session, String[] uri, String newState) throws Exception {
        try {
            String[] retStrAry = new String[uri.length];
            int i = 0;
            for (String strUri : uri) {
                retStrAry[i] = this.provider.promote(session, strUri, newState);
                ++i;
            }
            return retStrAry;
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] getWFStates(String session, String user) throws Exception {
        try {
            return this.provider.getWFStates(session, user);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstance> getFilterQuery(String session, String user, EIURI classUri, EIURI state, EIURI lab) throws Exception {
        try {
            return this.provider.getFilterQuery(session, user, classUri, state, lab);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String retrieveLabel(String session, EIURI uri) throws Exception {
        try {
            return this.provider.retrieveLabel(session, uri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public Map<EIEntity, String> retrieveLabels(String session, List<EIEntity> entities) throws Exception {
        try {
            return this.provider.retrieveLabels(session, entities);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public Map<EIURI, String> retrieveUriLabels(String session, List<EIURI> uris) throws Exception {
        return this.provider.retrieveUriLabels(session, uris);
    }

    public EIClass getRootSuperclassForInstanceUri(String session, EIURI instanceUri) throws Exception {
        EIInstance instance = this.provider.getInstance(session, instanceUri);
        if (instance == null) {
            return null;
        }
        return this.getRootSuperClass(instance.getInstanceClass());
    }

    public List<EIClass> getTopLevelClasses() {
        try {
            return this.datatoolsEIOntModel.getTopLevelClasses();
        }
        catch (Throwable t) {
            log.error((Object)"Error in getTopLevelClasses: ", t);
            return null;
        }
    }

    public EIClass getEIClass(EIURI uri) {
        return this.datatoolsEIOntModel.getClass(uri);
    }

    public List<EIProperty> getProperties(EIURI classId) {
        try {
            List prop = this.datatoolsEIOntModel.getProperties(classId);
            return this.datatoolsEIOntModel.getProperties(classId);
        }
        catch (Throwable t) {
            log.error((Object)("Error in getProperties: " + classId), t);
            return null;
        }
    }

    public List<EIProperty> getProperties(EIURI classId, String groupUri) {
        try {
            return this.datatoolsEIOntModel.getProperties(classId, groupUri);
        }
        catch (Throwable t) {
            log.error((Object)("Error in getProperties: " + classId), t);
            return null;
        }
    }

    public List<EIClass> getSubClasses(EIURI classId, boolean resolveReference) {
        try {
            return this.datatoolsEIOntModel.getSubClasses(classId);
        }
        catch (Throwable t) {
            log.error((Object)"Error in getTopLevelClasses: ", t);
            return null;
        }
    }

    public List<String> getClassDefinitions(List<EIURI> classURIs) throws Exception {
        return this.datatoolsEIOntModel.getClassDefinitions(classURIs);
    }

    public EIClass getRootSuperClass(EIClass eclass) {
        while (eclass.hasSuperClass()) {
            eclass = this.datatoolsEIOntModel.getSuperClass(eclass);
        }
        return eclass;
    }

    public EIClass getSuperClass(EIClass eclass) {
        eclass = this.datatoolsEIOntModel.getSuperClass(eclass);
        return eclass;
    }
}

