package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.LabelsCallback;
import org.eaglei.datatools.client.ui.widgets.LabelValuesWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;


public abstract class EIFormsPanel extends Composite {
	
	private VerticalPanel outerFormPanel = new VerticalPanel();
	protected VerticalPanel formPanel= new VerticalPanel();
	protected EIInstance eiInstance;
	protected EIClass rootSuperClass;
	
	abstract void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues);
	abstract void drawObjectProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues);
	abstract void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel);
	abstract void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel);
	abstract protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties);
	abstract Collection<EIEntity> getDataTypeEntities();
	abstract Collection<EIEntity> getObjectTypeEntities();
	abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();
	abstract Collection<EIEntity> getNonOntologyResourcePropEntities();
	abstract void setButtonState();
	
	protected boolean shouldShowReadOnlyProperties;
	protected ButtonsPanel buttonPanel;
	protected FormRedisplay redisplayCallbacks;
	
	public EIFormsPanel(EIInstance instance, FormRedisplay redisplay) {
		initWidget(outerFormPanel);
		outerFormPanel.setStyleName("formPanel");
		formPanel.setStyleName("formPanel");
		this.eiInstance = instance;
		buttonPanel = new ButtonsPanel(eiInstance, redisplay);
		outerFormPanel.add(buttonPanel);
		outerFormPanel.add(formPanel);
		setButtonState();
		this.redisplayCallbacks = redisplay;
		buttonPanel.copyResourceButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				redisplayCallbacks.drawAfterDuplicate(eiInstance);
			}
		});
	}
 
	protected void finishSetup() {
		constructForm();
		formPanel.setStyleName("formPanel");
		//formPanel.setSpacing(30);
		formPanel.setHeight("50");
	}
	
	public EIInstance getInstance() {
		return eiInstance;
	}
	
	protected void constructForm() {
		 Map<EIEntity, Set<String>> dataTypeProperties = eiInstance.getDatatypeProperties();
		 Map<EIEntity, Set<EIEntity>> objectTypeProperties = eiInstance.getObjectProperties();
		 final Map<EIEntity, Set<String>> nonOntologyLiteralProperties = eiInstance.getNonOntologyLiteralProperties();
		 final Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties = eiInstance.getNonOntologyResourceProperties();
		 
		 String labelPrefix;
			if(WidgetUtils.isLabProperty(eiInstance.getInstanceType()))
				labelPrefix = "Laboratory";
			else
				labelPrefix = rootSuperClass.getEntity().getLabel();
		 
		 
		 final EIEntity namePropEntity = EIEntity.create(DatatoolsUIConstants.propertyName.getURI(), 
				 WidgetUtils.getExtendedPropertyLabel(labelPrefix, 
						 DatatoolsUIConstants.propertyName.getLabel()));
		 drawDataProperty(namePropEntity, makeSetFromSingle(eiInstance.getInstanceLabel()));
		 
		 final EIEntity typePropEntity = EIEntity.create(DatatoolsUIConstants.propertyType.getURI(),
				 WidgetUtils.getExtendedPropertyLabel(labelPrefix,
						 DatatoolsUIConstants.propertyType.getLabel()));
		 drawObjectProperty(typePropEntity, makeSetFromSingleEntity(eiInstance.getInstanceType()));
		 
		 for(EIEntity propEntity:getDataTypeEntities()) {
			 drawDataProperty(propEntity, dataTypeProperties.get(propEntity));
		 }
		 
		 for(EIEntity propEntity:getObjectTypeEntities()) {
			 drawObjectProperty(propEntity, objectTypeProperties.get(propEntity));
		 }
		
		 drawExtraFields(nonOntologyLiteralProperties);
		 
		 final DisclosurePanel nonOntologyPanel = new DisclosurePanel("Information for data curators");
		 
		 final Map<EIEntity, Set<String>> nonOntLiteralList = eiInstance.getNonOntologyLiteralProperties();
		 final Map<EIEntity, Set<EIEntity>> nonOntResourceList = eiInstance.getNonOntologyResourceProperties();
		 final List<EIEntity> entityList = new ArrayList<EIEntity>();
		 entityList.addAll(eiInstance.getReadOnlyLiteralProperties().keySet());
		 entityList.addAll(eiInstance.getReadOnlyResourceProperties().keySet());
		 entityList.addAll(nonOntResourceList.keySet());
		 entityList.addAll(nonOntLiteralList.keySet());
		
		 
		 final VerticalPanel innerPanel = new VerticalPanel();
		 ClientRepositoryToolsManager.INSTANCE.retrieveLabels(entityList, new LabelsCallback() {
			@Override
			public void onSuccess(Map<EIEntity, String> labelMap) {
				createNonOntologyPanel(nonOntologyLiteralProperties, nonOntologyResourceProperties, labelMap, innerPanel);
			}
		 });
		 
		nonOntologyPanel.add(innerPanel);
		formPanel.add(nonOntologyPanel); 
			
	 }

	private HashSet<String> makeSetFromSingle(String value) {
		return new HashSet<String>(Arrays.asList(new String[]{value}));
	}
	
	private HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
		return new HashSet<EIURI>(Arrays.asList(new EIURI[]{value}));
	}

	private HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
		return new HashSet<EIEntity>(Arrays.asList(new EIEntity[]{value}));
	}

	 protected void createNonOntologyPanel(Map<EIEntity, Set<String>> nonOntologyLiteralProperties,
				Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties, Map<EIEntity, String> labelMap, VerticalPanel innerPanel) {
		 
		 final VerticalPanel metaPanel = new VerticalPanel();
		 final VerticalPanel otherPanel = new VerticalPanel();
		 designPanel(metaPanel,"Metadata properties:");
		 designPanel(otherPanel,"Other properties:");
		 
		 LabelValuesWidget eagleIUniqueId = new LabelValuesWidget("eagle-i unique ID");
		 Anchor id = new Anchor(eiInstance.getInstanceURI().toString(), eiInstance.getInstanceURI().toString(), "_blank");
		 eagleIUniqueId.add(id);
		 innerPanel.add(eagleIUniqueId);
		 if (shouldShowReadOnlyProperties) {
			 innerPanel.add(metaPanel);
			 innerPanel.add(otherPanel);
			 
			 Map<EIEntity, String> readOnlyLiterals = eiInstance.getReadOnlyLiteralProperties();
			 Map<EIEntity, EIEntity> readOnlyResources = eiInstance.getReadOnlyResourceProperties();
		 
			 drawReadOnlyProperties(labelMap, metaPanel, readOnlyLiterals, readOnlyResources);
		 }
		 
		 VerticalPanel panelToUse = shouldShowReadOnlyProperties ? otherPanel : innerPanel;
		 for(EIEntity propEntity:nonOntologyLiteralProperties.keySet()) {
			 drawNonOntologyLiteralProperty(propEntity, nonOntologyLiteralProperties.get(propEntity), labelMap, panelToUse);
		 }
		 
		 for(EIEntity propEntity:nonOntologyResourceProperties.keySet()) {
			 drawNonOntologyResourceProperty(propEntity, nonOntologyResourceProperties.get(propEntity), labelMap, panelToUse);
		 }
		 
	}

	private void drawReadOnlyProperties(Map<EIEntity, String> labelMap,
			final VerticalPanel metaPanel,
			Map<EIEntity, String> readOnlyLiterals,
			Map<EIEntity, EIEntity> readOnlyResources) {
		for (EIEntity propEntity: readOnlyLiterals.keySet()) {
			drawReadOnlyLiteralProperty(propEntity, makeSetFromSingle(readOnlyLiterals.get(propEntity)), labelMap, metaPanel);			 
		 }
		 
		 for (EIEntity propEntity: readOnlyResources.keySet()) {
			 drawReadOnlyResourceProperty(propEntity, makeSetFromSingleEntity(readOnlyResources.get(propEntity)), labelMap, metaPanel);			 
		 }
	}

	private void designPanel(final VerticalPanel panel, String header) {
		 panel.setStyleName("formPanel");
		 
		 Label propHeader = new Label(header);
		 propHeader.setStyleName("nonOntologyPropertyLabel");
		 panel.add(propHeader);
	}
	
	protected Widget handleReadOnlyTextProperty(String value){
		Anchor resourceURL = null; // For values that have external URIs
		Label valueField = new Label();
		valueField.setStyleName("formLabelValue");
		if (value.startsWith("www") || value.startsWith("http")) {
			resourceURL = new Anchor(WidgetUtils.formatText(value), WidgetUtils.formatText(value), "_blank");
		} else {
			valueField.setText(WidgetUtils.formatText(value));
		}
		
		return resourceURL == null ? valueField : resourceURL;
	}
	
	protected void drawReadOnlyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		String  propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
		
		LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for(String value:propertyValues) {
			widget.add(handleReadOnlyTextProperty(value));
		}
		nonOntologyPanel.add(widget); 
	}

	protected void drawReadOnlyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues,  Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		String  propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
		
		LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for(EIEntity propEntity:propertyValues) {
			if (propEntity != null && propEntity != EIEntity.NULL_ENTITY)
				widget.add(handleReadOnlyTextProperty(propEntity.getLabel())); 
		}
		nonOntologyPanel.add(widget); 
	}
	

	protected void getRootSuperClass() {
		ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(eiInstance.getInstanceClass(), new ClassCallback() {
			@Override
			public void onSuccess(EIClass result) {
				rootSuperClass = result;
				finishSetup();
			}
		});
	}
}
