package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SessionListener;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;

public class MainController implements ApplicationStateChangeListener {
	
	public static final String			DATATOOLS_FILTER	= "DatatoolsFilter";
	public static final String			DATATOOLS_CONTROLS	= "DatatoolsControls";
	
	public MainController() {
		ApplicationState.getInstance().addApplicationStateListener(this);
		onApplicationStateChange();
	}
	
	@Override
	public void onApplicationStateChange() {
		if (! ApplicationState.getInstance().hasUser()) {
			Log.info("no user!");
			Datatools.clearDataPanel();
			return;
		}
	/*	if (! ApplicationState.getInstance().isValid()) {
			Datatools.clearDataPanel();
			return;
		} */
		if (ApplicationState.getInstance().getMode() == Mode.list) {
			drawGrid();
		} else if (ApplicationState.getInstance().getMode() == Mode.view) {
			drawView();
		} else if (ApplicationState.getInstance().getMode() == Mode.edit) {
			drawEdit();
		} else if (ApplicationState.getInstance().getMode() == Mode.filter) {
			drawGrid();
		} else if (ApplicationState.getInstance().getMode() == Mode.resources) {
			Log.info("showing empty grid");
			Datatools.clearDataPanel();
			Datatools.showData(new EIResourcesGrid());
		} else if (ApplicationState.getInstance().getMode() == Mode.labs) {
			drawGrid();
		} 
	}
	
	protected void drawGrid() {
		Log.info("showing grid with mode " + ApplicationState.getInstance().getMode());
		Datatools.clearDataPanel();
		if (ApplicationState.getInstance().getMode() == Mode.resources) {
			Datatools.showData(new EIResourcesGrid());
			return;
		}

		if (ApplicationState.getInstance().getMode() != Mode.resources  && 
				ApplicationState.getInstance().getMode() != Mode.filter &&
				! ApplicationState.getInstance().hasLab() && 
				! ApplicationState.getInstance().hasType() && 
				! ApplicationState.getInstance().hasFilters()) {
			Log.info("no lab, no type, no filters, no grid!");
			Datatools.showData(new EIResourcesGrid());
			return;
		}
		
		EIURI typeUri, WFStateUri, labUri;
		if(ApplicationState.getInstance().getMode() == Mode.filter) {
			typeUri = ApplicationState.getInstance().getFilterTypeUri();
			WFStateUri = ApplicationState.getInstance().getFilterWorkflowUri();
			labUri = ApplicationState.getInstance().getFilterLabUri();
			Log.info("setting parameters for filter query: " + typeUri +", " + WFStateUri + ", " +labUri);
		} else {
			typeUri = ApplicationState.getInstance().getTypeUri();
			WFStateUri = EIURI.NULL_EIURI;
			labUri = ApplicationState.getInstance().getLabUri();
			Log.info("setting parameters for normal query: " + typeUri +", " + WFStateUri + ", " +labUri);
		}
		Datatools.showGlasspane();
		try {	
			
			ClientRepositoryToolsManager.INSTANCE.getFilterQuery(ApplicationState.getInstance().getUserURI().toString(), 
					typeUri, WFStateUri, labUri, ApplicationState.getInstance().isStrictlyFilteredByOwner(),
					new EIInstancesCallback() {
				@Override
				public void onSuccess(List<EIInstanceMinimal> result) {
					Datatools.hideGlasspane();
					Log.info("making EIResourcesGrid with list of length " + result.size());
					EIResourcesGrid grid = new EIResourcesGrid(result);
					Datatools.showData(grid);
				}
				@Override
				public void loginRequired() {
					Datatools.hideGlasspane();
					Datatools.handleLoginRequired();
				}			
			});
		}
		catch(Exception e) {
			Log.error(e.getMessage());
		}
	}
	
	protected void drawView() {
		Log.info("viewing " + ApplicationState.getInstance().getInstanceEntity());
		Datatools.clearDataPanel();
		Datatools.showData(FormsPanelFactory.generateViewForm(ApplicationState.getInstance().getInstanceUri()));
	}
	
	protected void drawEdit() {
		Log.info("editing " + ApplicationState.getInstance().getInstanceEntity());
		Datatools.clearDataPanel();
		if (! ApplicationState.getInstance().hasInstance())
			Datatools.showData(FormsPanelFactory.generateNewForm(ApplicationState.getInstance().getTypeUri()));
		else
			Datatools.showData(FormsPanelFactory.generateEditForm(ApplicationState.getInstance().getInstanceUri()));
	}

	public void onLogIn(String username, String userUri) {
		Log.info("main controller logged in, calling on AppStateChange; mode = " + ApplicationState.getInstance().getMode() + "; type = " + ApplicationState.getInstance().getTypeEntity());
		onApplicationStateChange();
	}

	public void onLogOut() {
		onApplicationStateChange();
	}
}
