package org.eaglei.datatools.client.ui;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.datatools.client.ui.widgets.LabelValuesWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Displays the Form for viewing. All the fields are disabled and no editing is
 * possible.
 * 
 */
public class ViewFormsPanel extends EIFormsPanel {
	private ViewFormRedisplay	viewRedisplay;
	public ViewFormsPanel(EIInstance instance, ViewFormRedisplay redisplay) {
		super(instance, redisplay);
		this.viewRedisplay = redisplay;
		shouldShowReadOnlyProperties = true;
		getRootSuperClass();
		//finishSetup();
	}
	
	@Override
	void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues) {
		LabelValuesWidget widget = new LabelValuesWidget(propertyEntity);
		formPanel.add(widget);
		for (String value : propertyValues) {
			widget.add(handleReadOnlyTextProperty(value));
		}
	}
	
	@Override
	void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
		LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for (String value : propertyValues) {
			widget.add(handleReadOnlyTextProperty(value));
		}
		nonOntologyPanel.add(widget);
	}
	
	@Override
	void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
		LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		boolean hadValue = false;
		for (EIEntity propEntity : propertyValues) {
			// Not sure if it's possible to delete the referred-to entity for a non-ontology literal, but we might as well take care of it...
			if (propEntity != null && propEntity != EIEntity.NULL_ENTITY && ! propEntity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) {
				widget.add(handleReadOnlyTextProperty(propEntity.getLabel()));
				hadValue = true;
			}
		}
		if (hadValue)
			nonOntologyPanel.add(widget);
	}
	
	@Override
	void drawObjectProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues) {
		final LabelValuesWidget widget = new LabelValuesWidget(propertyEntity);
		formPanel.add(widget);
		boolean hadValue = false;
		for (final EIEntity entity : propertyValues) {
			if (entity == null || entity == EIEntity.NULL_ENTITY || entity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) {
				Log.info("no value entity"); // TODO: remove
				continue;
			}
			hadValue = true;
			Anchor a = new Anchor(WidgetUtils.formatText(entity.getLabel()));
			widget.add(a);
			a.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					try {
						ClientRepositoryToolsManager.INSTANCE.getInstance(entity.getURI(), new EIInstanceCallback() {
							@Override
							public void loginRequired() {
								//handleLoginRequired();
							}
							@Override
							public void onSuccess(EIInstance eiInstance) {
								if (eiInstance != null) {
									ApplicationState.getInstance().setInstanceEntity(eiInstance.getEntity());
								} else {
									Window.open("http://search.eagle-i.net/model/#t=" + entity.getURI().toString(), "", "");
								}
							}
						});
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			});
		}
		
		if (!hadValue) {
			formPanel.remove(widget);
		}
		
	}
	
	@Override
	Collection<EIEntity> getDataTypeEntities() {
		return eiInstance.getDatatypeProperties().keySet();
	}
	
	@Override
	Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}
	
	@Override
	Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}
	
	@Override
	Collection<EIEntity> getObjectTypeEntities() {
		return eiInstance.getObjectProperties().keySet();
	}
	@Override
	protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		// deliberate no-op
	}
	
	@Override
	void setButtonState() {
		buttonPanel.saveButton.setVisible(false);
		buttonPanel.copyResourceButton.setVisible(true);
		buttonPanel.cancelButton.setVisible(false);
	//	buttonPanel.editButton.setVisible(true);
			buttonPanel.editButton.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
						ApplicationState.getInstance().setMode(Mode.edit); // TODO: anything else we need to set here?
				}
			});
		
		
	}
}
