package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;

public class WorkFlowAction {

	public static final WorkFlowAction					CurationAction		= new WorkFlowAction(WorkFlowConstants.CURATION_ACTION, WorkFlowConstants.DRAFT_ENTITY, WorkFlowConstants.CURATION_ENTITY);
	public static final WorkFlowAction					PublishAction		= new WorkFlowAction(WorkFlowConstants.PUBLISH_ACTION, WorkFlowConstants.CURATION_ENTITY, WorkFlowConstants.PUBLISH_ENTITY);
	public static final WorkFlowAction					WithdrawAction		= new WorkFlowAction(WorkFlowConstants.WITHDRAW_ACTION, WorkFlowConstants.PUBLISH_ENTITY, WorkFlowConstants.WITHDRAW_ENTITY);
	public static final WorkFlowAction					ReturnToDraftAction	= new WorkFlowAction(WorkFlowConstants.DRAFT_ACTION, WorkFlowConstants.CURATION_ENTITY, WorkFlowConstants.DRAFT_ENTITY);
	//	public static WorkFlowAction NoAction = new WorkFlowAction("", EIURI.create(""), EIURI.create(""));
	private static Map<WorkFlowAction, List<EIEntity>>	allowedActions;
	private final String								name;
	private final EIEntity								fromState;
	private final EIEntity								toState;

	private WorkFlowAction(String name, EIEntity from, EIEntity to) {
		this.name = name;
		fromState = from;
		toState = to;
		if (allowedActions == null) {
			allowedActions = new HashMap<WorkFlowAction, List<EIEntity>>();
		}
		if (allowedActions.get(this) == null) {
			allowedActions.put(this, new ArrayList<EIEntity>(2));
		}
		allowedActions.get(this).add(from);
	}

	public String getName() {
		return name;
	}

	public EIURI getFromState() {
		return fromState.getURI(); // TODO: just return entity?
	}

	public EIURI getToState() {
		return toState.getURI();// TODO: just return entity?
	}

	public Anchor getAnchor() {
		return new Anchor(name);
	}

	public void perform(final EIInstanceMinimal instance, final ActionRedisplay redisplay) {
		try {
			ClientRepositoryToolsManager.INSTANCE.promote(instance, toState, new ResultsCallback() {

				@Override
				public void onSuccess(String[] arg0) {
					redisplay.drawAfterPromote(instance);
				}

				@Override
				public void onSuccess(String arg0) {
					redisplay.drawAfterPromote(instance);
				}

				@Override
				public void loginRequired() {
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			Window.alert(e.getMessage());
		}
	}

	public void perform(final EIInstance instance, final FormRedisplay redisplay) {
		try {
			ClientRepositoryToolsManager.INSTANCE.promote(instance, toState, new ResultsCallback() {

				@Override
				public void onSuccess(String[] arg0) {
					redisplay.drawAfterPromote(instance);
				}

				@Override
				public void onSuccess(String arg0) {
					redisplay.drawAfterPromote(instance);
				}

				@Override
				public void loginRequired() {
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			Window.alert(e.getMessage());
		}
	}

	public static String getAlertMessage(WorkFlowAction action) {
		String base = UIMessages.BULK_OPERATION_ERROR;
		return makeAlertMessageBybase(action, base);
	}

	public static String getAlertMessageForUnclaimed(WorkFlowAction action) {
		String base = UIMessages.BULK_OPERATION_ERROR_FOR_UNCLAIMED;
		return makeAlertMessageBybase(action, base);
	}

	private static String makeAlertMessageBybase(WorkFlowAction action, String base) {
		String statusList = "";
		for (EIEntity status : allowedActions.get(action)) {
			statusList += ", " + new WorkFlowConstants().getStatusLabel(status.getURI());// TODO: just use entity?
		}
		statusList = statusList.replaceFirst(", ", "");
		Log.info("status list " + statusList);
		base = base.replace("$STATE$", statusList);
		base = base.replace("$ACTION$", action.getName());
		return base;
	}
}
