package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;

public class WorkflowUtils {

	public static boolean instanceHasOwner(final EIInstance instance) {
		return checkForNull(instance.getWFOwner());
	}

	public static boolean instanceHasOwner(final EIInstanceMinimal instance) {
		return checkForNull(instance.getWFOwner());
	}

	public static boolean instanceHasWorkflowState(final EIInstance instance) {
		return checkForNull(instance.getWFState());
	}

	public static boolean instanceHasWorkflowState(final EIInstanceMinimal instance) {
		return checkForNull(instance.getWFState());
	}

	private static boolean checkForNull(final EIEntity entity) {
		return entity != null && entity != EIEntity.NULL_ENTITY;
	}

	public static boolean isPublishedOrWithdrawn(final EIInstance instance) {
		return instanceHasWorkflowState(instance) && (WorkFlowConstants.PUBLISH_ENTITY.equals(instance.getWFState()) || WorkFlowConstants.WITHDRAW_ENTITY.equals(instance.getWFState()));
	}

	public static boolean isPublishedOrWithdrawn(final EIInstanceMinimal instance) {
		return instanceHasWorkflowState(instance) && (WorkFlowConstants.PUBLISH_ENTITY.equals(instance.getWFState()) || WorkFlowConstants.WITHDRAW_ENTITY.equals(instance.getWFState()));
	}

	public static boolean getUsabilityofWidgetByWorkflowRule(EIInstance instance) {
		return instanceHasWorkflowState(instance) && ((instanceHasOwner(instance) && Datatools.canUserChangeState(instance.getWFState().getURI())) || isPublishedOrWithdrawn(instance));
	}

	public static boolean getVisibiltyofWidgetByWorkflowRule(EIInstance instance) {
		return instanceHasWorkflowState(instance) && Datatools.canUserChangeState(instance.getWFState().getURI());
	}

	public static boolean getVisibiltyofWidgetByWorkflowRuleAndState(EIInstance instance) {
		return instanceHasWorkflowState(instance) && Datatools.canUserChangeState(instance.getWFState().getURI()) && !WorkflowUtils.isPublishedOrWithdrawn(instance);
	}
}
