/**
 * The eagle-i consortium
 * Harvard University
 * Aug 24, 2010
 */
package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.DeleteInstanceCallback;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.EIResourcesGrid;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.WorkFlowAction;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.datatools.client.ui.listeners.RowDeletionListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Daniela Bourges-Waldegg
 * @author Lucy Hadden
 * 
 */
public class GridRowWidget extends HorizontalPanel {

	private final static String			deleteHtml		= "<a>delete</a>";
	private final static String			unClaimHtml		= "<a>share</a>";
	private final static String			claimHtml		= "<a>claim</a>";
	private final static String			editHtml		= "<a>edit</a>";
	private final static String			withdrawHtml	= "<a>withdraw</a>";
	private final static String			publishHtml		= "<a>publish</a>";
	private EIInstanceMinimal			instance;
	private int							rowIndex;
	private final ActionRedisplay		redisplay;
	private final RowDeletionListener	listener;
	//for now we have only three actions per widget
	//TODO html String for now; migrate to a new FormAction class
	private HTML						formActions[]	= { new HTML(), new HTML(), new HTML() };
	private CheckBox					checkBox;
	
	
	private Label editor;

	public GridRowWidget(EIInstanceMinimal instance, RowDeletionListener deletionListener) {
		super();
		this.listener = deletionListener;
		this.redisplay = new ActionRedisplay() {

			@Override
			public void drawAfterClaim(EIInstanceMinimal instance) {
				redrawActions();
			}

			@Override
			public void drawAfterPromote(EIInstanceMinimal instance) {
				redrawActions();
			}

			@Override
			public void drawAfterClaim(EIInstanceMinimal[] instance) {
				// TODO Auto-generated method stub
			}
		};
		init(instance);
	}

	public GridRowWidget(EIInstanceMinimal instance, final String[] widths, RowDeletionListener deletionListener, int rowIndex) {
		super();
		this.listener = deletionListener;
		this.redisplay = new ActionRedisplay() {

			@Override
			public void drawAfterClaim(EIInstanceMinimal instance) {
				redrawActions();
			}

			@Override
			public void drawAfterPromote(EIInstanceMinimal instance) {
				redrawActions();
			}

			@Override
			public void drawAfterClaim(EIInstanceMinimal[] instance) {
				// TODO Auto-generated method stub
			}
		};
		//		setSpacing(10);
		setStyleName("dtListGridRow");
		init(instance);
		this.rowIndex = rowIndex;
	}

	private void init(final EIInstanceMinimal instance) {
		//Log.info("Creating row widget");
		this.instance = instance;
		setStyleName("dtListGridRow");
		
		final HTML instanceLabel = new HTML("<a>" + instance.getInstanceLabel() + "</a>");
		instanceLabel.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				EIEntity updatedLabEntity = getUpdatedLabEntity(instance);
				Log.info("Clicked on " + instanceLabel + "; updated lab entity is " + updatedLabEntity);
				ApplicationState.getInstance().updateApplicationState(Mode.view, instance.getEntity(), instance.getInstanceType(), updatedLabEntity);
			}
		});
		if(!isNull(instance.getLab())) {
			final VerticalPanel firstCell = new VerticalPanel();
			firstCell.setSpacing(0);
			firstCell.setBorderWidth(0);
			final HTML labLabel = new HTML("<i>" + instance.getLab().getLabel() + "</i>");
			firstCell.add(instanceLabel);
			firstCell.add(labLabel);
			addWithStyle(firstCell, 0);
			firstCell.setStyleName("firstCell");
			
		} else {
			addWithStyle(instanceLabel, 0);
		}
		addWithStyle(new Label(instance.getInstanceType().getLabel()), 1);
		String date = instance.getCreationDate();
		Label dateLabel = new Label(" ");
		if (date != null) {
			dateLabel = new Label(WidgetUtils.formatDate(date));
		}
		addWithStyle(dateLabel, 2);
		Label status = new Label(isNull(instance.getWFState())  ? " " : instance.getWFState().getLabel());
		addWithStyle(status, 3);
		addWithStyle(formActions[0], 4);
		addWithStyle(formActions[1], 5);
		addWithStyle(formActions[2], 6);
		checkBox = new CheckBox();
		checkBox.setVisible(shouldDisplayCheckBox());
		addWithStyle(checkBox, 7);
		redrawActions();
	}

	private String getEditorText(final EIInstanceMinimal instance) {
		if (instance.getWFOwner() == null || EIEntity.NULL_ENTITY.equals(instance.getWFOwner()))
			return "nobody";
		//if (instance.getWFOwner().equals(ApplicationState.getInstance().getUserURI()))
			//return "me";
		return instance.getWFOwner().toString();
	}

	public EIInstanceMinimal getInstance() {
		return instance;
	}

	public CheckBox getCheckBox() {
		return checkBox;
	}

	public HTML[] getFormActions() {
		return formActions;
	}

	private boolean shouldDisplayCheckBox() {
		if (ApplicationState.getInstance().hasLabType())
			return false;
		if (!Datatools.canUserChangeState(instance.getWFState().getURI()))
			return false;
		return true;
		//if (instanceHasOwner())
			//return true;
		//return isPublishedOrWithdrawn();
	}

	private boolean isPublishedOrWithdrawn() {
		return (WorkFlowConstants.PUBLISH_ENTITY.equals(instance.getWFState()) || WorkFlowConstants.WITHDRAW_ENTITY.equals(instance.getWFState()));
	}

	private void setClaimOrRelease() {
		if (Datatools.canUserChangeState(instance.getWFState().getURI()) && !isPublishedOrWithdrawn()) {
			if (instanceHasOwner()) {
				formActions[0] = makeHtmlWidgetByHtmlString(unClaimHtml);
				formActions[0].addClickHandler(new ClickHandler() {

					@Override
					public void onClick(ClickEvent event) {
						releaseAction();
					}
				});
			} else {
				formActions[0] = makeHtmlWidgetByHtmlString(claimHtml);
				formActions[0].addClickHandler(new ClickHandler() {

					@Override
					public void onClick(ClickEvent event) {
						claimAction();
					}
				});
			}
		}
	}

	private void setEdit() {
		if (Datatools.canUserChangeState(instance.getWFState().getURI())) {
			if (instanceHasOwner() || isPublishedOrWithdrawn()) {
				formActions[1] = makeHtmlWidgetByHtmlString(editHtml);
				formActions[1].addClickHandler(new ClickHandler() {

					@Override
					public void onClick(ClickEvent event) {
						Log.info("editing " + instance.getInstanceLabel());
						ApplicationState.getInstance().updateApplicationState(Mode.edit, instance.getEntity(), instance.getInstanceType(), ApplicationState.getInstance().getLabEntity());
					}
				});
			} else
				formActions[1] = new HTML();
		} else {
			formActions[1] = new HTML();
		}
	}

	private void setDelete() {
		if (Datatools.canUserChangeState(instance.getWFState().getURI()) && instanceHasOwner() && !isPublishedOrWithdrawn()) {
			formActions[2] = makeHtmlWidgetByHtmlString(deleteHtml);
			formActions[2].addClickHandler(new ClickHandler() {

				@Override
				public void onClick(ClickEvent event) {
					if (Window.confirm(UIMessages.DELETE_CONFIRM_MESSAGE)) {
						try {
						
							ClientRepositoryToolsManager.INSTANCE.deleteInstance(instance.getInstanceURI(), new DeleteInstanceCallback() {
	
								@Override
								public void onSuccess(Object obj) {
									if (listener != null) // TODO: get rid of this ASAP!
										listener.onRowDeletion(instance);
								}
							});
						} catch (Exception e) {
							Log.error("could not delete " + instance.getInstanceLabel());
						}
					}
				}
			});
		} else {
			formActions[2] = new HTML();
		}
	}

	public boolean instanceHasOwner() {
		return instance.getWFOwner() != null && !instance.getWFOwner().equals(EIEntity.NULL_ENTITY);
	}

	public int getRowIndex() {
		return rowIndex;
	}

	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}

	private HTML makeHtmlWidgetByHtmlString(String html) {
		HTML htmlWidget = new HTML(html);
		return htmlWidget;
	}

	private void claimAction() {
		OwnershipAction.ClaimAction.perform(instance, redisplay);
	}

	private void releaseAction() {
		OwnershipAction.ReleaseAction.perform(instance, redisplay);
	}

	private void publishAction() {
		WorkFlowAction.PublishAction.perform(instance, redisplay);
	}

	public void redrawActions() {
		remove(getFormActions()[0]);
		remove(getFormActions()[1]);
		remove(getFormActions()[2]);
		remove(checkBox);
		setEdit();
		setDelete();
		setClaimOrRelease();
		// TODO: set these by location, not by order and happenstance
		addWithStyle(getFormActions()[0], 4);
		addWithStyle(getFormActions()[1], 5);
		addWithStyle(getFormActions()[2], 6);
		addWithStyle(checkBox, 7);
		checkBox.setVisible(shouldDisplayCheckBox());
//		replace(editor, getEditor());
	}

	// TODO: test this!
	private EIEntity getUpdatedLabEntity(final EIInstanceMinimal instance) {
		if (ApplicationState.getInstance().getMode() == Mode.filter) {
			return ApplicationState.getInstance().hasLabType() ? instance.getEntity() : ApplicationState.getInstance().getLabEntity();
		}
		return ApplicationState.getInstance().getMode() == Mode.labs ? instance.getEntity() : ApplicationState.getInstance().getLabEntity();
	}
	
	private boolean isNull(EIEntity entity) {
		return(entity == null || entity.equals(EIEntity.NULL_ENTITY));
	}
	
	private void addWithStyle(Widget widget, int column) {
		add(widget);
		String width = EIResourcesGrid.widths[column] + "px";
		setCellWidth(widget, width);
	}
}
