package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.OntologyDropdown;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;


public class TermWidget extends EditWidget{

	private EIClass range;
	private EIClass selectedClass; 
	private boolean shouldHaveLabel;
	
	public TermWidget(EIInstance eiInstance, EIEntity propertyEntity, EIClass range, EIClass selectedClass, boolean shouldShowLabel) {
		super(eiInstance, propertyEntity);
		this.range = range;
		this.selectedClass = selectedClass;
		shouldHaveLabel = shouldShowLabel;
		if (! shouldHaveLabel)
			widgetPanel.remove(label);
		setup();
	}

	private void setup() {
		SharedClassChooser<OntologyDropdown> classChooser = new SharedClassChooser<OntologyDropdown>(new OntologyDropdown());
		classChooser.setClass(range, false);
		classChooser.setTextBoxStyle("textSuggest");
		if (selectedClass != null && selectedClass != EIClass.NULL_CLASS) {
			classChooser.setSelectedEntity(selectedClass.getEntity());
			updateOldValue(selectedClass.getEntity().getURI());
		} 
		
		widgetPanel.add(classChooser);
		TextWidget termRequestWidget = TextWidget.makeNonOntologyTextWidget(eiInstance,
				DatatoolsUIConstants.termRequestEntity, "");
		//Include the root class of the range in the name
		//in order to differentiate term request fields for testing
		termRequestWidget.setName(range.getEntity().getURI().toString() 
				+ "_" 
				+ DatatoolsUIConstants.termRequestEntity.getURI().toString());
		widgetPanel.add(termRequestWidget);
		
		makeSelectionHandler(classChooser);
		
	}

	// overridden in subclass for type
	protected void makeSelectionHandler(final SharedClassChooser<OntologyDropdown> classChooser) {
		classChooser.addSelectionListener(new EntitySelectionListener() {
			@Override
			public void onSelection(final EIEntity selectedEntity) {
				if(hasOldValue()) {
					if (selectedEntity.equals(EIEntity.NULL_ENTITY) || EIEntity.NO_LABEL.equals(selectedEntity.getLabel())) {
						removeValue();
					}
					else {
						eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create(oldValue), selectedEntity);
					}
				} else {
					eiInstance.addObjectProperty(propertyEntity, selectedEntity);
				}
				updateOldValue(selectedEntity.getURI());
				
				classChooser.setTextBoxStyle("formText");
			}
		});
	}
	
	@Override
	protected void removeValue() {
		if (hasOldValue())
			eiInstance.replaceObjectPropertyValue(propertyEntity, getOldEIURIValue(), null);
	}
	
	@Override
	public EditWidget duplicateBlank() {
		return new TermWidget(eiInstance, propertyEntity, range, null, false);
	}
}
