/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.EagleiGlassPane;
import org.eaglei.datatools.client.ui.LeftListPanel;
import org.eaglei.datatools.client.ui.MainController;
import org.eaglei.datatools.client.ui.TopPanel;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.FooterPanel;

/*
 * Exception performing whole class analysis ignored.
 */
public class Datatools
implements ClientRepositoryToolsManager.SessionListener {
    private String currentUser;
    private HorizontalPanel mainPanel;
    public static boolean isRefresh;
    private TopPanel topPanel = null;
    private boolean initialized = false;
    private LeftListPanel leftList;
    private MainController mainController;
    private static final VerticalPanel dataPanel;
    protected static final EagleiGlassPane glasspane;

    public void onModuleLoad() {
        GWT.setUncaughtExceptionHandler((GWT.UncaughtExceptionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.initialized = false;
        Log.info((String)"making new main controller");
        this.mainController = new MainController();
        RootPanel footerSlot = RootPanel.get((String)"footer_container");
        String version = footerSlot.getElement().getInnerText();
        footerSlot.getElement().setInnerText("");
        FooterPanel footerPanel = new FooterPanel(version);
        footerSlot.add((Widget)footerPanel);
        this.currentUser = DatatoolsCookies.getUserName();
        if (this.currentUser != null) {
            try {
                ClientRepositoryToolsManager.INSTANCE.whoami((ClientRepositoryToolsManager.UserCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                Log.warn((String)"did whoami; exception thrown--setting user to null & removing cookies");
                Log.warn((String)e.getMessage());
                this.handleNotLoggedIn();
                this.initialize();
            }
        } else if (!this.initialized) {
            this.initialize();
            return;
        }
    }

    private void initialize() {
        this.initialized = true;
        if (!Window.Location.getHash().equals("")) {
            isRefresh = true;
            Log.info((String)("token from window: " + Window.Location.getHash()));
            ApplicationState.newInstance((String)Window.Location.getHash());
        }
        String userUri = DatatoolsCookies.getUserUri();
        if (this.currentUser == null) {
            userUri = null;
        }
        if (userUri != null) {
            ApplicationState.getInstance().setUser(EIEntity.create((EIURI)EIURI.create((String)userUri), (String)this.currentUser));
            Log.info((String)("User uri " + ApplicationState.getInstance().getUserURI() + "; label " + ApplicationState.getInstance().getUserID()));
        }
        if (this.topPanel == null) {
            this.topPanel = new TopPanel();
            RootPanel.get((String)"header_container").add((Widget)this.topPanel);
        }
        this.mainPanel = new HorizontalPanel();
        dataPanel.setStyleName("dataPanel");
        this.leftList = new LeftListPanel();
        this.mainPanel.add((Widget)this.leftList);
        this.mainPanel.add((Widget)dataPanel);
        RootPanel.get((String)"main_container").add((Widget)this.mainPanel);
        if (userUri != null) {
            this.topPanel.onLogIn(this.currentUser, userUri);
        }
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
        this.leftList.onApplicationStateChange();
        this.mainController.onApplicationStateChange();
        ApplicationState.getInstance().addApplicationStateListener((ApplicationStateChangeListener)this.topPanel);
    }

    private void handleNotLoggedIn() {
        ApplicationState.getInstance().setUser(EIEntity.NULL_ENTITY);
        DatatoolsCookies.removeCookies();
        ClientRepositoryToolsManager.INSTANCE.logOut();
    }

    public void onLogIn(String username, String userUri) {
        ApplicationState.getInstance().setUser(EIEntity.create((String)userUri, (String)username));
        this.topPanel.onLogIn(username, userUri);
        this.mainController.onLogIn(username, userUri);
    }

    public void onLogOut() {
        Log.info((String)("datatools logging out; redirecting to " + GWT.getModuleBaseURL()));
        ApplicationState.getInstance().setUser(EIEntity.NULL_ENTITY);
        this.mainController.onLogOut();
        this.leftList.onLogOut();
        if (!isRefresh) {
            Window.Location.assign((String)"");
            ApplicationState.getInstance().clearApplicationState();
        }
    }

    public static boolean canUserChangeState(EIURI currentWFState) {
        if (currentWFState == null) {
            return false;
        }
        return ClientRepositoryToolsManager.INSTANCE.canEdit(currentWFState);
    }

    public static boolean canUserChangeState(EIInstance instance, EIURI newWFState) {
        if (instance.getWFState() == null) {
            return false;
        }
        if (instance.getWFOwner() == null) {
            return false;
        }
        return Datatools.canUserChangeState((EIURI)instance.getWFState().getURI(), (EIURI)newWFState);
    }

    public static boolean canUserChangeState(EIURI currentWFState, EIURI newWFState) {
        Log.info((String)("CanUSerChangeState: current = " + currentWFState + " new = " + newWFState));
        if (currentWFState == null || newWFState == null) {
            return false;
        }
        List transitions = (List)WorkFlowConstants.ALLOWED_TRANSITIONS.get(currentWFState);
        return ClientRepositoryToolsManager.INSTANCE.canEdit(currentWFState) && transitions.contains(newWFState);
    }

    public static void showGlasspane() {
        glasspane.add((Widget)new Image("images/ajax-loader.gif"));
        glasspane.show();
    }

    public static void hideGlasspane() {
        glasspane.hide();
    }

    public static void clearDataPanel() {
        dataPanel.clear();
    }

    public static void handleLoginRequired() {
        Datatools.clearDataPanel();
        HTML errorMessage = new HTML("<font color='red'><b> Please sign in.</b></font>");
        dataPanel.add((Widget)errorMessage);
    }

    public static void showData(Widget widget) {
        Datatools.clearDataPanel();
        Datatools.hideGlasspane();
        dataPanel.add(widget);
    }

    static /* synthetic */ void access$000(Datatools x0) {
        x0.handleNotLoggedIn();
    }

    static /* synthetic */ void access$100(Datatools x0) {
        x0.initialize();
    }

    static /* synthetic */ String access$200(Datatools x0) {
        return x0.currentUser;
    }

    static {
        dataPanel = new VerticalPanel();
        glasspane = new EagleiGlassPane();
    }
}

