/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.LabelValuesWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public abstract class EIFormsPanel
extends Composite {
    private VerticalPanel outerFormPanel = new VerticalPanel();
    protected VerticalPanel formPanel = new VerticalPanel();
    protected EIInstance eiInstance;
    protected EIClass rootSuperClass;
    protected boolean shouldShowReadOnlyProperties;
    protected ButtonsPanel buttonPanel;
    protected FormRedisplay redisplayCallbacks;

    abstract void drawDataProperty(EIEntity var1, Set<String> var2);

    abstract void drawObjectProperty(EIEntity var1, Set<EIEntity> var2);

    abstract void drawNonOntologyLiteralProperty(EIEntity var1, Set<String> var2, Map<EIEntity, String> var3, VerticalPanel var4);

    abstract void drawNonOntologyResourceProperty(EIEntity var1, Set<EIEntity> var2, Map<EIEntity, String> var3, VerticalPanel var4);

    protected abstract void drawExtraFields(Map<EIEntity, Set<String>> var1);

    abstract Collection<EIEntity> getDataTypeEntities();

    abstract Collection<EIEntity> getObjectTypeEntities();

    abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

    abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

    abstract void setButtonState();

    public EIFormsPanel(EIInstance instance, FormRedisplay redisplay) {
        this.initWidget((Widget)this.outerFormPanel);
        this.outerFormPanel.setStyleName("formPanel");
        this.formPanel.setStyleName("formPanel");
        this.eiInstance = instance;
        this.buttonPanel = new ButtonsPanel(this.eiInstance, redisplay);
        this.outerFormPanel.add((Widget)this.buttonPanel);
        this.outerFormPanel.add((Widget)this.formPanel);
        this.setButtonState();
        this.redisplayCallbacks = redisplay;
        this.buttonPanel.copyResourceButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void finishSetup() {
        this.constructForm();
        this.formPanel.setStyleName("formPanel");
        this.formPanel.setHeight("50");
    }

    public EIInstance getInstance() {
        return this.eiInstance;
    }

    protected void constructForm() {
        Map dataTypeProperties = this.eiInstance.getDatatypeProperties();
        Map objectTypeProperties = this.eiInstance.getObjectProperties();
        Map nonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        Map nonOntologyResourceProperties = this.eiInstance.getNonOntologyResourceProperties();
        String labelPrefix = WidgetUtils.isLabProperty((EIEntity)this.eiInstance.getInstanceType()) ? "Laboratory" : this.rootSuperClass.getEntity().getLabel();
        EIEntity namePropEntity = EIEntity.create((EIURI)DatatoolsUIConstants.propertyName.getURI(), (String)WidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)DatatoolsUIConstants.propertyName.getLabel()));
        this.drawDataProperty(namePropEntity, (Set)this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
        EIEntity typePropEntity = EIEntity.create((EIURI)DatatoolsUIConstants.propertyType.getURI(), (String)WidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)DatatoolsUIConstants.propertyType.getLabel()));
        this.drawObjectProperty(typePropEntity, (Set)this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
        for (EIEntity propEntity : this.getDataTypeEntities()) {
            this.drawDataProperty(propEntity, (Set)dataTypeProperties.get(propEntity));
        }
        for (EIEntity propEntity : this.getObjectTypeEntities()) {
            this.drawObjectProperty(propEntity, (Set)objectTypeProperties.get(propEntity));
        }
        this.drawExtraFields(nonOntologyLiteralProperties);
        DisclosurePanel nonOntologyPanel = new DisclosurePanel("Information for data curators");
        Map nonOntLiteralList = this.eiInstance.getNonOntologyLiteralProperties();
        Map nonOntResourceList = this.eiInstance.getNonOntologyResourceProperties();
        ArrayList entityList = new ArrayList();
        entityList.addAll(this.eiInstance.getReadOnlyLiteralProperties().keySet());
        entityList.addAll(this.eiInstance.getReadOnlyResourceProperties().keySet());
        entityList.addAll(nonOntResourceList.keySet());
        entityList.addAll(nonOntLiteralList.keySet());
        VerticalPanel innerPanel = new VerticalPanel();
        ClientRepositoryToolsManager.INSTANCE.retrieveLabels(entityList, (ClientRepositoryToolsManager.LabelsCallback)new /* Unavailable Anonymous Inner Class!! */);
        nonOntologyPanel.add((Widget)innerPanel);
        this.formPanel.add((Widget)nonOntologyPanel);
    }

    private HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    private HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    private HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
        return new HashSet<EIEntity>(Arrays.asList(value));
    }

    protected void createNonOntologyPanel(Map<EIEntity, Set<String>> nonOntologyLiteralProperties, Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties, Map<EIEntity, String> labelMap, VerticalPanel innerPanel) {
        VerticalPanel metaPanel = new VerticalPanel();
        VerticalPanel otherPanel = new VerticalPanel();
        this.designPanel(metaPanel, "Metadata properties:");
        this.designPanel(otherPanel, "Other properties:");
        LabelValuesWidget eagleIUniqueId = new LabelValuesWidget("eagle-i unique ID");
        Anchor id = new Anchor(this.eiInstance.getInstanceURI().toString(), this.eiInstance.getInstanceURI().toString(), "_blank");
        eagleIUniqueId.add((Widget)id);
        innerPanel.add((Widget)eagleIUniqueId);
        if (this.shouldShowReadOnlyProperties) {
            innerPanel.add((Widget)metaPanel);
            innerPanel.add((Widget)otherPanel);
            Map readOnlyLiterals = this.eiInstance.getReadOnlyLiteralProperties();
            Map readOnlyResources = this.eiInstance.getReadOnlyResourceProperties();
            this.drawReadOnlyProperties(labelMap, metaPanel, readOnlyLiterals, readOnlyResources);
        }
        VerticalPanel panelToUse = this.shouldShowReadOnlyProperties ? otherPanel : innerPanel;
        for (EIEntity propEntity : nonOntologyLiteralProperties.keySet()) {
            this.drawNonOntologyLiteralProperty(propEntity, nonOntologyLiteralProperties.get(propEntity), labelMap, panelToUse);
        }
        for (EIEntity propEntity : nonOntologyResourceProperties.keySet()) {
            this.drawNonOntologyResourceProperty(propEntity, nonOntologyResourceProperties.get(propEntity), labelMap, panelToUse);
        }
    }

    private void drawReadOnlyProperties(Map<EIEntity, String> labelMap, VerticalPanel metaPanel, Map<EIEntity, String> readOnlyLiterals, Map<EIEntity, EIEntity> readOnlyResources) {
        for (EIEntity propEntity : readOnlyLiterals.keySet()) {
            this.drawReadOnlyLiteralProperty(propEntity, (Set)this.makeSetFromSingle(readOnlyLiterals.get(propEntity)), labelMap, metaPanel);
        }
        for (EIEntity propEntity : readOnlyResources.keySet()) {
            this.drawReadOnlyResourceProperty(propEntity, (Set)this.makeSetFromSingleEntity(readOnlyResources.get(propEntity)), labelMap, metaPanel);
        }
    }

    private void designPanel(VerticalPanel panel, String header) {
        panel.setStyleName("formPanel");
        Label propHeader = new Label(header);
        propHeader.setStyleName("nonOntologyPropertyLabel");
        panel.add((Widget)propHeader);
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        Anchor resourceURL = null;
        Label valueField = new Label();
        valueField.setStyleName("formLabelValue");
        if (value.startsWith("www") || value.startsWith("http")) {
            resourceURL = new Anchor(WidgetUtils.formatText((String)value), WidgetUtils.formatText((String)value), "_blank");
        } else {
            valueField.setText(WidgetUtils.formatText((String)value));
        }
        return resourceURL == null ? valueField : resourceURL;
    }

    protected void drawReadOnlyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void drawReadOnlyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (EIEntity propEntity : propertyValues) {
            if (propEntity == null || propEntity == EIEntity.NULL_ENTITY) continue;
            widget.add(this.handleReadOnlyTextProperty(propEntity.getLabel()));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void getRootSuperClass() {
        ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(this.eiInstance.getInstanceClass(), (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

