/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.LabResources;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public class LeftListPanel
extends VerticalPanel
implements ClientRepositoryToolsManager.SessionListener,
ApplicationStateChangeListener {
    private static final int TYPE_COLUMN = 0;
    private static final int ADD_NEW_COLUMN = 1;
    private static final int HIDDEN_URI_COLUMN_INDEX = 2;
    private static final int LAB_NAME_ROW = 0;
    private static final int ALL_TYPES_ROW = 1;
    private boolean signedIn = false;
    public static List<EIClass> resourceTypes;
    public static Map<String, EIEntity> resourceTypeLabels;
    private static Map<EIEntity, String> definitions;
    private static FlexTable labsTable;
    private static FlexTable resourcesTable;
    private Anchor labsLink = new Anchor();
    private Anchor resourcesLink = new Anchor();
    final FlowPanel labsPanel = new FlowPanel();
    final FlowPanel resourcesPanel = new FlowPanel();

    public LeftListPanel() {
        Log.debug((String)"making left list panel");
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
        ApplicationState.getInstance().addApplicationStateListener((ApplicationStateChangeListener)this);
        this.signedIn = ApplicationState.getInstance().hasUser();
        if (this.signedIn) {
            this.getResourceTypes();
        }
    }

    public void onApplicationStateChange() {
        this.drawFromApplicationState();
    }

    private void drawFromApplicationState() {
        if (!ApplicationState.getInstance().hasUser() && !this.signedIn) {
            labsTable.setVisible(false);
            resourcesTable.setVisible(false);
            return;
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.labs) {
            this.addLabName("");
            labsTable.setVisible(false);
            resourcesTable.setVisible(false);
            this.selectType(labsTable);
            this.unselectAll(resourcesTable);
            this.resourcesPanel.setStyleName("panelNotSelected");
        } else if (ApplicationState.getInstance().hasLab()) {
            this.addLabName(ApplicationState.getInstance().getLabEntity().getLabel());
            labsTable.setVisible(true);
            resourcesTable.setVisible(false);
            if (!ApplicationState.getInstance().hasType()) {
                this.unselectAll(labsTable);
                labsTable.getRowFormatter().setStyleName(1, "panelSelected");
            } else {
                this.selectType(labsTable);
            }
            this.unselectAll(resourcesTable);
            this.resourcesPanel.setStyleName("panelNotSelected");
        } else {
            this.addLabName("");
            labsTable.setVisible(false);
            resourcesTable.setVisible(true);
            this.selectType(resourcesTable);
            this.unselectAll(labsTable);
            if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources || ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter && EIEntity.NULL_ENTITY.equals((Object)ApplicationState.getInstance().getTypeEntity()) && EIEntity.NULL_ENTITY.equals((Object)ApplicationState.getInstance().getLabEntity())) {
                this.resourcesPanel.setStyleName("panelSelected");
                this.unselectAll(resourcesTable);
            } else {
                this.resourcesPanel.setStyleName("panelNotSelected");
            }
        }
    }

    private void getResourceTypes() {
        Log.debug((String)"left panel getting resource types");
        ClientModelManager.INSTANCE.getTopLevelClasses((ClientModelManager.TopLevelClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getTypeDefinitions() {
        Log.debug((String)"Left panel getting definitions");
        ClientModelManager.INSTANCE.getClassDefinitions(resourceTypes, (ClientModelManager.ClassDefinitionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createPanel() {
        Log.debug((String)("left list panel creating sub-panel; logged in? " + this.signedIn));
        this.labsLink.setHTML("<b> My Laboratories</b>");
        this.resourcesLink.setHTML("<b>My Resources</b>");
        this.setWidth("100");
        this.setStyleName("leftPanel");
        if (this.signedIn) {
            Anchor addNewLink = new Anchor("add new");
            addNewLink.setName("http://purl.obolibrary.org/obo/ERO_0000001_add_new");
            this.labsPanel.add((Widget)this.labsLink);
            this.labsPanel.add((Widget)addNewLink);
            addNewLink.setStyleName("gwt_add_item");
            this.add((Widget)this.labsPanel);
            this.add((Widget)labsTable);
            labsTable.setVisible(false);
            labsTable.setText(0, 0, "");
            labsTable.setText(0, 1, "");
            this.addAllTypesOption();
            this.populateTypeTable(labsTable, LabResources.resourcesEntityMap);
            this.resourcesPanel.add((Widget)this.resourcesLink);
            this.add((Widget)this.resourcesPanel);
            this.add((Widget)resourcesTable);
            resourcesTable.setVisible(ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources || ApplicationState.getInstance().hasType());
            this.populateTypeTable(resourcesTable, resourceTypeLabels);
            addNewLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.labsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.resourcesLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.drawFromApplicationState();
        }
    }

    private void populateTypeTable(FlexTable table, Map<String, EIEntity> labelTypeEntityMap) {
        for (Map.Entry<String, EIEntity> entry : labelTypeEntityMap.entrySet()) {
            FlowPanel typePanel = new FlowPanel();
            Label icon = new Label();
            icon.setStyleName("tempIcon");
            Anchor typeLabel = new Anchor(entry.getKey());
            typeLabel.setTitle((String)definitions.get(entry.getValue()));
            typeLabel.setStyleName("gwt_super_type");
            typePanel.add((Widget)icon);
            typePanel.add((Widget)typeLabel);
            table.setWidget(table.getRowCount(), 0, (Widget)typePanel);
            typeLabel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            Anchor addNew = new Anchor("add new");
            addNew.setName(entry.getValue().getURI().toString() + "_add_new");
            addNew.setStyleName("gwt_add_item");
            table.setWidget(table.getRowCount() - 1, 1, (Widget)addNew);
            addNew.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            table.setWidget(table.getRowCount() - 1, 2, null);
        }
    }

    private void addAllTypesOption() {
        FlowPanel h = new FlowPanel();
        Label i = new Label();
        i.setStyleName("tempIcon");
        Anchor allTypesLabel = new Anchor("All Resource Types");
        allTypesLabel.setStyleName("gwt_super_type");
        h.add((Widget)i);
        h.add((Widget)allTypesLabel);
        labsTable.setWidget(1, 0, (Widget)h);
        labsTable.setWidget(1, 2, null);
        allTypesLabel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addLabName(String labName) {
        FlowPanel labNamePanel = new FlowPanel();
        Label labNameLabel = new Label(labName);
        labNameLabel.setStyleName("labSelected");
        labNamePanel.add((Widget)labNameLabel);
        labsTable.setWidget(0, 0, (Widget)labNamePanel);
        labsTable.setWidget(0, 2, null);
        labNameLabel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void selectType(FlexTable typesTable) {
        if (ApplicationState.getInstance().hasType()) {
            String typeLabel = ApplicationState.getInstance().getTypeEntity().getLabel();
            for (int i = 0; i < typesTable.getRowCount(); ++i) {
                if (typesTable.getText(i, 0).equals(typeLabel)) {
                    typesTable.getRowFormatter().setStyleName(i, "panelSelected");
                    continue;
                }
                typesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
            }
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            this.resourcesPanel.setStyleName("panelSelected");
        }
    }

    private void unselectAll(FlexTable typesTable) {
        for (int i = 0; i < typesTable.getRowCount(); ++i) {
            typesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
        }
    }

    private FlowPanel createClassLabel(HashMap<EIClass, Anchor> mapNoDefClassToUIObject, EIClass eclass) {
        FlowPanel h = new FlowPanel();
        Label i = new Label();
        i.setStyleName("tempIcon");
        Anchor lbl = new Anchor(eclass.getEntity().getLabel());
        lbl.setStyleName("gwt_super_type");
        if (eclass.getDefinition() == null) {
            mapNoDefClassToUIObject.put(eclass, lbl);
        } else {
            lbl.setTitle(eclass.getDefinition());
        }
        h.add((Widget)i);
        h.add((Widget)lbl);
        return h;
    }

    private void setToolTipforClass(Map<EIClass, Anchor> mapNoDefClassToUIObject) {
        ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>(mapNoDefClassToUIObject.keySet());
        ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, (ClientModelManager.ClassDefinitionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onLogOut() {
        this.signedIn = false;
        labsTable = new FlexTable();
        this.labsPanel.clear();
        resourcesTable = new FlexTable();
        this.resourcesPanel.clear();
        this.labsLink = new Anchor();
        this.resourcesLink = new Anchor();
        this.clear();
    }

    public void onLogIn(String username, String userUri) {
        this.signedIn = true;
        if (resourceTypes != null && resourceTypes.size() > 0) {
            this.createPanel();
        } else {
            Log.debug((String)"left list panel logging in: about to get resource types");
            this.getResourceTypes();
        }
    }

    private void createHandler() {
        labsTable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        resourcesTable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(LeftListPanel x0) {
        x0.getTypeDefinitions();
    }

    static /* synthetic */ Map access$100() {
        return definitions;
    }

    static /* synthetic */ void access$200(LeftListPanel x0) {
        x0.createPanel();
    }

    static /* synthetic */ FlexTable access$300() {
        return labsTable;
    }

    static /* synthetic */ FlexTable access$400() {
        return resourcesTable;
    }

    static {
        resourceTypeLabels = new HashMap();
        definitions = new HashMap();
        labsTable = new FlexTable();
        resourcesTable = new FlexTable();
    }
}

