/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.EIFormsPanel;
import org.eaglei.datatools.client.ui.EditFormRedisplay;
import org.eaglei.datatools.client.ui.EditFormsPanel;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.EIResourceWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.ObjectWidget;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public class EditFormsPanel
extends EIFormsPanel {
    private EIClass eiClass;
    private final List<EIEntity> dataPropEntityList = new ArrayList();
    private final List<EIEntity> booleanPropEntityList = new ArrayList();
    private final List<EIEntity> objPropEntityList = new ArrayList();
    private final Map<EIEntity, List<EIClass>> objectProperties = new HashMap();
    private final EIEntity labEntity;
    private String editToken;
    private final EditFormType formType;
    private final EditFormRedisplay formRedisplayCallbacks;

    public static EditFormsPanel createEditForm(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, eiClass, labUri, displayCallbacks, EditFormType.Edit);
    }

    public static EditFormsPanel createNewForm(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, eiClass, labUri, displayCallbacks, EditFormType.New);
    }

    public static EditFormsPanel createDialogForm(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, eiClass, labUri, displayCallbacks, EditFormType.Dialog);
    }

    private EditFormsPanel(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks, EditFormType formType) {
        super(instance, (FormRedisplay)displayCallbacks);
        this.shouldShowReadOnlyProperties = true;
        this.formRedisplayCallbacks = displayCallbacks;
        this.eiClass = eiClass;
        this.initializePropertyLists();
        this.formType = formType;
        this.setButtonState();
        this.labEntity = labUri == null || labUri.toString().equals("") ? null : EIEntity.create((EIURI)labUri, (String)"");
        Log.info((String)("have lab? " + this.hasLabUri()));
        if (!this.isNewForm()) {
            this.getEditToken();
        }
        if (this.buttonPanel.getSaveButton().isEnabled()) {
            this.buttonPanel.getSaveButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.buttonPanel.getCancelButton().isEnabled()) {
            this.buttonPanel.getCancelButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public boolean isNewForm() {
        return this.formType == EditFormType.New || this.formType == EditFormType.Dialog;
    }

    void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues) {
        if (propertyEntity.equals((Object)DatatoolsUIConstants.propertyName)) {
            this.formPanel.add((Widget)TextWidget.makeLabelTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyValues.iterator().next()));
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (this.booleanPropEntityList.contains(propertyEntity)) {
                this.formPanel.add((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, null));
            } else {
                this.formPanel.add((Widget)new EditWidgetCollection(this.eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, null)));
            }
        } else {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            for (String value : propertyValues) {
                if (this.booleanPropEntityList.contains(propertyEntity)) {
                    fields.addWithoutModifiers((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
                    continue;
                }
                fields.addWidget(TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
            }
            this.formPanel.add((Widget)fields);
        }
    }

    void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        if (!propertyEntity.getURI().toString().equals("http://eagle-i.org/ont/datatools/1.0/user_comments") && !propertyEntity.getURI().toString().equals("http://purl.obolibrary.org/obo/IAO_0000232")) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            nonOntologyPanel.add((Widget)fields);
            for (String value : propertyValues) {
                fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
            }
        }
    }

    void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
        nonOntologyPanel.add((Widget)fields);
        for (EIEntity value : propertyValues) {
            fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value.getLabel()));
        }
    }

    void drawObjectProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues) {
        if (propertyEntity.equals((Object)DatatoolsUIConstants.propertyType)) {
            this.drawTypeProperty();
        } else if (this.objectProperties.get(propertyEntity) != null && ((List)this.objectProperties.get(propertyEntity)).size() > 0) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            this.formPanel.add((Widget)fields);
            if (((List)this.objectProperties.get(propertyEntity)).size() == 1) {
                this.drawSingleObjectProperty(propertyEntity, propertyValues, fields);
            } else {
                Log.info((String)(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : Integer.valueOf(propertyValues.size())) + "entries"));
                if (propertyValues == null || propertyValues.size() == 0) {
                    this.createWidgetForMultiRanges(propertyEntity, null, fields);
                } else {
                    for (EIEntity selectedEntity : propertyValues) {
                        this.createWidgetForMultiRanges(propertyEntity, selectedEntity, fields);
                    }
                }
            }
        }
    }

    private void drawSingleObjectProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, EditWidgetCollection fields) {
        EIClass range = (EIClass)((List)this.objectProperties.get(propertyEntity)).iterator().next();
        if (this.hasLabUri() && WidgetUtils.isLabProperty((EIClass)range)) {
            Log.info((String)("making disabled widget for lab uri '" + this.labEntity + "' property " + range.getEntity().getLabel()));
            this.eiInstance.addObjectProperty(propertyEntity, this.labEntity);
            this.createWidgetForRange(propertyEntity, range, this.labEntity, fields, true);
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (WidgetUtils.isLabProperty((EIClass)range)) {
                Log.info((String)("drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab"));
            }
            this.createWidgetForRange(propertyEntity, range, EIEntity.NULL_ENTITY, fields, false);
        } else {
            if (WidgetUtils.isLabProperty((EIClass)range)) {
                Log.info((String)("drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab"));
            }
            for (EIEntity selectedEntity : propertyValues) {
                this.createWidgetForRange(propertyEntity, range, selectedEntity, fields, false);
            }
        }
    }

    private void drawTypeProperty() {
        HorizontalPanel temp = new HorizontalPanel();
        this.formPanel.add((Widget)temp);
        if (WidgetUtils.isLabProperty((EIClass)this.eiInstance.getInstanceClass())) {
            ClientRepositoryToolsManager.INSTANCE.getLabRootSuperclass((ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(this.eiInstance.getInstanceClass(), (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void createWidgetForMultiRanges(EIEntity propertyEntity, EIEntity selectedEntity, EditWidgetCollection fields) {
        Log.info((String)("making multi-range widget with " + ((List)this.objectProperties.get(propertyEntity)).size() + " ranges"));
        ObjectWidget widget = new ObjectWidget(this.eiInstance, propertyEntity, (List)this.objectProperties.get(propertyEntity), this.labEntity, selectedEntity);
        fields.addWidget((EditWidget)widget, widget.isDisabled());
    }

    private void createWidgetForRange(EIEntity propertyEntity, EIClass range, EIEntity selectedEntity, EditWidgetCollection fields, boolean isLab) {
        if (range.isEagleIResource()) {
            EIResourceWidget resourceWidget = new EIResourceWidget(this.eiInstance, propertyEntity, range, selectedEntity, true);
            fields.addWidget((EditWidget)resourceWidget, isLab);
            if (isLab) {
                resourceWidget.disable();
            }
        } else {
            WidgetUtils.addTermWidgetToPanel((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (EIClass)range, (EIEntity)selectedEntity, (EditWidgetCollection)fields, (boolean)true);
        }
    }

    Collection<EIEntity> getDataTypeEntities() {
        return this.dataPropEntityList;
    }

    Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        return this.eiInstance.getNonOntologyLiteralProperties().keySet();
    }

    Collection<EIEntity> getNonOntologyResourcePropEntities() {
        return this.eiInstance.getNonOntologyResourceProperties().keySet();
    }

    Collection<EIEntity> getObjectTypeEntities() {
        return this.objPropEntityList;
    }

    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        EIEntity comments = EIEntity.create((String)"http://eagle-i.org/ont/datatools/1.0/user_comments", (String)"Comments");
        EIEntity curatorComments = EIEntity.create((String)"http://purl.obolibrary.org/obo/IAO_0000232", (String)"Curator note");
        String commentValue = nonOntologyLiteralProperties.containsKey(comments) ? nonOntologyLiteralProperties.get(comments).iterator().next() : null;
        TextAreaWidget commentsArea = new TextAreaWidget(this.eiInstance, comments, commentValue);
        this.formPanel.add((Widget)commentsArea);
        String curatorValue = nonOntologyLiteralProperties.containsKey(curatorComments) ? nonOntologyLiteralProperties.get(curatorComments).iterator().next() : null;
        TextAreaWidget curatorArea = new TextAreaWidget(this.eiInstance, curatorComments, curatorValue);
        this.formPanel.add((Widget)curatorArea);
    }

    private void initializePropertyLists() {
        this.dataPropEntityList.clear();
        this.objPropEntityList.clear();
        this.objectProperties.clear();
        this.booleanPropEntityList.clear();
        ClientModelManager.INSTANCE.getProperties(this.eiClass, (ClientModelManager.PropertyCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean hasLabUri() {
        return this.labEntity != null && this.labEntity.getURI() != EIURI.NULL_EIURI && !this.labEntity.getURI().toString().equals("");
    }

    protected void save() {
        try {
            if (this.eiInstance.getInstanceLabel() == null || this.eiInstance.getInstanceLabel().trim().equals("")) {
                Window.alert((String)"Name is a required field.");
                return;
            }
            if (this.isNewForm()) {
                this.saveNewForm();
            } else {
                ClientRepositoryToolsManager.INSTANCE.updateInstance(this.eiInstance, this.editToken, (ClientRepositoryToolsManager.SaveResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            Log.error((String)"could not (re-) get instance");
        }
    }

    private void saveNewForm() throws Exception {
        ClientRepositoryToolsManager.INSTANCE.createInstance(this.eiInstance, (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cancel() {
        try {
            if (this.formType == EditFormType.New) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.list, EIEntity.NULL_ENTITY, this.eiInstance.getInstanceType(), ApplicationState.getInstance().getLabEntity());
            } else if (this.formType == EditFormType.Dialog) {
                this.formRedisplayCallbacks.drawAfterCancel(this.eiInstance);
            } else {
                ClientRepositoryToolsManager.INSTANCE.getInstance(this.eiInstance.getInstanceURI(), (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            Log.error((String)"could not get instance");
        }
    }

    void setButtonState() {
        this.buttonPanel.saveButton.setVisible(true);
        if (this.formType == EditFormType.New) {
            this.buttonPanel.copyResourceButton.setVisible(false);
            this.buttonPanel.cancelButton.setVisible(true);
        } else if (this.formType == EditFormType.Dialog) {
            this.buttonPanel.copyResourceButton.setVisible(false);
            this.buttonPanel.cancelButton.setVisible(true);
        } else {
            this.buttonPanel.copyResourceButton.setVisible(true);
            this.buttonPanel.cancelButton.setVisible(true);
            this.buttonPanel.setWorkflowButtonEnable(false);
        }
        this.buttonPanel.editButton.setVisible(false);
        this.buttonPanel.claimReleaseButton.setVisible(false);
        this.buttonPanel.deleteButton.setVisible(false);
    }

    private void getEditToken() {
        try {
            ClientRepositoryToolsManager.INSTANCE.updateInstance(this.eiInstance, null, (ClientRepositoryToolsManager.SaveResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            Log.error((String)("failed to get edit token for " + this.eiInstance + " with exception"));
            Window.alert((String)"Currently unable to edit this resource. Logout and try again.");
        }
    }

    static /* synthetic */ void access$000(EditFormsPanel x0) {
        x0.cancel();
    }

    static /* synthetic */ EIClass access$102(EditFormsPanel x0, EIClass x1) {
        x0.eiClass = x1;
        return x0.eiClass;
    }

    static /* synthetic */ void access$200(EditFormsPanel x0) {
        x0.initializePropertyLists();
    }

    static /* synthetic */ List access$300(EditFormsPanel x0) {
        return x0.dataPropEntityList;
    }

    static /* synthetic */ List access$400(EditFormsPanel x0) {
        return x0.booleanPropEntityList;
    }

    static /* synthetic */ List access$500(EditFormsPanel x0) {
        return x0.objPropEntityList;
    }

    static /* synthetic */ Map access$600(EditFormsPanel x0) {
        return x0.objectProperties;
    }

    static /* synthetic */ EditFormRedisplay access$700(EditFormsPanel x0) {
        return x0.formRedisplayCallbacks;
    }

    static /* synthetic */ String access$802(EditFormsPanel x0, String x1) {
        x0.editToken = x1;
        return x0.editToken;
    }
}

