/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.LeftListPanel;
import org.eaglei.datatools.client.ui.OntologyDropdown;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SharedClassChooser;

public class FilterPanel
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    HorizontalPanel subTypeFilter;
    @UiField
    Label subTypeLabel;
    @UiField
    ListBox statusFilter;
    @UiField
    ListBox resourceTypeFilter;
    @UiField
    ListBox labFilter;
    @UiField
    Label statusLabel;
    @UiField
    Label labLabel;
    @UiField
    Label resourceTypeLabel;
    @UiField
    Label filterLabel;
    @UiField
    Label totalResources;
    @UiField
    RadioButton ownedByMe;
    @UiField
    RadioButton all;
    @UiField
    Button goButton;
    SharedClassChooser<OntologyDropdown> classChooser;
    boolean isTopLevel = false;
    private final String genericOption = "All";

    public FilterPanel() {
    }

    public FilterPanel(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity) {
        this.init(filterTypeEntity, filterWorkflowEntity, filterLabEntity);
        this.initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterLabEntity, false);
    }

    public FilterPanel(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity, boolean strictFilterByOwner) {
        this.init(filterTypeEntity, filterWorkflowEntity, filterLabEntity);
        this.initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterLabEntity, strictFilterByOwner);
    }

    private void init(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.filterLabel.setVisible(true);
        if (filterTypeEntity != null && !filterTypeEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            this.initSubTypeFilter(filterTypeEntity);
        } else {
            this.isTopLevel = true;
            this.resourceTypeFilter.addItem("All");
            this.subTypeFilter.setVisible(false);
            this.subTypeLabel.setVisible(false);
            this.disable((FocusWidget)this.resourceTypeFilter);
        }
        if (filterTypeEntity.equals((Object)EIEntity.NULL_ENTITY) && filterWorkflowEntity.equals((Object)EIEntity.NULL_ENTITY) && filterLabEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            this.ownedByMe.setVisible(false);
            this.all.setVisible(false);
        }
        Log.info((String)("has top-level filter? " + this.isTopLevel));
        this.initWorkflowFilter(filterWorkflowEntity);
        this.initLabFilter(filterLabEntity);
        this.initGoButton();
    }

    private void disable(FocusWidget filter) {
        filter.setEnabled(false);
        filter.setStyleName("btnDisabled");
    }

    public void setCount(int numberOfResources) {
        this.totalResources.setText("(" + numberOfResources + ") instances found");
        this.totalResources.setVisible(true);
    }

    private void initOwnerFilter(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity, boolean strictFilterByOwner) {
        this.all.setValue(Boolean.valueOf(!strictFilterByOwner));
        this.ownedByMe.setValue(Boolean.valueOf(strictFilterByOwner));
        1 clickHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.ownedByMe.addClickHandler((ClickHandler)clickHandler);
        this.all.addClickHandler((ClickHandler)clickHandler);
    }

    private void initGoButton() {
        this.goButton.setVisible(true);
        this.goButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initWorkflowFilter(EIEntity filterWorkflowEntity) {
        this.statusFilter.setVisible(true);
        this.statusLabel.setVisible(true);
        this.statusFilter.addItem("All");
        for (EIEntity entity : WorkFlowConstants.WORKFLOW_ENTITY_LIST) {
            this.statusFilter.addItem(entity.getLabel(), entity.getURI().toString());
            if (!entity.equals((Object)filterWorkflowEntity)) continue;
            this.statusFilter.setSelectedIndex(this.statusFilter.getItemCount() - 1);
        }
    }

    private void initTopLevelTypeFilter() {
        this.isTopLevel = true;
        this.resourceTypeFilter.setVisible(true);
        this.resourceTypeLabel.setVisible(true);
        this.resourceTypeFilter.addItem("All");
        for (EIClass eiclass : LeftListPanel.resourceTypes) {
            this.resourceTypeFilter.addItem(eiclass.getEntity().getLabel(), eiclass.getEntity().getURI().toString());
        }
    }

    private void initLabFilter(EIEntity filterLabEntity) {
        Log.info((String)("Got lab entity: " + filterLabEntity));
        this.labFilter.setVisible(true);
        this.labLabel.setVisible(true);
        if (ApplicationState.getInstance().getTypeEntity().equals((Object)DatatoolsUIConstants.EI_LAB_ENTITY)) {
            this.labFilter.addItem("All");
            this.disable((FocusWidget)this.labFilter);
            return;
        }
        if (!EIEntity.NULL_ENTITY.equals((Object)filterLabEntity)) {
            this.labFilter.addItem(filterLabEntity.getLabel(), filterLabEntity.getURI().toString());
        } else {
            this.labFilter.addItem("All");
        }
        if (!EIEntity.NULL_ENTITY.equals((Object)ApplicationState.getInstance().getLabEntity())) {
            this.disable((FocusWidget)this.labFilter);
        } else {
            this.labFilter.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void initSubTypeFilter(EIEntity filterTypeEntity) {
        Log.info((String)("got selected entity: " + filterTypeEntity));
        this.resourceTypeFilter.setVisible(false);
        this.resourceTypeLabel.setVisible(false);
        this.classChooser = new SharedClassChooser((OntologyDropdownBase)new OntologyDropdown());
        this.classChooser.setTextBoxStyle("formText");
        this.subTypeFilter.add((Widget)this.classChooser);
        this.subTypeLabel.setVisible(false);
        this.subTypeFilter.setVisible(true);
        ClientModelManager.INSTANCE.getClass(ApplicationState.getInstance().getTypeUri(), (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isGenericOption(String label) {
        return "All".equals(label);
    }

    static /* synthetic */ boolean access$000(FilterPanel x0, String x1) {
        return x0.isGenericOption(x1);
    }
}

