/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.EIResourcesGrid;
import org.eaglei.datatools.client.ui.FormsPanelFactory;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.model.EIURI;

public class MainController
implements ApplicationStateChangeListener {
    public static final String DATATOOLS_FILTER = "DatatoolsFilter";
    public static final String DATATOOLS_CONTROLS = "DatatoolsControls";

    public MainController() {
        ApplicationState.getInstance().addApplicationStateListener((ApplicationStateChangeListener)this);
        this.onApplicationStateChange();
    }

    public void onApplicationStateChange() {
        if (!ApplicationState.getInstance().hasUser()) {
            Log.info((String)"no user!");
            Datatools.clearDataPanel();
            return;
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.list) {
            this.drawGrid();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.view) {
            this.drawView();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.edit) {
            this.drawEdit();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter) {
            this.drawGrid();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            Log.info((String)"showing empty grid");
            Datatools.clearDataPanel();
            Datatools.showData((Widget)new EIResourcesGrid());
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.labs) {
            this.drawGrid();
        }
    }

    protected void drawGrid() {
        EIURI labUri;
        EIURI WFStateUri;
        EIURI typeUri;
        Log.info((String)("showing grid with mode " + ApplicationState.getInstance().getMode()));
        Datatools.clearDataPanel();
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            Datatools.showData((Widget)new EIResourcesGrid());
            return;
        }
        if (!(ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources || ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter || ApplicationState.getInstance().hasLab() || ApplicationState.getInstance().hasType() || ApplicationState.getInstance().hasFilters())) {
            Log.info((String)"no lab, no type, no filters, no grid!");
            Datatools.showData((Widget)new EIResourcesGrid());
            return;
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter) {
            typeUri = ApplicationState.getInstance().getFilterTypeUri();
            WFStateUri = ApplicationState.getInstance().getFilterWorkflowUri();
            labUri = ApplicationState.getInstance().getFilterLabUri();
            Log.info((String)("setting parameters for filter query: " + typeUri + ", " + WFStateUri + ", " + labUri));
        } else {
            typeUri = ApplicationState.getInstance().getTypeUri();
            WFStateUri = EIURI.NULL_EIURI;
            labUri = ApplicationState.getInstance().getLabUri();
            Log.info((String)("setting parameters for normal query: " + typeUri + ", " + WFStateUri + ", " + labUri));
        }
        Datatools.showGlasspane();
        try {
            ClientRepositoryToolsManager.INSTANCE.getFilterQuery(ApplicationState.getInstance().getUserURI().toString(), typeUri, WFStateUri, labUri, ApplicationState.getInstance().isStrictlyFilteredByOwner(), (ClientRepositoryToolsManager.EIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
        }
    }

    protected void drawView() {
        Log.info((String)("viewing " + ApplicationState.getInstance().getInstanceEntity()));
        Datatools.clearDataPanel();
        Datatools.showData((Widget)FormsPanelFactory.generateViewForm((EIURI)ApplicationState.getInstance().getInstanceUri()));
    }

    protected void drawEdit() {
        Log.info((String)("editing " + ApplicationState.getInstance().getInstanceEntity()));
        Datatools.clearDataPanel();
        if (!ApplicationState.getInstance().hasInstance()) {
            Datatools.showData((Widget)FormsPanelFactory.generateNewForm((EIURI)ApplicationState.getInstance().getTypeUri()));
        } else {
            Datatools.showData((Widget)FormsPanelFactory.generateEditForm((EIURI)ApplicationState.getInstance().getInstanceUri()));
        }
    }

    public void onLogIn(String username, String userUri) {
        Log.info((String)("main controller logged in, calling on AppStateChange; mode = " + ApplicationState.getInstance().getMode() + "; type = " + ApplicationState.getInstance().getTypeEntity()));
        this.onApplicationStateChange();
    }

    public void onLogOut() {
        this.onApplicationStateChange();
    }
}

