/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import java.util.HashMap;
import java.util.Set;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryTokenObject {
    private static final String MODE_VARIABLE = "mode";
    protected static final String INSTANCE_URI_VARIABLE = "instanceUri";
    protected static final String INSTANCE_LABEL_VARIABLE = "instanceLabel";
    protected static final String TYPE_URI_VARIABLE = "typeUri";
    protected static final String TYPE_LABEL_VARIABLE = "typeLabel";
    protected static final String LAB_URI_VARIABLE = "labUri";
    protected static final String LAB_LABEL_VARIABLE = "labLabel";
    protected static final String FILTER_TYPE_LABEL_VARIABLE = "filterTypeLabel";
    protected static final String FILTER_LAB_LABEL_VARIABLE = "filterLabLabel";
    protected static final String FILTER_WF_LABEL_VARIABLE = "filterWorkflowLabel";
    protected static final String FILTER_TYPE_URI_VARIABLE = "filterTypeUri";
    protected static final String FILTER_LAB_URI_VARIABLE = "filterLabUri";
    protected static final String FILTER_WF_URI_VARIABLE = "filterWorkflowUri";
    protected static final String FILTER_BY_OWNER = "strictOwnerFilter";
    private Mode mode = null;
    private EIEntity instanceEntity = EIEntity.NULL_ENTITY;
    private EIURI instanceUri = EIURI.NULL_EIURI;
    private String instanceLabel = null;
    private EIEntity typeEntity = EIEntity.NULL_ENTITY;
    private EIURI typeUri = EIURI.NULL_EIURI;
    private String typeLabel = null;
    private EIEntity labEntity = EIEntity.NULL_ENTITY;
    private EIURI labUri = EIURI.NULL_EIURI;
    private String labLabel = null;
    private EIEntity filterLabEntity = EIEntity.NULL_ENTITY;
    private EIEntity filterTypeEntity = EIEntity.NULL_ENTITY;
    private EIEntity filterWorkflowEntity = EIEntity.NULL_ENTITY;
    protected static final Mode defaultMode = Mode.resources;
    private boolean filterByOwner;
    private HashMap<String, String> variableMap = new HashMap();

    public QueryTokenObject() {
        this.setMode(defaultMode);
    }

    public QueryTokenObject(String tokenString) {
        this.fromString(tokenString);
    }

    public Mode getMode() {
        return this.mode == null ? defaultMode : this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.variableMap.put("mode", mode.toString());
    }

    public EIEntity getInstanceEntity() {
        return this.instanceEntity;
    }

    public void setInstanceEntity(EIEntity instanceEntity) {
        this.instanceEntity = instanceEntity;
        this.addToMap(instanceEntity, "instanceUri", "instanceLabel");
    }

    public EIEntity getTypeEntity() {
        return this.typeEntity;
    }

    public void setTypeEntity(EIEntity typeEntity) {
        this.typeEntity = typeEntity;
        this.addToMap(typeEntity, "typeUri", "typeLabel");
    }

    public EIEntity getLabEntity() {
        return this.labEntity;
    }

    public void setLabEntity(EIEntity labEntity) {
        this.labEntity = labEntity;
        this.addToMap(labEntity, "labUri", "labLabel");
    }

    public EIEntity getFilterLabEntity() {
        return this.filterLabEntity;
    }

    public void setFilterLabEntity(EIEntity filterLabEntity) {
        this.filterLabEntity = filterLabEntity;
        this.addToMap(filterLabEntity, "filterLabUri", "filterLabLabel");
    }

    public EIEntity getFilterTypeEntity() {
        return this.filterTypeEntity;
    }

    public void setFilterTypeEntity(EIEntity filterTypeEntity) {
        this.filterTypeEntity = filterTypeEntity;
        this.addToMap(filterTypeEntity, "filterTypeUri", "filterTypeLabel");
    }

    public EIEntity getFilterWorkflowEntity() {
        return this.filterWorkflowEntity;
    }

    public void setFilterWorkflowEntity(EIEntity filterWorkflowEntity) {
        this.filterWorkflowEntity = filterWorkflowEntity;
        this.addToMap(filterWorkflowEntity, "filterWorkflowUri", "filterWorkflowLabel");
    }

    protected void addToMap(EIEntity newEntity, String uriVariable, String labelVariable) {
        if (this.hasUri(newEntity)) {
            this.variableMap.put(uriVariable, newEntity.getURI().toString());
            this.variableMap.put(labelVariable, newEntity.getLabel().toString());
        } else {
            this.variableMap.remove(uriVariable);
            this.variableMap.remove(labelVariable);
        }
    }

    protected void addToMap(String label, String value) {
        this.variableMap.put(label, value);
    }

    public boolean isStrictlyFilteredByOwner() {
        return this.filterByOwner;
    }

    public void setStrictFilterByOwner(boolean filterByOwner) {
        this.filterByOwner = filterByOwner;
        this.addToMap("strictOwnerFilter", filterByOwner + "");
    }

    public String toString() {
        Set keySet = this.variableMap.keySet();
        if (keySet.size() == 0) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("history?");
        for (String key : keySet) {
            sbuf.append(key + "=" + (String)this.variableMap.get(key) + "&");
        }
        return sbuf.toString().replaceAll("&$", "");
    }

    public QueryTokenObject fromString(String token) {
        String[] splitArray;
        this.variableMap.clear();
        for (String splitedString : splitArray = token.split("\\?")[1].split("&")) {
            String[] variableFromSplitString = splitedString.split("=");
            if (variableFromSplitString == null || variableFromSplitString.length <= 1) continue;
            this.variableMap.put(variableFromSplitString[0], variableFromSplitString[1]);
        }
        this.initializeEntities();
        this.validate();
        return this;
    }

    private EIEntity getEntityByVariable(String uriName, String labelName) {
        if (this.variableMap != null) {
            String uriValue = (String)this.variableMap.get(uriName);
            if (uriValue == null || uriValue.equals("") || uriValue.equals(EIURI.NULL_EIURI.toString())) {
                return EIEntity.NULL_ENTITY;
            }
            String labelValue = (String)this.variableMap.get(labelName);
            return EIEntity.create((String)uriValue, (String)labelValue);
        }
        return EIEntity.NULL_ENTITY;
    }

    private boolean validate() {
        if (this.hasUri(this.instanceUri) && this.mode == null) {
            this.mode = Mode.view;
            this.setMode(this.mode);
            return true;
        }
        if (this.mode == Mode.edit || this.mode == Mode.view && !this.hasUri(this.instanceUri)) {
            return false;
        }
        if (!(this.typeLabel == null && this.typeLabel.equals("") && this.typeLabel.equals("<none>") || this.hasUri(this.typeUri))) {
            return false;
        }
        return this.labLabel == null && this.labLabel.equals("") && this.labLabel.equals("<none>") || this.hasUri(this.labUri);
    }

    private void initializeEntities() {
        this.filterTypeEntity = this.getEntityByVariable("filterTypeUri", "filterTypeLabel");
        this.filterLabEntity = this.getEntityByVariable("filterLabUri", "filterLabLabel");
        this.filterWorkflowEntity = this.getEntityByVariable("filterWorkflowUri", "filterWorkflowLabel");
        this.instanceEntity = this.getEntityByVariable("instanceUri", "instanceLabel");
        this.typeEntity = this.getEntityByVariable("typeUri", "typeLabel");
        if (this.hasUri(this.typeEntity.getURI())) {
            this.setTypeEntity(this.typeEntity);
        }
        this.labEntity = this.getEntityByVariable("labUri", "labLabel");
        if (this.hasUri(this.labEntity.getURI())) {
            this.setLabEntity(this.labEntity);
        }
        this.instanceUri = this.instanceEntity.getURI();
        this.instanceLabel = this.instanceEntity.getLabel();
        this.typeUri = this.typeEntity.getURI();
        this.typeLabel = this.typeEntity.getLabel();
        this.labUri = this.labEntity.getURI();
        this.labLabel = this.labEntity.getLabel();
        String modeValue = (String)this.variableMap.get("mode");
        if (modeValue == null) {
            this.mode = null;
        }
        for (Mode whichMode : Mode.values()) {
            if (!whichMode.toString().equals(modeValue)) continue;
            this.mode = whichMode;
        }
    }

    protected boolean hasUri(EIEntity entity) {
        return this.hasUri(entity.getURI());
    }

    protected boolean hasUri(EIURI uri) {
        return uri != null && !uri.toString().equals("") && uri != EIURI.NULL_EIURI;
    }
}

