package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class ButtonsPanel extends Composite {

	interface Binder extends UiBinder<Widget, ButtonsPanel> {
	}

	private static final Binder	binder	= GWT.create(Binder.class);
	@UiField
	Label						formControlLabel;
	@UiField
	Label						wfLabel;
	//Workflow operation buttons
	@UiField
	Button						curationButton;
	@UiField
	Button						publishButton;
	@UiField
	Button						backToDraftButton;
	@UiField
	Button						withdrawButton;
	@UiField
	Button						claimReleaseButton;
	//CRUD operation Buttons
	@UiField
	Button						saveButton;
	@UiField
	Button						editButton;
	@UiField
	Button						cancelButton;
	@UiField
	Button						copyResourceButton;
	@UiField
	Button						deleteButton;
	private EIURI				wfState;
	private EIInstance			instance;
	private EIClass				rootSuperClass;
	private FormRedisplay		redisplay;

	ButtonsPanel(EIInstance anInstance, FormRedisplay aRedisplay) {
		initWidget(binder.createAndBindUi(this));
		this.instance = anInstance;
		this.wfState = instance.getWFState() == null ? null : instance.getWFState().getURI(); // May need to be just getWFState()?
		this.redisplay = aRedisplay;
		setClaimOrReleaseButtonAction();
		setDeleteButtonAction();
		setButtonsUsabiltyByWorkflowRule();
		//setWorkflowButtonsVisiblityByWorkflowState();
		//set Workflow buttons action with respective to instance workflow state 
		// TODO: use WorkFlowAction
		setAllWorkflowButtonState();
	}

	private void setAllWorkflowButtonState() {
		if ((WorkflowUtils.instanceHasCurrentOwner(instance, Datatools.getUser())) || WorkflowUtils.isPublishedOrWithdrawn(instance)) {
			setTransitionWorkFlowButtonState(curationButton, WorkFlowConstants.CURATION_STATE_LABEL, WorkFlowConstants.CURATION_ENTITY); // possible to send to curation if you can edit drafts
			setTransitionWorkFlowButtonState(publishButton, WorkFlowConstants.PUBLISH_STATE_LABEL, WorkFlowConstants.PUBLISH_ENTITY); // possible to publish if you can edit curation
			setTransitionWorkFlowButtonState(backToDraftButton, WorkFlowConstants.DRAFT_STATE_LABEL, WorkFlowConstants.DRAFT_ENTITY); // possible to return to draft if you can edit curation
			setTransitionWorkFlowButtonState(withdrawButton, WorkFlowConstants.WITHDRAW_STATE_LABEL, WorkFlowConstants.WITHDRAW_ENTITY);
		} else {
			setWorkflowButtonEnable(false);
		}
	}

	private void setTransitionWorkFlowButtonState(Button workflowButton, String workflowConstantState, final EIEntity workflowState) {
		// Note: "previous" state refers to the name of the button--only enable
		// if the state associated with the button is
		// the same as the state of the resource, since we call the button with
		// the name of the state that can promote to it
		//this will set buttons action givne the workflowstate	
		workflowButton.setVisible(true);
		if (WorkflowUtils.canUserChangeState(wfState, workflowState.getURI())) {
			setEnable(workflowButton, true);
			workflowButton.addClickHandler(new ClickHandler() {

				@Override
				public void onClick(ClickEvent event) {
					try {
						ClientRepositoryToolsManager.INSTANCE.promote(instance, workflowState, new ResultsCallback() {

							@Override
							public void loginRequired() {
								Window.alert(UIMessages.PLEASE_LOGIN);
							}

							@Override
							public void onSuccess(String arg0) {
								redisplay.drawAfterPromote(instance);
							}

							@Override
							public void onSuccess(String[] arg0) {
								redisplay.drawAfterPromote(instance);
							}
						});
					} catch (Exception e) {
						for (StackTraceElement el : e.getStackTrace())
							Log.error(el.toString());
					}
				}
			});
		} else {
			setEnable(workflowButton, false);
		}
	}

	protected void setEnable(Button workflowButton, boolean enable) {
		workflowButton.setEnabled(enable);
		if (enable)
			workflowButton.removeStyleName("btnDisabled");
		else
			workflowButton.addStyleName("btnDisabled");
	}

	public Button getSaveButton() {
		return saveButton;
	}

	public Button getCancelButton() {
		return cancelButton;
	}

	public Button getEditButton() {
		return editButton;
	}
	
	public void setRootSuperClass(EIClass superclass) {
		rootSuperClass = superclass;
	}

	public void setClaimOrReleaseButtonAction() {
		claimReleaseButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				try {
					if (claimReleaseButton.getText().equalsIgnoreCase("Claim")) {
						Log.info("claiming instance: " + instance.getInstanceLabel());
						claimOrRelease("self");
					} else {
						Log.info("releasing instance: " + instance.getInstanceLabel());
						claimOrRelease("nobody");
					}
				} catch (Exception e) {
					Log.info("error while claiming" + e.getMessage());
					Window.alert(e.getMessage());
				}
			}
		});
		if (!WorkflowUtils.instanceHasAnyOwner(instance)) {
			claimReleaseButton.setText("Claim");
		} else if (WorkflowUtils.instanceHasCurrentOwner(instance, Datatools.getUser())) {
			claimReleaseButton.setText("Share");
		} else {
			claimReleaseButton.setText("Claim");
			claimReleaseButton.setVisible(false);
			setEnable(claimReleaseButton, false);
		}
	}

	private void setDeleteButtonAction() {
		final AsyncCallback<String> aynccallback = new AsyncCallback<String>() {

			@Override
			public void onFailure(Throwable caught) {
				Window.alert(caught.getMessage());
			}

			@Override
			public void onSuccess(String result) {
				ApplicationState.getInstance().updateApplicationState(Mode.list, EIEntity.NULL_ENTITY, (rootSuperClass == null ? instance.getInstanceType() : rootSuperClass.getEntity()), ApplicationState.getInstance().getLabEntity());
			}
		};
		deleteButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if (Window.confirm(UIMessages.DELETE_CONFIRM_MESSAGE)) {
					try {
						ClientRepositoryToolsManager.repositoryService.deleteInstance(DatatoolsCookies.getSession(), instance.getInstanceURI(), aynccallback);
					} catch (Exception e) {
						Window.alert(e.getMessage());
					}
				}
			}
		});
	}

	private void claimOrRelease(final String action) throws Exception {
		AsyncCallback<String> aynccallback = new AsyncCallback<String>() {

			@Override
			public void onFailure(Throwable caught) {
				Window.alert(caught.getMessage());
			}

			@Override
			public void onSuccess(String result) {
				claimReleaseButton.setText(claimReleaseButton.getText().equalsIgnoreCase("share") ? "Claim" : "Share");
				instance.setWFOwner(action.equalsIgnoreCase("self") ? EIEntity.create(ApplicationState.getInstance().getUserURI(), ApplicationState.getInstance().getUserID()) : null);
				setButtonsUsabiltyByWorkflowRule();
				setAllWorkflowButtonState();
				redisplay.drawAfterPromote(instance);
			}
		};
		ClientRepositoryToolsManager.repositoryService.claim(DatatoolsCookies.getSession(), instance.getInstanceURI(), action, aynccallback);
	}

	private void setButtonsUsabiltyByWorkflowRule() {
		claimReleaseButton.setVisible(WorkflowUtils.getVisibiltyofWidgetByWorkflowRuleAndState(instance));
		deleteButton.setVisible(WorkflowUtils.getVisibiltyofWidgetByWorkflowRuleAndState(instance));
		editButton.setVisible(WorkflowUtils.getVisibiltyofWidgetByWorkflowRule(instance));
		setEnable(editButton, WorkflowUtils.getUsabilityofWidgetByWorkflowRule(instance, Datatools.getUser()));
		setEnable(deleteButton, WorkflowUtils.getUsabilityofWidgetByWorkflowRule(instance, Datatools.getUser()));
	}

	public void setWorkflowButtonEnable(boolean visible) {
		if (!visible) {
			setEnable(curationButton, false);
			setEnable(publishButton, false);
			setEnable(backToDraftButton, false);
			setEnable(withdrawButton, false);
		} else {
			setEnable(curationButton, true);
			setEnable(publishButton, true);
			setEnable(backToDraftButton, true);
			setEnable(withdrawButton, true);
		}
	}

	public boolean isPresenlyOwner() {
		if (instance.getWFOwner() != null && instance.getWFOwner().getURI().equals(ApplicationState.getInstance().getUserURI()))
			return true;
		else
			return false;
	}
}
