package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class EIConfirmationPopup extends PopupPanel {

	private Button			confirmButton;
	private Button			cancelButton;
	private FlowPanel		openFlowPanel;
	private FlowPanel		buttonFlowPanel;
	private VerticalPanel	vPanel;

	public EIConfirmationPopup() {
		init();
	}

	private void init() {

		vPanel = new VerticalPanel();
		openFlowPanel = new FlowPanel();
		buttonFlowPanel = new FlowPanel();
		vPanel.add(openFlowPanel);
		vPanel.add(buttonFlowPanel);
		confirmButton = new Button("Confirm");

		buttonFlowPanel.add(confirmButton);
		buttonFlowPanel.add(makeCancelButton());
		setWidget(vPanel);
		getElement().scrollIntoView();
		setPopupPositionAndShow(new PopupPanel.PositionCallback() {

			public void setPosition(int offsetWidth, int offsetHeight) {
				int left = (Window.getClientWidth() - offsetWidth) / 2;
				int top = (Window.getClientHeight() - offsetHeight) / 3;
				setPopupPosition(left, top);
			}
		});
		setStyleName("dialogWindow");

	}

	public EIConfirmationPopup(String width, String height) {
		setWidth(width);
		setHeight(height);
		init();
	}

	public void addConfirmClickHandler(ClickHandler clickHandler) {
		confirmButton.addClickHandler(clickHandler);
	}

	private Button makeCancelButton() {
		cancelButton = new Button("Cancel");
		cancelButton.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				EIConfirmationPopup.this.hide();
			}
		});
		return cancelButton;
	}

	@Override
	public void add(Widget w) {
		openFlowPanel.add(w);
	}

}
