/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.ui.WorkFlowAction;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class WorkFlowConstants {
    public static final EIURI WITHDRAW_URI = EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn");
    public static final EIURI PUBLISH_URI = EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Published");
    public static final EIURI CURATION_URI = EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Curation");
    public static final EIURI DRAFT_URI = EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Draft");
    public static final String EAGLE_I_REPO_URI = "http://eagle-i.org/ont/repo/1.0/";
    public static final String CURATION_ACTION = "Send to Curation";
    public static final String PUBLISH_ACTION = "Publish";
    public static final String DRAFT_ACTION = "Return to Draft";
    public static final String WITHDRAW_ACTION = "Withdraw";
    public static final String CLAIM_ALL_ACTION = "Claim";
    public static final String RELEASE_ALL_ACTION = "Share";
    public static final String CURATION_STATE_LABEL = "In curation";
    public static final String PUBLISH_STATE_LABEL = "Published";
    public static final String DRAFT_STATE_LABEL = "Draft";
    public static final String WITHDRAW_STATE_LABEL = "Withdrawn";
    public static final EIEntity CURATION_ENTITY = EIEntity.create((EIURI)CURATION_URI, (String)"In curation");
    public static final EIEntity PUBLISH_ENTITY = EIEntity.create((EIURI)PUBLISH_URI, (String)"Published");
    public static final EIEntity DRAFT_ENTITY = EIEntity.create((EIURI)DRAFT_URI, (String)"Draft");
    public static final EIEntity WITHDRAW_ENTITY = EIEntity.create((EIURI)WITHDRAW_URI, (String)"Withdrawn");
    public static final Map<EIURI, EIEntity> WORKFLOW_URI_MAP = new /* Unavailable Anonymous Inner Class!! */;
    public static final List<EIEntity> WORKFLOW_ENTITY_LIST = new ArrayList(WORKFLOW_URI_MAP.values());
    public static final Map<EIURI, List<EIURI>> ALLOWED_TRANSITIONS = new /* Unavailable Anonymous Inner Class!! */;
    public static final Map<EIURI, List<WorkFlowAction>> ALLOWED_ACTION_TRANSITIONS = new /* Unavailable Anonymous Inner Class!! */;
    private String statusType;

    public String getStatusType() {
        return this.statusType;
    }

    public String getStatusLabel(EIURI eiuri) {
        if (DRAFT_URI.equals((Object)eiuri)) {
            return DRAFT_STATE_LABEL;
        }
        if (CURATION_URI.equals((Object)eiuri)) {
            return CURATION_STATE_LABEL;
        }
        if (PUBLISH_URI.equals((Object)eiuri)) {
            return PUBLISH_STATE_LABEL;
        }
        if (WITHDRAW_URI.equals((Object)eiuri)) {
            return WITHDRAW_STATE_LABEL;
        }
        return EIURI.NULL_EIURI.toString();
    }

    public EIURI getStatusURI(String status) {
        if (DRAFT_STATE_LABEL.equals(status)) {
            return DRAFT_URI;
        }
        if (CURATION_STATE_LABEL.equals(status)) {
            return CURATION_URI;
        }
        if (PUBLISH_STATE_LABEL.equals(status)) {
            return PUBLISH_URI;
        }
        if (WITHDRAW_STATE_LABEL.equals(status)) {
            return WITHDRAW_URI;
        }
        return EIURI.NULL_EIURI;
    }

    public EIEntity getStatusEntity(String status) {
        if (DRAFT_STATE_LABEL.equals(status)) {
            return DRAFT_ENTITY;
        }
        if (CURATION_STATE_LABEL.equals(status)) {
            return CURATION_ENTITY;
        }
        if (PUBLISH_STATE_LABEL.equals(status)) {
            return PUBLISH_ENTITY;
        }
        if (WITHDRAW_STATE_LABEL.equals(status)) {
            return WITHDRAW_ENTITY;
        }
        return EIEntity.NULL_ENTITY;
    }

    public boolean canPerform(EIURI action, EIURI status) {
        if (ALLOWED_ACTION_TRANSITIONS.containsKey(status)) {
            return ((List)ALLOWED_ACTION_TRANSITIONS.get(status)).contains(action);
        }
        return false;
    }
}

