/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.User;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.WorkflowUtils;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class ButtonsPanel
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    Label formControlLabel;
    @UiField
    Label wfLabel;
    @UiField
    Button curationButton;
    @UiField
    Button publishButton;
    @UiField
    Button backToDraftButton;
    @UiField
    Button withdrawButton;
    @UiField
    Button claimReleaseButton;
    @UiField
    Button saveButton;
    @UiField
    Button editButton;
    @UiField
    Button cancelButton;
    @UiField
    Button copyResourceButton;
    @UiField
    Button deleteButton;
    private EIURI wfState;
    private EIInstance instance;
    private EIClass rootSuperClass;
    private FormRedisplay redisplay;

    ButtonsPanel(EIInstance anInstance, FormRedisplay aRedisplay) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.instance = anInstance;
        this.wfState = this.instance.getWFState() == null ? null : this.instance.getWFState().getURI();
        this.redisplay = aRedisplay;
        this.setClaimOrReleaseButtonAction();
        this.setDeleteButtonAction();
        this.setButtonsUsabiltyByWorkflowRule();
        this.setAllWorkflowButtonState();
    }

    private void setAllWorkflowButtonState() {
        if (WorkflowUtils.instanceHasCurrentOwner((EIInstance)this.instance, (User)Datatools.getUser()) || WorkflowUtils.isPublishedOrWithdrawn((EIInstance)this.instance)) {
            this.setTransitionWorkFlowButtonState(this.curationButton, "In curation", WorkFlowConstants.CURATION_ENTITY);
            this.setTransitionWorkFlowButtonState(this.publishButton, "Published", WorkFlowConstants.PUBLISH_ENTITY);
            this.setTransitionWorkFlowButtonState(this.backToDraftButton, "Draft", WorkFlowConstants.DRAFT_ENTITY);
            this.setTransitionWorkFlowButtonState(this.withdrawButton, "Withdrawn", WorkFlowConstants.WITHDRAW_ENTITY);
        } else {
            this.setWorkflowButtonEnable(false);
        }
    }

    private void setTransitionWorkFlowButtonState(Button workflowButton, String workflowConstantState, EIEntity workflowState) {
        workflowButton.setVisible(true);
        if (WorkflowUtils.canUserChangeState((EIURI)this.wfState, (EIURI)workflowState.getURI())) {
            this.setEnable(workflowButton, true);
            workflowButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.setEnable(workflowButton, false);
        }
    }

    protected void setEnable(Button workflowButton, boolean enable) {
        workflowButton.setEnabled(enable);
        if (enable) {
            workflowButton.removeStyleName("btnDisabled");
        } else {
            workflowButton.addStyleName("btnDisabled");
        }
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public void setRootSuperClass(EIClass superclass) {
        this.rootSuperClass = superclass;
    }

    public void setClaimOrReleaseButtonAction() {
        this.claimReleaseButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (!WorkflowUtils.instanceHasAnyOwner((EIInstance)this.instance)) {
            this.claimReleaseButton.setText("Claim");
        } else if (WorkflowUtils.instanceHasCurrentOwner((EIInstance)this.instance, (User)Datatools.getUser())) {
            this.claimReleaseButton.setText("Share");
        } else {
            this.claimReleaseButton.setText("Claim");
            this.claimReleaseButton.setVisible(false);
            this.setEnable(this.claimReleaseButton, false);
        }
    }

    private void setDeleteButtonAction() {
        3 aynccallback = new /* Unavailable Anonymous Inner Class!! */;
        this.deleteButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void claimOrRelease(String action) throws Exception {
        5 aynccallback = new /* Unavailable Anonymous Inner Class!! */;
        ClientRepositoryToolsManager.repositoryService.claim(DatatoolsCookies.getSession(), this.instance.getInstanceURI(), action, (AsyncCallback)aynccallback);
    }

    private void setButtonsUsabiltyByWorkflowRule() {
        this.claimReleaseButton.setVisible(WorkflowUtils.getVisibiltyofWidgetByWorkflowRuleAndState((EIInstance)this.instance));
        this.deleteButton.setVisible(WorkflowUtils.getVisibiltyofWidgetByWorkflowRuleAndState((EIInstance)this.instance));
        this.editButton.setVisible(WorkflowUtils.getVisibiltyofWidgetByWorkflowRule((EIInstance)this.instance));
        this.setEnable(this.editButton, WorkflowUtils.getUsabilityofWidgetByWorkflowRule((EIInstance)this.instance, (User)Datatools.getUser()));
        this.setEnable(this.deleteButton, WorkflowUtils.getUsabilityofWidgetByWorkflowRule((EIInstance)this.instance, (User)Datatools.getUser()));
    }

    public void setWorkflowButtonEnable(boolean visible) {
        if (!visible) {
            this.setEnable(this.curationButton, false);
            this.setEnable(this.publishButton, false);
            this.setEnable(this.backToDraftButton, false);
            this.setEnable(this.withdrawButton, false);
        } else {
            this.setEnable(this.curationButton, true);
            this.setEnable(this.publishButton, true);
            this.setEnable(this.backToDraftButton, true);
            this.setEnable(this.withdrawButton, true);
        }
    }

    public boolean isPresenlyOwner() {
        return this.instance.getWFOwner() != null && this.instance.getWFOwner().getURI().equals((Object)ApplicationState.getInstance().getUserURI());
    }

    static /* synthetic */ EIInstance access$000(ButtonsPanel x0) {
        return x0.instance;
    }

    static /* synthetic */ FormRedisplay access$100(ButtonsPanel x0) {
        return x0.redisplay;
    }

    static /* synthetic */ void access$200(ButtonsPanel x0, String x1) throws Exception {
        x0.claimOrRelease(x1);
    }

    static /* synthetic */ EIClass access$300(ButtonsPanel x0) {
        return x0.rootSuperClass;
    }

    static /* synthetic */ void access$400(ButtonsPanel x0) {
        x0.setButtonsUsabiltyByWorkflowRule();
    }

    static /* synthetic */ void access$500(ButtonsPanel x0) {
        x0.setAllWorkflowButtonState();
    }
}

