/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.TopPanel;
import org.eaglei.datatools.client.ui.WidgetUtils;

public class TopPanel
extends Composite
implements ClientRepositoryToolsManager.SessionListener,
ApplicationStateChangeListener {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    Label welcomeLabel;
    @UiField
    Anchor logoutAnchor;
    @UiField
    Label logoutSeparator;
    @UiField
    Anchor changePassword;
    @UiField
    Label changePasswordSeparator;
    @UiField
    UListElement loginList;
    @UiField
    TextBox userTextBox;
    @UiField
    PasswordTextBox passTextBox;
    @UiField
    Button loginButton;
    @UiField
    Image logo;
    @UiField
    Anchor searchLink;
    @UiField
    Anchor glossaryLink;
    @UiField
    Anchor helpLink;
    boolean signedIn = false;
    public static String[] wfStates;
    public static Map<String, Boolean> accessMap;

    public TopPanel() {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.passTextBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.signedIn) {
            this.logoutAnchor.setVisible(false);
            this.logoutSeparator.setVisible(false);
            this.changePassword.setVisible(false);
            this.changePasswordSeparator.setVisible(false);
        }
        this.searchLink.setHref(this.getSearchURL() == null ? "http://search.eagle-i.net/central/" : this.getSearchURL());
        this.searchLink.setTarget("_blank");
        this.glossaryLink.setHref(WidgetUtils.getGlossaryURL() == null ? "http://search.eagle-i.net/model/" : WidgetUtils.getGlossaryURL());
        this.glossaryLink.setTarget("_blank");
        this.helpLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        String imageName = WidgetUtils.getNodeNameFromURL();
        this.logo.setUrl("images/" + imageName + "_logo.png");
        this.loginButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.logoutAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.changePassword.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (DatatoolsCookies.hasSession()) {
            this.signedIn = true;
            Log.info((String)"top panel already logged in");
        }
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
    }

    private void performLogin() {
        String user = this.userTextBox.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert((String)"A user name is required.");
            return;
        }
        String pass = this.passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert((String)"A password is required.");
            return;
        }
        ClientRepositoryToolsManager.INSTANCE.logIn(user.trim(), pass.trim(), (ClientRepositoryToolsManager.ResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void performLogout() {
        ClientRepositoryToolsManager.INSTANCE.logOut();
    }

    public void onLogOut() {
        this.welcomeLabel.setText("Please login");
        this.loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.changePassword.setVisible(false);
        this.signedIn = false;
        this.userTextBox.setText("");
        this.passTextBox.setText("");
        this.logoutAnchor.setVisible(false);
        this.logoutSeparator.setVisible(false);
    }

    public void onLogIn(String username, String userUri) {
        RootPanel.get((String)"back_container").clear();
        this.welcomeLabel.setText("Welcome, " + username);
        this.changePassword.setVisible(true);
        this.changePasswordSeparator.setVisible(true);
        this.logoutAnchor.setVisible(true);
        this.logoutSeparator.setVisible(true);
        this.loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.signedIn = true;
        FlowPanel flowPanel = new FlowPanel();
        Anchor backLink = new Anchor("Back");
        flowPanel.add((Widget)backLink);
        backLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel.get((String)"back_container").add((Widget)flowPanel);
    }

    private String getSearchURL() {
        String url = GWT.getHostPageBaseURL();
        String node = WidgetUtils.getNodeNameFromURL();
        if (node != null) {
            String searchUrl = url.replace(node + ".", "search.").replace("/datatools/", "") + "/central/";
            return searchUrl;
        }
        return null;
    }

    private void back(ClickEvent arg0) {
        Anchor link = (Anchor)arg0.getSource();
        if (!History.getToken().equals("")) {
            link.setVisible(true);
            History.back();
        }
    }

    public void onApplicationStateChange() {
        if (RootPanel.get((String)"back_container").getWidget(0) != null) {
            RootPanel.get((String)"back_container").getWidget(0).setVisible(!History.getToken().equals(""));
        }
    }

    private int getHelpWindowHeight() {
        return Window.getClientHeight() + Window.getClientHeight() / 12;
    }

    private int getHelpWindowWidth() {
        return 600;
    }

    private int getHelpWindowLeft() {
        return Window.getClientWidth() - this.getHelpWindowWidth();
    }

    static /* synthetic */ void access$000(TopPanel x0) {
        x0.performLogin();
    }

    static /* synthetic */ int access$100(TopPanel x0) {
        return x0.getHelpWindowHeight();
    }

    static /* synthetic */ int access$200(TopPanel x0) {
        return x0.getHelpWindowWidth();
    }

    static /* synthetic */ int access$300(TopPanel x0) {
        return x0.getHelpWindowLeft();
    }

    static /* synthetic */ void access$400(TopPanel x0) {
        x0.performLogout();
    }

    static /* synthetic */ void access$500(TopPanel x0, ClickEvent x1) {
        x0.back(x1);
    }

    static {
        accessMap = new HashMap();
    }
}

