/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkFlowAction {
    public static final WorkFlowAction CurationAction = new WorkFlowAction("Send to Curation", WorkFlowConstants.DRAFT_ENTITY, WorkFlowConstants.CURATION_ENTITY);
    public static final WorkFlowAction PublishAction = new WorkFlowAction("Publish", WorkFlowConstants.CURATION_ENTITY, WorkFlowConstants.PUBLISH_ENTITY);
    public static final WorkFlowAction WithdrawAction = new WorkFlowAction("Withdraw", WorkFlowConstants.PUBLISH_ENTITY, WorkFlowConstants.WITHDRAW_ENTITY);
    public static final WorkFlowAction ReturnToDraftAction = new WorkFlowAction("Return to Draft", WorkFlowConstants.CURATION_ENTITY, WorkFlowConstants.DRAFT_ENTITY);
    private static Map<WorkFlowAction, List<EIEntity>> allowedActions;
    private final String name;
    private final EIEntity fromState;
    private final EIEntity toState;

    private WorkFlowAction(String name, EIEntity from, EIEntity to) {
        this.name = name;
        this.fromState = from;
        this.toState = to;
        if (allowedActions == null) {
            allowedActions = new HashMap();
        }
        if (allowedActions.get(this) == null) {
            allowedActions.put(this, new ArrayList(2));
        }
        ((List)allowedActions.get(this)).add(from);
    }

    public String getName() {
        return this.name;
    }

    public EIURI getFromState() {
        return this.fromState.getURI();
    }

    public EIURI getToState() {
        return this.toState.getURI();
    }

    public Anchor getAnchor() {
        return new Anchor(this.name);
    }

    public void perform(EIInstanceMinimal instance, ActionRedisplay redisplay) {
        try {
            ClientRepositoryToolsManager.INSTANCE.promote(instance, this.toState, (ClientRepositoryToolsManager.ResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
            Window.alert((String)e.getMessage());
        }
    }

    public void perform(EIInstance instance, FormRedisplay redisplay) {
        try {
            ClientRepositoryToolsManager.INSTANCE.promote(instance, this.toState, (ClientRepositoryToolsManager.ResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
            Window.alert((String)e.getMessage());
        }
    }

    public static String getAlertMessage(WorkFlowAction action) {
        String base = "Only resources with $STATE$ status can be $ACTION$.";
        return WorkFlowAction.makeAlertMessageBybase((WorkFlowAction)action, (String)base);
    }

    public static String getAlertMessageForUnclaimed(WorkFlowAction action) {
        String base = "You can only $ACTION$ resources with $STATE$ status for which you are the editor.";
        return WorkFlowAction.makeAlertMessageBybase((WorkFlowAction)action, (String)base);
    }

    private static String makeAlertMessageBybase(WorkFlowAction action, String base) {
        String statusList = "";
        for (EIEntity status : (List)allowedActions.get(action)) {
            statusList = statusList + ", " + new WorkFlowConstants().getStatusLabel(status.getURI());
        }
        statusList = statusList.replaceFirst(", ", "");
        Log.info((String)("status list " + statusList));
        base = base.replace("$STATE$", statusList);
        base = base.replace("$ACTION$", action.getName());
        return base;
    }
}

