/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.RESTRepositoryProviderFactory;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProviderFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.security.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RepositoryToolsModelServlet
extends RemoteServiceServlet
implements RepositoryToolsModelService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryToolsModelServlet.class);
    private RepositoryProvider provider = null;
    private EIOntModel ontModel;
    private DatatoolsConfiguration config;

    public void init() throws ServletException {
        this.config = this.getConfiguration();
        try {
            if (this.config != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"about to create provider");
                }
                this.provider = this.createProvider();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"about to load defaults (null config)");
                }
                this.loadDefaults();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error initializing RepositoryToolsModelServlet: " + e));
            throw new ServletException((Throwable)e);
        }
        this.initializeOntology();
        this.lazyLoadFactories();
        log.info((Object)"init succesful");
    }

    protected void initializeOntology() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.doDependencyInjection((ApplicationContext)ctx);
    }

    protected void doDependencyInjection(ApplicationContext springAppContext) {
        this.ontModel = (EIOntModel)springAppContext.getBean(EIOntModel.class);
    }

    private RepositoryProvider createProvider() throws Exception {
        String providerFactoryClass = this.config.getDatatoolsRepositoryProviderFactory();
        Class<?> factoryClass = Class.forName(providerFactoryClass);
        RepositoryProviderFactory factory = (RepositoryProviderFactory)factoryClass.newInstance();
        return factory.createRepositoryProvider(this.config);
    }

    private void lazyLoadFactories() {
        EIInstanceFactory.getInstance();
    }

    private void loadDefaults() throws Exception {
        log.info((Object)"Loading default provider, RESTProvider: ");
        RESTRepositoryProviderFactory factory = new RESTRepositoryProviderFactory();
        this.provider = factory.createRepositoryProvider(this.config);
        log.info((Object)("Loading default provider, RESTProvider: " + factory.toString()));
    }

    public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws Exception {
        try {
            if (instance == null) {
                log.error((Object)"trying to create a null instance");
            }
            this.handleNullSession(session);
            this.provider.createInstance(session, instance, workspaceEntity);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            for (StackTraceElement element : e.getStackTrace()) {
                log.error((Object)element.toString());
            }
            throw new LoggedException(e.getMessage());
        }
    }

    public void deleteInstance(Session session, EIURI instanceUri) throws Exception {
        try {
            this.handleNullSession(session);
            this.provider.deleteInstance(session, instanceUri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String updateInstance(Session session, EIInstance instance, String token) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.updateInstance(session, instance, token);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public User login(String user, String password) throws Exception {
        try {
            User userObj = this.provider.login(user, password);
            return userObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoggedException("Repository error:" + e.getLocalizedMessage());
        }
    }

    public void logout(Session session) throws Exception {
        try {
            this.handleNullSession(session);
            this.provider.logout(session);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public User whoami(Session session) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.whoami(session);
        }
        catch (Exception e) {
            log.error((Object)("whoami exception " + e));
            throw new LoggedException(e.getMessage());
        }
    }

    private DatatoolsConfiguration getConfiguration() throws ServletException {
        String propFile = System.getProperty("datatools.config.file");
        if (propFile == null) {
            propFile = "datatools.prop";
        }
        log.debug((Object)("Using properties file " + propFile));
        URL configURL = this.getClass().getClassLoader().getResource(propFile);
        if (configURL == null) {
            log.error((Object)("Could not locate " + propFile + " on classpath "));
            throw new ServletException("Could not locate " + propFile + " on classpath ");
        }
        try {
            File configFile = new File(configURL.toURI());
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            log.error((Object)("Error loading configuration from " + configURL + " " + e));
            throw new ServletException("Error loading configuration from " + configURL + " " + e);
        }
    }

    public boolean isOnline() {
        return this.provider.isOnline();
    }

    public List<EIInstanceMinimal> EIQuery(Session session, String query) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.EIQuery(session, query);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getEmptyEIInstance(session, classUri, instanceEntity);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws Exception {
        try {
            this.handleNullSession(session);
            EIInstance instance = this.provider.getEmptyEIInstance(session, classUri);
            if (instance.getInstanceClass() == null) {
                instance.setInstanceClass(this.ontModel.getClass(classUri));
            }
            return instance;
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance deepCopy(Session session, EIURI originalUri) throws Exception {
        this.handleNullSession(session);
        return this.provider.deepCopy(session, originalUri);
    }

    public List<EIURI> getNewInstanceID(Session session, int count) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getNewInstanceID(session, count);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String query(Session session, String sparql) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.query(session, sparql);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getInstance(Session session, EIURI instanceID) throws Exception {
        this.handleNullSession(session);
        return this.provider.getInstance(session, instanceID);
    }

    public String claim(Session session, EIURI uri, String claimant) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.claim(session, uri, claimant);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] claim(Session session, EIURI[] uriArray, String claimant) throws Exception {
        try {
            this.handleNullSession(session);
            String[] responses = new String[uriArray.length];
            int i = 0;
            for (EIURI uri : uriArray) {
                responses[i++] = this.provider.claim(session, uri, claimant);
            }
            return responses;
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String promote(Session session, EIURI uri, EIURI newState) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.promote(session, uri, newState);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] bulkPromote(Session session, List<EIURI> urisToPromote, EIURI newState) throws Exception {
        try {
            this.handleNullSession(session);
            String[] responses = new String[urisToPromote.size()];
            int i = 0;
            for (EIURI uri : urisToPromote) {
                responses[i++] = this.provider.promote(session, uri, newState);
            }
            return responses;
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String[] getWFStates(Session session) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getWFStates(session);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getFilterQuery(session, classUri, state, lab);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getFilterQuery(session, classUri, state, lab, strictOwnerFilter);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String retrieveLabel(Session session, EIURI uri) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.retrieveLabel(session, uri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public Map<EIEntity, String> retrieveLabels(Session session, List<EIEntity> entities) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.retrieveLabels(session, entities);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public Map<EIURI, String> retrieveUriLabels(Session session, List<EIURI> uris) throws Exception {
        this.handleNullSession(session);
        return this.provider.retrieveUriLabels(session, uris);
    }

    public EIClass getRootSuperclassForInstanceUri(Session session, EIURI instanceUri) throws Exception {
        this.handleNullSession(session);
        EIInstance instance = this.provider.getInstance(session, instanceUri);
        if (instance == null) {
            return null;
        }
        return this.getRootSuperClass(instance.getInstanceClass());
    }

    public List<EIClass> getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri) throws Exception {
        this.handleNullSession(session);
        EIInstance instance = this.provider.getInstance(session, instanceUri);
        if (instance == null) {
            return null;
        }
        ArrayList<EIClass> classes = this.ontModel.getSuperClasses(instance.getInstanceType().getURI());
        if (classes == null || classes.isEmpty()) {
            classes = new ArrayList<EIClass>(1);
        }
        classes.add(this.ontModel.getClass(instance.getInstanceType().getURI()));
        return classes;
    }

    public EIClass getRootSuperClass(EIClass eclass) throws LoggedException {
        while (eclass.hasSuperClass()) {
            eclass = this.ontModel.getSuperClass(eclass);
        }
        return eclass;
    }

    public EIClass getSuperClass(EIClass eclass) throws LoggedException {
        eclass = this.ontModel.getSuperClass(eclass);
        return eclass;
    }

    public boolean isModelClassURI(String uri) {
        return this.ontModel.isModelClassURI(uri);
    }

    public List<Workspace> getWorkspaces(Session session) throws Exception {
        this.handleNullSession(session);
        return this.provider.getWorkspaces(session);
    }

    public List<EIInstanceMinimal> referencedByQuery(Session session, EIURI resourceUri, boolean strictOwnerFilter) throws Exception {
        this.handleNullSession(session);
        return this.provider.referencedByQuery(session, resourceUri, strictOwnerFilter);
    }

    public List<EIProperty> getAllEquivalentClasses(List<EIProperty> propertiesToPopulate) {
        for (EIProperty property : propertiesToPopulate) {
            if (!(property instanceof EIObjectProperty)) continue;
            EIObjectProperty objectProperty = (EIObjectProperty)property;
            log.debug((Object)("equivalent classes for object property " + property));
            List assertedRanges = objectProperty.getRangeList();
            log.debug((Object)("   had " + (assertedRanges == null ? "0" : Integer.valueOf(assertedRanges.size())) + " asserted ranges"));
            for (EIClass range : assertedRanges) {
                if (range == null || range.equals((Object)EIClass.NULL_CLASS) || range.getEntity() == null || range.getEntity().equals((Object)EIEntity.NULL_ENTITY)) continue;
                List equivalentClasses = this.ontModel.getEquivalentClasses(range.getEntity().getURI());
                if (equivalentClasses != null) {
                    range.setEquivalentClasses(equivalentClasses);
                    for (EIEquivalentClass equivalence : equivalentClasses) {
                        log.debug((Object)("    equivalent class " + (equivalence.getEquivalentTo() == null ? "empty" : Integer.valueOf(equivalence.getEquivalentTo().size()))));
                    }
                    continue;
                }
                log.debug((Object)"null classes");
            }
        }
        return propertiesToPopulate;
    }

    private boolean isValid(Session session) {
        return session != null && session.getSessionId() != null;
    }

    private void handleNullSession(Session session) throws Exception {
        if (!this.isValid(session)) {
            throw new LoggedException("No session information was found.");
        }
    }
}

