/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.EIResourcesGrid;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.WorkFlowAction;
import org.eaglei.datatools.client.ui.WorkflowUtils;
import org.eaglei.datatools.client.ui.listeners.RowDeletionListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

public class GridRowWidget
extends HorizontalPanel {
    private static final String deleteHtml = "<a>delete</a>";
    private static final String unClaimHtml = "<a>share</a>";
    private static final String claimHtml = "<a>claim</a>";
    private static final String editHtml = "<a>edit</a>";
    private static final String withdrawHtml = "<a>withdraw</a>";
    private static final String publishHtml = "<a>publish</a>";
    private EIInstanceMinimal instance;
    private int rowIndex;
    private final ActionRedisplay redisplay;
    private final RowDeletionListener listener;
    private HTML[] formActions = new HTML[]{new HTML(), new HTML(), new HTML()};
    private CheckBox checkBox;
    private Label editor;

    public GridRowWidget(EIInstanceMinimal instance, RowDeletionListener deletionListener) {
        this.listener = deletionListener;
        this.redisplay = new /* Unavailable Anonymous Inner Class!! */;
        this.init(instance);
    }

    public GridRowWidget(EIInstanceMinimal instance, String[] widths, RowDeletionListener deletionListener, int rowIndex) {
        this.listener = deletionListener;
        this.redisplay = new /* Unavailable Anonymous Inner Class!! */;
        this.setStyleName("dtListGridRow");
        this.init(instance);
        this.rowIndex = rowIndex;
    }

    private void init(EIInstanceMinimal instance) {
        this.instance = instance;
        this.setStyleName("dtListGridRow");
        HTML instanceLabel = new HTML("<a>" + instance.getInstanceLabel() + "</a>");
        this.makeClickable(instance.getEntity(), instance.getInstanceType(), instanceLabel);
        if (!this.isNull(instance.getLab())) {
            VerticalPanel firstCell = new VerticalPanel();
            firstCell.setSpacing(0);
            firstCell.setBorderWidth(0);
            HTML labLabel = new HTML("<i><a>" + instance.getLab().getLabel() + "</a></i>");
            this.makeClickable(instance.getLab(), DatatoolsUIConstants.EI_LAB_ENTITY, labLabel);
            firstCell.add((Widget)instanceLabel);
            firstCell.add((Widget)labLabel);
            this.addWithStyle((Widget)firstCell, 0);
            firstCell.setStyleName("firstCell");
        } else {
            this.addWithStyle((Widget)instanceLabel, 0);
        }
        this.addWithStyle((Widget)new Label(instance.getInstanceType().getLabel()), 1);
        String date = instance.getCreationDate();
        Label dateLabel = new Label(" ");
        if (date != null) {
            dateLabel = new Label(WidgetUtils.formatDate((String)date));
        }
        this.addWithStyle((Widget)dateLabel, 2);
        Label status = new Label(this.isNull(instance.getWFState()) ? " " : instance.getWFState().getLabel());
        this.addWithStyle((Widget)status, 3);
        this.addWithStyle((Widget)this.formActions[0], 4);
        this.addWithStyle((Widget)this.formActions[1], 5);
        this.addWithStyle((Widget)this.formActions[2], 6);
        this.checkBox = new CheckBox();
        this.checkBox.setVisible(this.shouldDisplayCheckBox());
        this.addWithStyle((Widget)this.checkBox, 7);
        this.redrawActions();
    }

    private void makeClickable(EIEntity entityToDisplay, EIEntity typeOfEntityToDisplay, HTML label) {
        label.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getEditorText(EIInstanceMinimal instance) {
        if (instance.getWFOwner() == null || EIEntity.NULL_ENTITY.equals((Object)instance.getWFOwner())) {
            return "nobody";
        }
        return instance.getWFOwner().toString();
    }

    public EIInstanceMinimal getInstance() {
        return this.instance;
    }

    public CheckBox getCheckBox() {
        return this.checkBox;
    }

    public HTML[] getFormActions() {
        return this.formActions;
    }

    private boolean shouldDisplayCheckBox() {
        if (ApplicationState.getInstance().hasLabType()) {
            return false;
        }
        return WorkflowUtils.canUserChangeState((EIURI)this.instance.getWFState().getURI());
    }

    private boolean isPublishedOrWithdrawn() {
        return WorkFlowConstants.PUBLISH_ENTITY.equals((Object)this.instance.getWFState()) || WorkFlowConstants.WITHDRAW_ENTITY.equals((Object)this.instance.getWFState());
    }

    private void setClaimOrRelease() {
        if (WorkflowUtils.canUserChangeState((EIURI)this.instance.getWFState().getURI()) && !this.isPublishedOrWithdrawn()) {
            if (this.instanceHasOwner()) {
                this.formActions[0] = this.makeHtmlWidgetByHtmlString(unClaimHtml);
                this.formActions[0].addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.formActions[0] = this.makeHtmlWidgetByHtmlString(claimHtml);
                this.formActions[0].addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void setEdit() {
        if (WorkflowUtils.canUserChangeState((EIURI)this.instance.getWFState().getURI())) {
            if (this.instanceHasOwner() || this.isPublishedOrWithdrawn()) {
                this.formActions[1] = this.makeHtmlWidgetByHtmlString(editHtml);
                this.formActions[1].addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.formActions[1] = new HTML();
            }
        } else {
            this.formActions[1] = new HTML();
        }
    }

    private void setDelete() {
        if (WorkflowUtils.canUserChangeState((EIURI)this.instance.getWFState().getURI()) && this.instanceHasOwner() && !this.isPublishedOrWithdrawn()) {
            this.formActions[2] = this.makeHtmlWidgetByHtmlString(deleteHtml);
            this.formActions[2].addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.formActions[2] = new HTML();
        }
    }

    public boolean instanceHasOwner(EIInstanceMinimal minimal) {
        return WorkflowUtils.isNotNull((EIEntity)minimal.getWFOwner());
    }

    public boolean instanceHasOwner() {
        return this.instanceHasOwner(this.instance);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    private HTML makeHtmlWidgetByHtmlString(String html) {
        HTML htmlWidget = new HTML(html);
        return htmlWidget;
    }

    private void claimAction() {
        OwnershipAction.ClaimAction.perform(this.instance, this.redisplay);
    }

    private void releaseAction() {
        OwnershipAction.ReleaseAction.perform(this.instance, this.redisplay);
    }

    private void publishAction() {
        WorkFlowAction.PublishAction.perform(this.instance, this.redisplay);
    }

    public void redrawActions() {
        this.remove((Widget)this.getFormActions()[0]);
        this.remove((Widget)this.getFormActions()[1]);
        this.remove((Widget)this.getFormActions()[2]);
        this.remove((Widget)this.checkBox);
        this.setEdit();
        this.setDelete();
        this.setClaimOrRelease();
        this.addWithStyle((Widget)this.getFormActions()[0], 4);
        this.addWithStyle((Widget)this.getFormActions()[1], 5);
        this.addWithStyle((Widget)this.getFormActions()[2], 6);
        this.addWithStyle((Widget)this.checkBox, 7);
        this.checkBox.setVisible(this.shouldDisplayCheckBox());
    }

    private EIEntity getUpdatedLabEntity(EIEntity instanceEntity) {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter) {
            return ApplicationState.getInstance().hasLabType() ? instanceEntity : ApplicationState.getInstance().getLabEntity();
        }
        return ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.labs ? instanceEntity : ApplicationState.getInstance().getLabEntity();
    }

    private boolean isNull(EIEntity entity) {
        return entity == null || entity.equals((Object)EIEntity.NULL_ENTITY);
    }

    private void addWithStyle(Widget widget, int column) {
        this.add(widget);
        String width = EIResourcesGrid.widths[column] + "px";
        this.setCellWidth(widget, width);
    }

    static /* synthetic */ RowDeletionListener access$000(GridRowWidget x0) {
        return x0.listener;
    }

    static /* synthetic */ EIEntity access$100(GridRowWidget x0, EIEntity x1) {
        return x0.getUpdatedLabEntity(x1);
    }

    static /* synthetic */ void access$200(GridRowWidget x0) {
        x0.releaseAction();
    }

    static /* synthetic */ void access$300(GridRowWidget x0) {
        x0.claimAction();
    }

    static /* synthetic */ EIInstanceMinimal access$400(GridRowWidget x0) {
        return x0.instance;
    }
}

