package org.eaglei.datatools.client.rpc;

import java.util.List;
import java.util.Map;

import org.eaglei.security.Session;
import org.eaglei.datatools.User;
import org.eaglei.datatools.Workspace;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The client side stub for the RPC service.
 */
public interface RepositoryToolsModelServiceAsync {

	public void EIQuery(Session session, String query, AsyncCallback<List<EIInstanceMinimal>> callback);
	
	public void retrieveLabel(Session session, EIURI uri, AsyncCallback<String> callback);    
    public void retrieveLabels(Session session, List<EIEntity> entities, AsyncCallback<Map<EIEntity,String>> callback) throws Exception;
    public void retrieveUriLabels(Session session, List<EIURI> entities, AsyncCallback<Map<EIURI,String>> callback) throws Exception;
    
    /*
     * instance functionality
     */

   
    public void getNewInstanceID(Session session, int count, AsyncCallback<List<EIURI>> callback) throws Exception ;;
    public void getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity, AsyncCallback<EIInstance> asyncCallback);;
    public void getEmptyEIInstance(Session session, EIURI classUri, AsyncCallback<EIInstance> asyncCallback);;
    public void getInstance(Session session, EIURI instanceID, AsyncCallback<EIInstance> callback) throws Exception ;;
    public void updateInstance(Session session, EIInstance instance, String token, AsyncCallback<String> callback) throws Exception ;;
    public void createInstance(Session session, EIInstance instance,EIEntity workspaceEntity, AsyncCallback callback) throws Exception ;;
    public void deleteInstance(Session session, EIURI instanceUri, AsyncCallback callback) throws Exception ;;
    public void deepCopy(Session session, EIURI originalUri, AsyncCallback callback) throws Exception ;
    
    public void getFilterQuery(Session session,  final EIURI classUri, final EIURI state, final EIURI lab,AsyncCallback<List<EIInstanceMinimal>> instances) throws Exception;
    public void getFilterQuery(Session session,  final EIURI classUri, final EIURI state, final EIURI lab, boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> instances) throws Exception;
    public void getWorkspaces(Session session,AsyncCallback<List<Workspace>> callback);

    public void referencedByQuery(Session session, final EIURI resourceUri, final boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> instances) throws Exception;
    /*
     * free form SPARQL end point
     */

    
    public void query(Session session, String sparql, AsyncCallback<String> callback) throws Exception ;;
    

  

    
    /*
     * login/logout etc
     */
    public void login(String user, String password, AsyncCallback<User> callback) throws Exception ;;    
    public void logout(Session session, AsyncCallback callback) throws Exception ;;
    public void whoami(Session session, AsyncCallback callback) throws Exception ;;
    public void isOnline(AsyncCallback callback) throws Exception ;;
    
    /*
     * workflow fake REST API
     */
    
    public void promote(Session session, EIURI uri, EIURI newState, AsyncCallback<String> callback) throws Exception;;;
    public void bulkPromote(Session session, List<EIURI> urisToPromote, EIURI newState, AsyncCallback<String[]> callback) throws Exception;;
    public void claim(Session session, EIURI uri, String claimant, AsyncCallback<String> callback) throws Exception;;
    public void claim(Session session, EIURI[] uri, String claimant, AsyncCallback<String[]> callback) throws Exception;;
    public void getWFStates(Session session, AsyncCallback<String[]> callback) throws Exception;
    
    /* hybrid repository/ontology method(s) not found on provider */
    public void getRootSuperclassForInstanceUri(Session session, EIURI instanceUri, AsyncCallback<EIClass> callback) throws Exception;
    public void getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri, AsyncCallback<List<EIClass>> callback) throws Exception;
    
    /* ontology methods moved to the repository service so we can just use ModelService */
	void getSuperClass(EIClass eclass, AsyncCallback<EIClass> callback);	
	void getRootSuperClass(EIClass eclass, AsyncCallback<EIClass> callback);

	public void getAllEquivalentClasses(List<EIProperty> propertiesToPopulate, AsyncCallback<List<EIProperty>> asyncCallback);

}
