package org.eaglei.datatools.client.ui;

import java.util.ArrayList;

import org.eaglei.datatools.client.event.BrowserBackOrForwardEvent;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.History;

public class ApplicationState implements ValueChangeHandler<String> {

	private final QueryTokenObject						queryTokenObject;
	private static ApplicationState						applicationState;
	final private HandlerManager						handlerManager	= new HandlerManager(this);
	private String										sessionID;
	private EIEntity									user;
	private ArrayList<ApplicationStateChangeListener>	listeners;

	//	private List<EIClass>								resourceTypes;
	//	private Map<String, EIClass> resourceTypeLabels = new HashMap<String, EIClass>();
	public static ApplicationState getInstance() {
		if (applicationState == null) {
			applicationState = new ApplicationState();
		}
		return applicationState;
	}

	public static ApplicationState newInstance(String bookmark) {
		ArrayList<ApplicationStateChangeListener> oldListeners = ApplicationState.getInstance().listeners;
		applicationState = new ApplicationState(bookmark);
		Log.info("qto from bookmark " + applicationState.queryTokenObject.toString());
		for (ApplicationStateChangeListener oldListener : oldListeners) {
			applicationState.addApplicationStateListener(oldListener);
		}
		return applicationState;
	}

	private ApplicationState() {
		queryTokenObject = new QueryTokenObject();
		listeners = new ArrayList<ApplicationStateChangeListener>();
		History.addValueChangeHandler(this);
	}

	private ApplicationState(String bookmark) {
		queryTokenObject = new QueryTokenObject(bookmark);
		listeners = new ArrayList<ApplicationStateChangeListener>();
		History.addValueChangeHandler(this);
	}

	public Mode getMode() {
		return queryTokenObject.getMode();
	}

	public void setMode(Mode newMode) {
		queryTokenObject.setMode(newMode);
		update();
	}

	public EIEntity getInstanceEntity() {
		return queryTokenObject.getInstanceEntity();
	}

	public EIURI getInstanceUri() {
		return getInstanceEntity().getURI();
	}

	public void setInstanceEntity(EIEntity newEntity) {
		queryTokenObject.setInstanceEntity(getCorrectEntity(newEntity));
		update();
	}

	public boolean hasInstance() {
		return getCorrectEntity(getInstanceEntity()) != EIEntity.NULL_ENTITY;
	}

	public EIEntity getTypeEntity() {
		return queryTokenObject.getTypeEntity();
	}

	public EIURI getTypeUri() {
		return queryTokenObject.getTypeEntity().getURI();
	}

	private void setTypeEntity(EIEntity typeEntity) {
		queryTokenObject.setTypeEntity(getCorrectEntity(typeEntity));
		update();
	}

	public EIEntity getLabEntity() {
		return queryTokenObject.getLabEntity();
	}

	public EIURI getLabUri() {
		return getLabEntity().getURI();
	}

	public void setLabEntity(EIEntity labEntity) {
		queryTokenObject.setLabEntity(getCorrectEntity(labEntity));
		update();
	}

	public EIEntity getFilterTypeEntity() {
		return queryTokenObject.getFilterTypeEntity();
	}

	public EIURI getFilterTypeUri() {
		return getFilterTypeEntity().getURI();
	}

	public boolean hasFilterTypeEntity() {
		return getFilterTypeEntity() != EIEntity.NULL_ENTITY;
	}

	private void setFilterTypeEntity(EIEntity filterTypeEntity) {
		queryTokenObject.setFilterTypeEntity(getCorrectEntity(filterTypeEntity));
		update();
	}

	public EIEntity getFilterLabEntity() {
		return queryTokenObject.getFilterLabEntity();
	}

	public EIURI getFilterLabUri() {
		return getFilterLabEntity().getURI();
	}

	public void setFilterLabEntity(EIEntity filterLabEntity) {
		queryTokenObject.setFilterLabEntity(filterLabEntity);
		update();
	}

	public EIEntity getFilterWorkflowEntity() {
		return queryTokenObject.getFilterWorkflowEntity();
	}

	public EIURI getFilterWorkflowUri() {
		return getFilterWorkflowEntity().getURI();
	}

	public void setFilterWorkflowEntity(EIEntity filterWorkflowEntity) {
		queryTokenObject.setFilterWorkflowEntity(filterWorkflowEntity);
		update();
	}

	public boolean isStrictlyFilteredByOwner() {
		return queryTokenObject.isStrictlyFilteredByOwner();
	}

	public void setStrictFilterByOwner(boolean filterByOwner) {
		queryTokenObject.setStrictFilterByOwner(filterByOwner);
		update();
	}

	public EIEntity getWorkspaceEntity() {
		return queryTokenObject.getWorkspaceEntity();
	}

	public void setWorkspaceEntity(EIEntity workspaceEntity) {
		queryTokenObject.setWorkspaceEntity(workspaceEntity);
		update();
		
	}
	
	
	public boolean hasType() {
		return getCorrectEntity(getTypeEntity()) != EIEntity.NULL_ENTITY;
	}

	public boolean hasLab() {
		return getCorrectEntity(getLabEntity()) != EIEntity.NULL_ENTITY;
		// TODO: does this also need to ask about filterlab?
	}

	public boolean hasLabType() {
		return WidgetUtils.isLabProperty(getTypeEntity());
	}

	public void onValueChange(ValueChangeEvent<String> event) {
		handlerManager.fireEvent(new BrowserBackOrForwardEvent(queryTokenObject));
		Log.info("history change event value '" + event.getValue() + "'");
		queryTokenObject.fromString(event.getValue());
		notifyListeners();
	}

	private void notifyListeners() {
		for (ApplicationStateChangeListener listener : listeners) {
			listener.onApplicationStateChange();
		}
	}

	public String getSessionID() {
		return sessionID;
	}

	public void setSessionID(String sessionID) {
		this.sessionID = sessionID;
	}

	public String getUserID() {
		return user.getLabel();
	}

	public EIURI getUserURI() {
		return user.getURI();
	}

	public EIEntity getUser() {
		return user;
	}

	public void setUser(EIEntity userEntity) {
		if (userEntity == null)
			this.user = EIEntity.NULL_ENTITY;
		else
			this.user = userEntity;
	}

	public HandlerManager getHandlerManager() {
		return handlerManager;
	}

	//TODO share some of the implementation of these two methods
	public void updateApplicationState(Mode mode, EIEntity instanceEntity, EIEntity typeEntity, EIEntity labEntity) {
		updateApplicationState(mode, instanceEntity, typeEntity, labEntity, false);
	}

	public void updateApplicationState(Mode mode, EIEntity instanceEntity, EIEntity typeEntity, EIEntity labEntity, boolean updateFilterEntities) {
		queryTokenObject.setMode(mode);
		queryTokenObject.setInstanceEntity(getCorrectEntity(instanceEntity));
		queryTokenObject.setTypeEntity(getCorrectEntity(typeEntity));
		queryTokenObject.setLabEntity(getCorrectEntity(labEntity));
		queryTokenObject.setFilterWorkflowEntity(EIEntity.NULL_ENTITY);
		queryTokenObject.setFilterLabEntity(updateFilterEntities ? getCorrectEntity(labEntity) : EIEntity.NULL_ENTITY);
		queryTokenObject.setFilterTypeEntity(updateFilterEntities ? getCorrectEntity(typeEntity) : EIEntity.NULL_ENTITY);
		update();
	}

	public void updateApplicationFilterState(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity, boolean strictlyFilteredByOwner) {
		queryTokenObject.setMode(Mode.filter);
		queryTokenObject.setFilterTypeEntity(getCorrectEntity(filterTypeEntity));
		queryTokenObject.setFilterWorkflowEntity(getCorrectEntity(filterWorkflowEntity));
		queryTokenObject.setFilterLabEntity(getCorrectEntity(filterLabEntity));
		queryTokenObject.setStrictFilterByOwner(strictlyFilteredByOwner);
		update();
	}

	public void refresh() {
		History.fireCurrentHistoryState();
	}

	private void update() {
		History.newItem(queryTokenObject.toString(), false);
		notifyListeners();
	}

	public boolean hasUser() {
		return getCorrectEntity(user) != EIEntity.NULL_ENTITY;
	}

	public void addApplicationStateListener(ApplicationStateChangeListener listener) {
		listeners.add(listener);
	}

	public void removeApplicationStateListener(ApplicationStateChangeListener listener) {
		listeners.remove(listener);
	}

	private EIEntity getCorrectEntity(EIEntity entity) {
		return entity == null ? EIEntity.NULL_ENTITY : entity;
	}

	public boolean hasFilters() {
		return getCorrectEntity(getFilterTypeEntity()) != EIEntity.NULL_ENTITY || getCorrectEntity(getFilterWorkflowEntity()) != EIEntity.NULL_ENTITY || getCorrectEntity(getFilterLabEntity()) != EIEntity.NULL_ENTITY;
	}

	public void clearApplicationState() {
		queryTokenObject.fromString("");
	}
}
