package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EquivalentClassesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SaveResultsCallback;
import org.eaglei.datatools.client.ui.widgets.EIResourceWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.ObjectWidget;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.datatools.client.ui.widgets.TypeWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class EditFormsPanel extends EIFormsPanel {

	static enum EditFormType {
		Edit, New, Dialog;
	}

	
	private final List<EIEntity>				dataPropEntityList		= new ArrayList<EIEntity>();
	private final List<EIEntity>				booleanPropEntityList	= new ArrayList<EIEntity>();
	private final List<EIEntity>				objPropEntityList		= new ArrayList<EIEntity>();
	private final Map<EIEntity, List<EIClass>>	objectPropertyRanges		= new HashMap<EIEntity, List<EIClass>>();
	private final EIEntity						labEntity;
	private String								editToken;
	private final EditFormType					formType;
	private final EditFormRedisplay				formRedisplayCallbacks;

	public static EditFormsPanel createEditForm(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel(instance,labUri, displayCallbacks, EditFormType.Edit);
	}

	public static EditFormsPanel createNewForm(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel(instance, labUri, displayCallbacks, EditFormType.New);
	}

	public static EditFormsPanel createDialogForm(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel(instance,labUri, displayCallbacks, EditFormType.Dialog);
	}
	
	private EditFormsPanel(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks, EditFormType formType) {
		super(instance, (FormRedisplay) displayCallbacks);
		shouldShowReadOnlyProperties = true;
		this.formRedisplayCallbacks = displayCallbacks;
		//initializeProperties(); // call finishSetup inside the callback--don't do anything until we have properties
		this.formType = formType;
		setButtonState(); // in order to get new/edit
		this.labEntity = (labUri == null || labUri.toString().equals("")) ? null : EIEntity.create(labUri, ""); // TODO: FIX ME!!
		Log.info("have lab? " + hasLabUri());
		if (!isNewForm())
			getEditToken();
		if (buttonPanel.getSaveButton().isEnabled()) {
			buttonPanel.getSaveButton().addClickHandler(new ClickHandler() {

				@Override
				public void onClick(ClickEvent event) {
					save();
				}
			});
		}
		if (buttonPanel.getCancelButton().isEnabled()) {
			buttonPanel.getCancelButton().addClickHandler(new ClickHandler() {

				@Override
				public void onClick(ClickEvent event) {
					cancel();
				}
			});
		}
	}

	@Override
	protected void finishSetup() {
		buttonPanel.setRootSuperClass(rootSuperClass);
		
		dataPropEntityList.clear();
		objPropEntityList.clear();
		objectPropertyRanges.clear();
		booleanPropEntityList.clear();
		//initializeEquivalentClasses(eiProperties); // TODO: reinstate this & remove below once getting the equivalent classes really works at the server level
		propertyInitializationCallback(eiProperties);
	}

	private void propertyInitializationCallback(List<EIProperty> populatedProperties) {
		for (final EIProperty property : eiProperties) {
			if (property instanceof EIDatatypeProperty) {
				dataPropEntityList.add(property.getEntity());
				if (((EIDatatypeProperty) property).getTypeLabel().equals("boolean")) {
					booleanPropEntityList.add(property.getEntity());
				}
			} else if (property instanceof EIObjectProperty) {
				objPropEntityList.add(property.getEntity());
				//Deal with equivalent classes
				final List<EIClass> assertedRanges = (((EIObjectProperty) property).getRangeList());
				final List<EIClass> inferredRanges = new ArrayList<EIClass>();
				//inferredRanges will contain asserted ranges where no equivalent classes
				//are defined, otherwise equivalent classes
			
				for(final EIClass range : assertedRanges) {
					if(range.hasEquivalentClass()) { //do not add range but its equivalences
						Log.debug("Range has equivalent classes; substituting");
						List<EIEquivalentClass> equivalentClasses = range.getEquivalentClasses();
						for(EIEquivalentClass eqClass : equivalentClasses) {
							Log.debug("adding ranges from equivalent class: " + eqClass);
							inferredRanges.addAll(eqClass.getEquivalentTo());
						}		
					} else {
						inferredRanges.add(range);
					}
				}
				//objectPropertyRanges.put(property.getEntity(), ((EIObjectProperty) property).getRangeList());
				objectPropertyRanges.put(property.getEntity(), inferredRanges);
			}
		}
		super.finishSetup();
	}

	private void initializeEquivalentClasses(final List<EIProperty> properties) {
		//FIXME
		//need call to get all at once or better, have them be set by default
		ClientRepositoryToolsManager.INSTANCE.getEquivalentClasses(properties, new EquivalentClassesCallback() {
			@Override
			public void onSuccess(List<EIProperty> populatedProperties) {
				//Log.debug("Got class with equivalent classes: " + result);
				propertyInitializationCallback(populatedProperties);
			}

			@Override
			public void onFailure(String result) {
				
			}	
		});
	
	}
	
	public boolean isNewForm() {
		return formType == EditFormType.New || formType == EditFormType.Dialog;
	}

	
	@Override
	void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
		if (propertyEntity.equals(DatatoolsUIConstants.propertyName)) {
			formPanel.add(TextWidget.makeLabelTextWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValues.iterator().next()));
		} else if (propertyValues == null || propertyValues.size() == 0) {
			if (booleanPropEntityList.contains(propertyEntity)) {
				formPanel.add(WidgetUtils.createRadioButon(eiInstance, propertyEntity, propertyDefinition, isRequired, null));
			} else {
				formPanel.add(new EditWidgetCollection(eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, null)));
			}
		} else {
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			for (String value : propertyValues) {
				if (booleanPropEntityList.contains(propertyEntity)) {
					fields.addWithoutModifiers(WidgetUtils.createRadioButon(eiInstance, propertyEntity, propertyDefinition, isRequired, value));
				} else {
					fields.addWidget(TextWidget.makeDatatypeTextWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, value));
				}
			}
			fields.setStyleName("required");
			formPanel.add(fields);
		
		}
	}

	@Override
	void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		if (!propertyEntity.getURI().toString().equals(DatatoolsUIConstants.COMMENTS) && !propertyEntity.getURI().toString().equals(DatatoolsUIConstants.CURATOR_NOTE)) {
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			nonOntologyPanel.add(fields);
			for (String value : propertyValues) {
				fields.addWidget(TextWidget.makeNonOntologyTextWidget(eiInstance, propertyEntity, value));
			}
		}
	}

	@Override
	void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
		EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
		nonOntologyPanel.add(fields);
		for (EIEntity value : propertyValues) {
			fields.addWidget(TextWidget.makeNonOntologyTextWidget(eiInstance, propertyEntity, value.getLabel()));
		}
	}

	@Override
	void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
		if (propertyEntity.equals(DatatoolsUIConstants.propertyType)) { // Type does not have a range
			drawTypeProperty();
		} else if (objectPropertyRanges.get(propertyEntity) != null && objectPropertyRanges.get(propertyEntity).size() > 0) {
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			formPanel.add(fields);
			if (objectPropertyRanges.get(propertyEntity).size() == 1) { //Single range
				drawSingleObjectProperty(propertyEntity, propertyDefinition, isRequired, propertyValues, fields);
			} else { // Multiple ranges
				Log.info(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : propertyValues.size()) + "entries");
				if (propertyValues == null || propertyValues.size() == 0) {
					createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, null, fields);
				} else {
					for (EIEntity selectedEntity : propertyValues) {
						createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, selectedEntity, fields);
					}
				}
			}
		}
	}

	private void drawSingleObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues, EditWidgetCollection fields) {
		EIClass range = objectPropertyRanges.get(propertyEntity).iterator().next();
		
		if (hasLabUri() && WidgetUtils.isLabProperty(range)) {
			Log.info("making disabled widget for lab uri '" + labEntity + "' property " + range.getEntity().getLabel());
			eiInstance.addObjectProperty(propertyEntity, labEntity);
			createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, labEntity, fields, true);
		} else if (propertyValues == null || propertyValues.size() == 0) { // new 
			if (WidgetUtils.isLabProperty(range))
				Log.info("drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
			createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, fields, false);
		} else { // existing
			if (WidgetUtils.isLabProperty(range))
				Log.info("drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
			for (EIEntity selectedEntity : propertyValues) {
				createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, false);
			}
		}
	}

	private void drawTypeProperty() {
		final HorizontalPanel temp = new HorizontalPanel();
		formPanel.add(temp);
		if (WidgetUtils.isLabProperty(eiInstance.getInstanceClass())) {
			ClientRepositoryToolsManager.INSTANCE.getLabRootSuperclass(new ClassCallback() {

				@Override
				public void onSuccess(final EIClass superclass) {
					TypeWidget typeWidget = new TypeWidget(eiInstance, null, superclass, eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler() {

						@Override
						public void onTypeChange() {
							Log.info("redrawing; type changed to " + eiInstance.getInstanceClass());
							formPanel.clear();
							formPanel.add(buttonPanel);
							eiClass = eiInstance.getInstanceClass();
							initializeProperties(); // re-gets lists, re-draws form.  Also adds as a session listener *again*
						}
					});
					temp.add(typeWidget);
				}
			});
		} else {
			ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(eiInstance.getInstanceClass(), new ClassCallback() {

				@Override
				public void onSuccess(final EIClass superclass) {
					TypeWidget typeWidget = new TypeWidget(eiInstance, null, superclass, eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler() {

						@Override
						public void onTypeChange() {
							Log.info("redrawing; type changed to " + eiInstance.getInstanceClass());
							formPanel.clear();
							formPanel.add(buttonPanel);
							eiClass = eiInstance.getInstanceClass();
							initializeProperties(); // re-gets lists, re-draws form.  Also adds as a session listener *again*
						}
					});
					temp.add(typeWidget);
				}
			});
		}
	}

	private void createWidgetForMultiRanges(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIEntity selectedEntity, final EditWidgetCollection fields) {
		Log.info("making multi-range widget with " + objectPropertyRanges.get(propertyEntity).size() + " ranges");
		ObjectWidget widget = new ObjectWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, objectPropertyRanges.get(propertyEntity), labEntity, selectedEntity);
		fields.addWidget(widget, widget.isDisabled());
	}

	private void createWidgetForRange(final EIEntity propertyEntity, final String propertyDefinition, boolean isRequired, final EIClass range, EIEntity selectedEntity, final EditWidgetCollection fields, final boolean isLab) {
		if (range.isEagleIResource()) {
			EIResourceWidget resourceWidget = new EIResourceWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, true);
			fields.addWidget(resourceWidget, isLab);
			if (isLab)
				resourceWidget.disable();
		} else {
			WidgetUtils.addTermWidgetToPanel(eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, true);
		}
	}

	@Override
	Collection<EIEntity> getDataTypeEntities() {
		return dataPropEntityList;
	}

	@Override
	Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	Collection<EIEntity> getObjectTypeEntities() {
		return objPropEntityList;
	}

	@Override
	protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		Label commentOnComments = new Label(UIMessages.COMMENT_ON_COMMENTS);
		commentOnComments.setStyleName("commentOnComments");
		formPanel.add(commentOnComments);
		EIEntity comments = EIEntity.create(DatatoolsUIConstants.COMMENTS, DatatoolsUIConstants.COMMENTS_LABEL);
		EIEntity curatorComments = EIEntity.create(DatatoolsUIConstants.CURATOR_NOTE, DatatoolsUIConstants.CURATOR_LABEL);
		String commentValue = nonOntologyLiteralProperties.containsKey(comments) ? nonOntologyLiteralProperties.get(comments).iterator().next() : null;
		TextAreaWidget commentsArea = new TextAreaWidget(eiInstance, comments, "", false, commentValue);
		formPanel.add(commentsArea);
		String curatorValue = nonOntologyLiteralProperties.containsKey(curatorComments) ? nonOntologyLiteralProperties.get(curatorComments).iterator().next() : null;
		TextAreaWidget curatorArea = new TextAreaWidget(eiInstance, curatorComments, "", false, curatorValue);
		formPanel.add(curatorArea);
	}


	
	// TODO: make a static on WidgetUtils
	protected boolean hasLabUri() {
		return (labEntity != null) && (labEntity.getURI() != EIURI.NULL_EIURI) && (!labEntity.getURI().toString().equals(""));
	}

	protected void save() { // TODO: handle stale token correctly
		try {
			if (eiInstance.getInstanceLabel() == null || eiInstance.getInstanceLabel().trim().equals("")) {
				Window.alert(UIMessages.LABEL_REQUIRED);
				return;
			}
			if (isNewForm()) {
				saveNewForm();
			} else {
				ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, editToken, new SaveResultsCallback() {

					@Override
					public void onSuccess(String str) {
						formRedisplayCallbacks.drawAfterSave(eiInstance);
					}

					@Override
					public void loginRequired() {
						Window.alert(UIMessages.PLEASE_LOGIN);
					}

					@Override
					public void onFailure() {
						Window.alert(UIMessages.SAVE_FAILURE);
						formRedisplayCallbacks.drawAfterCancel(eiInstance);
					}
				});
			}
		} catch (Exception e) {
			Log.error("could not (re-) get instance");
		}
	}

	private void saveNewForm() throws Exception {
		ClientRepositoryToolsManager.INSTANCE.createInstance(eiInstance, new EIInstanceCallback() {

			@Override
			public void onSuccess(EIInstance saved) {
				Log.info("drawing " + saved.getInstanceLabel() + " after saving");
				formRedisplayCallbacks.drawAfterSave(saved);
			}

			@Override
			public void loginRequired() {
				Window.alert(UIMessages.PLEASE_LOGIN);
			}
			
			@Override
			public void onFailure() {
				Window.alert(UIMessages.SAVE_FAILURE);
				formRedisplayCallbacks.drawAfterCancel(eiInstance);
			}
		});
	}

	private void cancel() {
		try {
			if (formType == EditFormType.New) {				
				ApplicationState.getInstance().refresh();
			} else if (formType == EditFormType.Dialog) {
				formRedisplayCallbacks.drawAfterCancel(eiInstance);
			} else {
				ClientRepositoryToolsManager.INSTANCE.getInstance(eiInstance.getInstanceURI(), new EIInstanceCallback() {

					@Override
					public void loginRequired() {
					}

					@Override
					public void onSuccess(EIInstance fetched) {
						formRedisplayCallbacks.drawAfterCancel(fetched);
					}
					
					@Override
					public void onFailure() {
						formRedisplayCallbacks.drawAfterCancel(eiInstance);
					}
				});
			}
		} catch (Exception e) {
			Log.error("could not get instance");
		}
	}

	@Override
	void setButtonState() {
		buttonPanel.saveButton.setVisible(true);
		if (formType == EditFormType.New) {
			buttonPanel.copyResourceButton.setVisible(false);
			buttonPanel.cancelButton.setVisible(true);
		
		} else if (formType == EditFormType.Dialog) {
			buttonPanel.copyResourceButton.setVisible(false);
			buttonPanel.cancelButton.setVisible(true);
		} else {
			buttonPanel.copyResourceButton.setVisible(true);
			buttonPanel.cancelButton.setVisible(true);
			buttonPanel.setWorkflowButtonEnable(false);
		}
		buttonPanel.editButton.setVisible(false);
		buttonPanel.claimReleaseButton.setVisible(false);
		buttonPanel.deleteButton.setVisible(false);
	}

	private void getEditToken() {
		try {
			ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, null, new SaveResultsCallback() {

				@Override
				public void loginRequired() {
					Window.alert(UIMessages.PLEASE_LOGIN);
				}

				@Override
				public void onFailure() {
					Log.warn("failed to get edit token for " + eiInstance);
					Window.alert(UIMessages.NO_TOKEN_AVAILABLE);
				}

				@Override
				public void onSuccess(String arg0) {
					editToken = arg0;
				}
			});
		} catch (Exception e) {
			Log.error("failed to get edit token for " + eiInstance + " with exception");
			Window.alert(UIMessages.NO_TOKEN_AVAILABLE);
		}
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.ui.EIFormsPanel#drawReferencedBy()
	 */
	@Override
	void drawReferencedBy() {
		//deliberate no-op
		//Edit form doesn't display referenced by link
	}
	
}
