package org.eaglei.datatools.client.ui;

import static org.eaglei.datatools.client.WorkFlowConstants.WORKFLOW_ENTITY_LIST;
import static org.eaglei.datatools.client.ui.DatatoolsUIConstants.EI_LAB_URI;

import java.util.List;

import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.SharedClassChooser;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;

public class FilterPanel extends Composite {

	interface Binder extends UiBinder<Widget, FilterPanel> {
	}

	//FIXME these names are very confusing
	//e.g. type means topLevelType
	private static final Binder				binder		= GWT.create(Binder.class);
	@UiField
	HorizontalPanel							subTypeFilter;
	@UiField
	Label									subTypeLabel;
	@UiField
	ListBox									statusFilter;
	@UiField
	ListBox									resourceTypeFilter;
	@UiField
	ListBox									labFilter;
	@UiField
	Label									statusLabel;
	@UiField
	Label									labLabel;
	@UiField
	Label									resourceTypeLabel;
	@UiField
	Label									filterLabel;
	@UiField
	Label									totalResources;
	@UiField
	RadioButton								ownedByMe;
	@UiField
	RadioButton								all;
	@UiField
	Button									goButton;
	SharedClassChooser<OntologyDropdown>	classChooser;
	boolean									isTopLevel	= false;

	public FilterPanel() {
	}

	public FilterPanel(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterLabEntity) {
		init(filterTypeEntity, filterWorkflowEntity, filterLabEntity);
		initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterLabEntity, false);
	}

	public FilterPanel(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterLabEntity, final boolean strictFilterByOwner) {
		init(filterTypeEntity, filterWorkflowEntity, filterLabEntity);
		initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterLabEntity, strictFilterByOwner);
	}

	private void init(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterLabEntity) {
		initWidget(binder.createAndBindUi(this));
		filterLabel.setVisible(true);
		if (filterTypeEntity != null && !filterTypeEntity.equals(EIEntity.NULL_ENTITY)) {
			initSubTypeFilter(filterTypeEntity);
		} else {
			//TODO: remove instead of disable?
			isTopLevel = true;
			resourceTypeFilter.addItem(genericOption);
			subTypeFilter.setVisible(false);
			subTypeLabel.setVisible(false);
			disable(resourceTypeFilter);
			
		}
		if(filterTypeEntity.equals(EIEntity.NULL_ENTITY) && filterWorkflowEntity.equals(EIEntity.NULL_ENTITY) && filterLabEntity.equals(EIEntity.NULL_ENTITY))
		{
			ownedByMe.setVisible(false);
			all.setVisible(false);
		}
		
		initWorkflowFilter(filterWorkflowEntity);
		initLabFilter(filterLabEntity);
		initGoButton();
	}
	
	public void disable() {
		disable(resourceTypeFilter);
		disable(labFilter);
		disable(statusFilter);
		disable(goButton);
	}

	private void disable(final FocusWidget filter) {
		filter.setEnabled(false);
		filter.setStyleName("btnDisabled");
	}

	public void setCount(int numberOfResources) {
		totalResources.setText("(" + numberOfResources + ") instances found");
		totalResources.setVisible(true);
	}

	private void initOwnerFilter(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterLabEntity, final boolean strictFilterByOwner) {
		all.setValue(!strictFilterByOwner);
		ownedByMe.setValue(strictFilterByOwner);
		ClickHandler clickHandler = new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationFilterState(filterTypeEntity, filterWorkflowEntity, filterLabEntity, ownedByMe.getValue());
			}
		};
		ownedByMe.addClickHandler(clickHandler);
		all.addClickHandler(clickHandler);
	}

	private void initGoButton() {
		goButton.setVisible(true);
		goButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {
				Log.info("Go button click");
				EIEntity filterTypeEntity;
				if (isTopLevel) {
					filterTypeEntity = EIEntity.NULL_ENTITY;
				} else {
					//TODO revise appstate - does filter type need to be an entity? classchooser
					//only gives us the URI
					Log.info("filter type: " + classChooser.getSelectedEntity());
					filterTypeEntity = classChooser.getSelectedEntity();
					if (filterTypeEntity == null || filterTypeEntity == EIEntity.NULL_ENTITY) {
						filterTypeEntity = ApplicationState.getInstance().hasType() ? ApplicationState.getInstance().getTypeEntity() : EIEntity.NULL_ENTITY;
					}
				}
				final String labLabel = labFilter.getItemText(labFilter.getSelectedIndex());
				EIEntity filterLabEntity;
				if (isGenericOption(labLabel))
					filterLabEntity = EIEntity.NULL_ENTITY;
				else {
					final EIURI labUri = EIURI.create(labFilter.getValue((labFilter.getSelectedIndex())));
					filterLabEntity = EIEntity.create(labUri, labLabel);
				}
				WorkFlowConstants wfc = new WorkFlowConstants();
				final String statusLabel = statusFilter.getItemText(statusFilter.getSelectedIndex());
				EIEntity filterWorkflowEntity = wfc.getStatusEntity(statusLabel);
				Log.info("filter: type=" + filterLabEntity + " lab=" + filterLabEntity + " workflow=" + filterWorkflowEntity);
				ApplicationState.getInstance().updateApplicationFilterState(filterTypeEntity, filterWorkflowEntity, filterLabEntity, ownedByMe.getValue());
			}
		});
	}

	private final String	genericOption	= "All";

	private void initWorkflowFilter(EIEntity filterWorkflowEntity) {
		statusFilter.setVisible(true);
		statusLabel.setVisible(true);
		statusFilter.addItem(genericOption);
		for (EIEntity entity : WORKFLOW_ENTITY_LIST) {
			statusFilter.addItem(entity.getLabel(), entity.getURI().toString());
			if (entity.equals(filterWorkflowEntity))
				statusFilter.setSelectedIndex(statusFilter.getItemCount() - 1);
		}
	}

	//TODO set selected
	private void initTopLevelTypeFilter() {
		isTopLevel = true;
		//TODO get selected value as parameter
		resourceTypeFilter.setVisible(true);
		resourceTypeLabel.setVisible(true);
		resourceTypeFilter.addItem(genericOption);
		//FIXME resource types should not be in LeftListPanel
		//FIXME we should add a LabResourceTypes list
		for (EIClass eiclass : LeftListPanel.resourceTypes) {
			resourceTypeFilter.addItem(eiclass.getEntity().getLabel(), eiclass.getEntity().getURI().toString());
		}
	}

	private void initLabFilter(final EIEntity filterLabEntity) {
		Log.info("Got lab entity: " + filterLabEntity);
		labFilter.setVisible(true);
		labLabel.setVisible(true);
		if (ApplicationState.getInstance().getTypeEntity().equals(DatatoolsUIConstants.EI_LAB_ENTITY)) {
			labFilter.addItem(genericOption);
			disable(labFilter);
			return;
		}
		if (!EIEntity.NULL_ENTITY.equals(filterLabEntity))
			labFilter.addItem(filterLabEntity.getLabel(), filterLabEntity.getURI().toString());
		else
			labFilter.addItem(genericOption);
		if (!EIEntity.NULL_ENTITY.equals(ApplicationState.getInstance().getLabEntity())) {
			disable(labFilter);
		} else {
			// Populate the list only when clicked
			labFilter.addClickHandler(new ClickHandler() {

				@Override
				public void onClick(ClickEvent arg0) {
					if (labFilter.getItemCount() == 1) { // Populate the list only
						// if it is not already
						// populated
						labFilter.removeItem(labFilter.getItemCount() - 1);
						labFilter.addItem("List is loading....");
						try {
							ClientRepositoryToolsManager.INSTANCE.getFilterQuery(ApplicationState.getInstance().getUserURI(), EI_LAB_URI, EIURI.NULL_EIURI, EIURI.NULL_EIURI, new EIInstancesCallback() {

								@Override
								public void onSuccess(final List<EIInstanceMinimal> eiInstanceList) {
									labFilter.removeItem(labFilter.getItemCount() - 1);
									labFilter.addItem(genericOption);
									//FIXME remove when we manage to pick up repo fix in queries
									//Collections.sort(eiInstanceList);
									for (EIInstanceMinimal instance : eiInstanceList) {
										labFilter.addItem(instance.getInstanceLabel(), instance.getInstanceURI().toString());
										Log.info("instance entity: " + instance.getEntity());
										if (instance.getEntity().equals(filterLabEntity))
											labFilter.setSelectedIndex(labFilter.getItemCount() - 1);
									}
								}

								@Override
								public void loginRequired() {
								}
							});
						} catch (Exception e) {
							Log.error(e.getMessage());
						}
					}
				}
			});
		}
	}

	private void initSubTypeFilter(final EIEntity filterTypeEntity) {
		Log.info("got selected entity: " + filterTypeEntity);
		resourceTypeFilter.setVisible(false);
		resourceTypeLabel.setVisible(false);
		this.classChooser = new SharedClassChooser<OntologyDropdown>(new OntologyDropdown());
		classChooser.setTextBoxStyle("formText");
		this.subTypeFilter.add(classChooser);
		subTypeLabel.setVisible(false);
		subTypeFilter.setVisible(true);
		//TODO think of storing the EIClass in AppState so we don't keep re-fetching it
		ClientModelManager.INSTANCE.getClass(ApplicationState.getInstance().getTypeUri(), new ClassCallback() {

			@Override
			public void onSuccess(EIClass result) {
				Log.info("got class for " + filterTypeEntity + " class is " + result);
				classChooser.setClass(result, false);
				classChooser.setSelectedEntity(filterTypeEntity);
			}
		});
	}

	private boolean isGenericOption(String label) {
		return genericOption.equals(label);
	}
}
