package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.OntologyDropdown;
import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;

import com.google.gwt.user.client.Window;

public class TypeWidget extends TermWidget {

	private TypeChangeHandler typeChangeHandler;
	private EIClass originalSuperclass;
	
	public interface TypeChangeHandler {
		public void onTypeChange();
	}
	
	public TypeWidget(EIInstance eiInstance, EIEntity propertyEntity, EIClass range, EIClass selectedClass, TypeChangeHandler typeChangeHandler) {
		super(eiInstance, propertyEntity, "", true, range, selectedClass, true);
		this.typeChangeHandler = typeChangeHandler;
		this.originalSuperclass = range;
		setShouldShowLabel(true);
	}
	
	@Override
	protected void makeSelectionHandler(SharedClassChooser<OntologyDropdown> classChooser) {
		classChooser.addSelectionListener(new EntitySelectionListener() {
			@Override
			public void onSelection(final EIEntity selectedEntity) {
				//EIEntity entityToLoad = selectedEntity;
				if (selectedEntity.equals(EIEntity.NULL_ENTITY)) {
					eiInstance.setInstanceType(originalSuperclass.getEntity());
					//entityToLoad = originalSuperclass.getEntity();
					eiInstance.setInstanceClass(originalSuperclass);
					typeChangeHandler.onTypeChange();
				} else {
					//eiInstance.setInstanceType(selectedEntity);
					//}
					//TODO I think class chooser could be modified to return an EIClass
					ClientModelManager.INSTANCE.getClass(selectedEntity.getURI(), new ClassCallback() {
					
						@Override
						public void onSuccess(EIClass result) {
							if(result.isInferred()) {
								eiInstance.setInstanceType(originalSuperclass.getEntity());
								//entityToLoad = originalSuperclass.getEntity();
								eiInstance.setInstanceClass(originalSuperclass);
								Window.alert(UIMessages.NO_INSTANCES_FOR_INFERRED);
								typeChangeHandler.onTypeChange();
							} else {
								eiInstance.setInstanceType(result.getEntity());
								eiInstance.setInstanceClass(result);
								typeChangeHandler.onTypeChange();
							}
						}
					});
					
				}
			}
		});
	}
	
	//Type is required
	//TODO pull out into widgetUtils
	@Override
	protected String getLabel() {
		String labelPrefix;
		 if(WidgetUtils.isLabProperty(eiInstance.getInstanceType())) {
			 labelPrefix = DatatoolsUIConstants.EI_LAB_Label;
		 } else {
			 labelPrefix = originalSuperclass.getEntity().getLabel();
		 }

		return WidgetUtils.getExtendedPropertyLabel(labelPrefix, DatatoolsUIConstants.propertyType.getLabel());
	}

	@Override
	protected void removeValue() {
		// Deliberate no-op; should we show an alert?
	}
	
	@Override
	public EditWidget duplicateBlank() {
		return null;
		// Deliberate no-op; should we show an alert?
	}
}
