/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.LabelValuesWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public abstract class EIFormsPanel
extends Composite {
    private VerticalPanel outerFormPanel = new VerticalPanel();
    protected VerticalPanel formPanel = new VerticalPanel();
    protected EIInstance eiInstance;
    protected EIClass eiClass;
    protected EIClass rootSuperClass;
    protected List<EIProperty> eiProperties;
    protected boolean shouldShowReadOnlyProperties;
    protected ButtonsPanel buttonPanel;
    protected FormRedisplay redisplayCallbacks;

    abstract void drawDataProperty(EIEntity var1, String var2, boolean var3, Set<String> var4);

    abstract void drawObjectProperty(EIEntity var1, String var2, boolean var3, Set<EIEntity> var4);

    abstract void drawNonOntologyLiteralProperty(EIEntity var1, Set<String> var2, Map<EIEntity, String> var3, VerticalPanel var4);

    abstract void drawNonOntologyResourceProperty(EIEntity var1, Set<EIEntity> var2, Map<EIEntity, String> var3, VerticalPanel var4);

    abstract void drawReferencedBy();

    protected abstract void drawExtraFields(Map<EIEntity, Set<String>> var1);

    abstract Collection<EIEntity> getDataTypeEntities();

    abstract Collection<EIEntity> getObjectTypeEntities();

    abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

    abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

    abstract void setButtonState();

    public EIFormsPanel(EIInstance instance, FormRedisplay redisplay) {
        this.initWidget((Widget)this.outerFormPanel);
        this.outerFormPanel.setStyleName("formPanel");
        this.formPanel.setStyleName("formPanel");
        this.eiInstance = instance;
        this.eiClass = instance.getInstanceClass();
        this.initializeProperties();
        this.buttonPanel = new ButtonsPanel(this.eiInstance, redisplay);
        this.outerFormPanel.add((Widget)this.buttonPanel);
        this.outerFormPanel.add((Widget)this.formPanel);
        this.setButtonState();
        this.redisplayCallbacks = redisplay;
        this.buttonPanel.copyResourceButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void finishSetup() {
        Log.debug((String)"Finishing form setup");
        this.constructForm();
        this.formPanel.setStyleName("formPanel");
        this.formPanel.setHeight("50");
    }

    public EIInstance getInstance() {
        return this.eiInstance;
    }

    protected void constructForm() {
        Log.debug((String)"Constructing form");
        Map instanceDataTypeProperties = this.eiInstance.getDatatypeProperties();
        Map instanceObjectProperties = this.eiInstance.getObjectProperties();
        Map instanceNonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        Map instanceNonOntologyResourceProperties = this.eiInstance.getNonOntologyResourceProperties();
        String labelPrefix = WidgetUtils.isLabProperty((EIClass)this.eiClass) ? "Laboratory" : this.rootSuperClass.getEntity().getLabel();
        EIEntity namePropEntity = EIEntity.create((EIURI)DatatoolsUIConstants.propertyName.getURI(), (String)WidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)DatatoolsUIConstants.propertyName.getLabel()));
        this.drawDataProperty(namePropEntity, "", true, (Set)this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
        EIEntity typePropEntity = EIEntity.create((EIURI)DatatoolsUIConstants.propertyType.getURI(), (String)WidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)DatatoolsUIConstants.propertyType.getLabel()));
        this.drawObjectProperty(typePropEntity, "", true, (Set)this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
        Collection dataProps = this.getDataTypeEntities();
        Collection objectProps = this.getObjectTypeEntities();
        for (EIProperty property : this.eiProperties) {
            if (property instanceof EIDatatypeProperty && dataProps.contains(property.getEntity())) {
                this.drawDataProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (!(property instanceof EIObjectProperty) || !objectProps.contains(property.getEntity())) continue;
            this.drawObjectProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceObjectProperties.get(property.getEntity()));
        }
        this.drawExtraFields(instanceNonOntologyLiteralProperties);
        this.drawReferencedBy();
        DisclosurePanel nonOntologyPanel = new DisclosurePanel("Information for data curators");
        Map nonOntLiteralList = this.eiInstance.getNonOntologyLiteralProperties();
        Map nonOntResourceList = this.eiInstance.getNonOntologyResourceProperties();
        ArrayList entityList = new ArrayList();
        entityList.addAll(this.eiInstance.getReadOnlyLiteralProperties().keySet());
        entityList.addAll(this.eiInstance.getReadOnlyResourceProperties().keySet());
        entityList.addAll(nonOntResourceList.keySet());
        entityList.addAll(nonOntLiteralList.keySet());
        VerticalPanel innerPanel = new VerticalPanel();
        ClientRepositoryToolsManager.INSTANCE.retrieveLabels(entityList, (ClientRepositoryToolsManager.LabelsCallback)new /* Unavailable Anonymous Inner Class!! */);
        nonOntologyPanel.add((Widget)innerPanel);
        this.formPanel.add((Widget)nonOntologyPanel);
    }

    private HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    private HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    private HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
        return new HashSet<EIEntity>(Arrays.asList(value));
    }

    protected void createNonOntologyPanel(Map<EIEntity, Set<String>> nonOntologyLiteralProperties, Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties, Map<EIEntity, String> labelMap, VerticalPanel innerPanel) {
        VerticalPanel metaPanel = new VerticalPanel();
        VerticalPanel otherPanel = new VerticalPanel();
        this.designPanel(metaPanel, "Metadata properties:");
        this.designPanel(otherPanel, "Other properties:");
        LabelValuesWidget eagleIUniqueId = new LabelValuesWidget("eagle-i unique ID");
        Anchor id = new Anchor(this.eiInstance.getInstanceURI().toString(), this.eiInstance.getInstanceURI().toString(), "_blank");
        eagleIUniqueId.add((Widget)id);
        innerPanel.add((Widget)eagleIUniqueId);
        if (this.shouldShowReadOnlyProperties) {
            innerPanel.add((Widget)metaPanel);
            innerPanel.add((Widget)otherPanel);
            Map readOnlyLiterals = this.eiInstance.getReadOnlyLiteralProperties();
            Map readOnlyResources = this.eiInstance.getReadOnlyResourceProperties();
            this.drawReadOnlyProperties(labelMap, metaPanel, readOnlyLiterals, readOnlyResources);
        }
        VerticalPanel panelToUse = this.shouldShowReadOnlyProperties ? otherPanel : innerPanel;
        for (EIEntity propEntity : nonOntologyLiteralProperties.keySet()) {
            this.drawNonOntologyLiteralProperty(propEntity, nonOntologyLiteralProperties.get(propEntity), labelMap, panelToUse);
        }
        for (EIEntity propEntity : nonOntologyResourceProperties.keySet()) {
            this.drawNonOntologyResourceProperty(propEntity, nonOntologyResourceProperties.get(propEntity), labelMap, panelToUse);
        }
    }

    private void drawReadOnlyProperties(Map<EIEntity, String> labelMap, VerticalPanel metaPanel, Map<EIEntity, String> readOnlyLiterals, Map<EIEntity, EIEntity> readOnlyResources) {
        for (EIEntity propEntity : readOnlyLiterals.keySet()) {
            this.drawReadOnlyLiteralProperty(propEntity, (Set)this.makeSetFromSingle(readOnlyLiterals.get(propEntity)), labelMap, metaPanel);
        }
        for (EIEntity propEntity : readOnlyResources.keySet()) {
            this.drawReadOnlyResourceProperty(propEntity, (Set)this.makeSetFromSingleEntity(readOnlyResources.get(propEntity)), labelMap, metaPanel);
        }
    }

    private void designPanel(VerticalPanel panel, String header) {
        panel.setStyleName("formPanel");
        Label propHeader = new Label(header);
        propHeader.setStyleName("nonOntologyPropertyLabel");
        panel.add((Widget)propHeader);
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        Anchor resourceURL = null;
        Label valueField = new Label();
        valueField.setStyleName("formLabelValue");
        if (value.startsWith("www") || value.startsWith("http")) {
            resourceURL = new Anchor(WidgetUtils.formatText((String)value), WidgetUtils.formatText((String)value), "_blank");
        } else {
            valueField.setText(WidgetUtils.formatText((String)value));
        }
        return resourceURL == null ? valueField : resourceURL;
    }

    protected void drawReadOnlyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void drawReadOnlyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (EIEntity propEntity : propertyValues) {
            if (propEntity == null || propEntity == EIEntity.NULL_ENTITY) continue;
            widget.add(this.handleReadOnlyTextProperty(propEntity.getLabel()));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void initializeProperties() {
        ClientModelManager.INSTANCE.getProperties(this.eiClass, (ClientModelManager.PropertyCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void getRootSuperClass() {
        ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(this.eiClass, (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

