/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.datatools.client.ui.WorkFlowAction;
import org.eaglei.datatools.client.ui.WorkflowUtils;
import org.eaglei.datatools.client.ui.listeners.RowDeletionListener;
import org.eaglei.datatools.client.ui.widgets.EIConfirmationPopup;
import org.eaglei.datatools.client.ui.widgets.GridRowWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

public class EIResourcesGrid
extends Composite
implements RowDeletionListener {
    private static final String[] RESOURCE_COLUMN_NAMES = new String[]{"Resource Name", "Type", "Date Added", "Status"};
    public static final int[] widths = new int[]{198, 113, 97, 97, 50, 50, 50, 50};
    private static final Map<String, Comparator<EIInstanceMinimal>> resourceSorters = new HashMap();
    public static final String DATATOOLS_FILTER = "DatatoolsFilter";
    private List<EIInstanceMinimal> instances = new ArrayList();
    private Map<EIInstanceMinimal, GridRowWidget> instanceRowMap = new HashMap();
    FilterPanel filterPanel;
    VerticalPanel resources;
    VerticalPanel innerPanel = new VerticalPanel();
    private final FlowPanel headerPanel = new FlowPanel();

    public EIResourcesGrid() {
        this.initialize();
        this.drawFromApplicationState();
    }

    public EIResourcesGrid(List<EIInstanceMinimal> instances) {
        this();
        Log.info((String)("Creating grid with " + instances.size() + " instances"));
        this.resources.remove((Widget)this.headerPanel);
        this.instances = instances;
        this.drawFromApplicationState();
    }

    private void initialize() {
        this.initWidget((Widget)this.innerPanel);
        if (resourceSorters.size() == 0) {
            this.initializeSorters();
        }
        this.filterPanel = new FilterPanel(ApplicationState.getInstance().hasFilterTypeEntity() ? ApplicationState.getInstance().getFilterTypeEntity() : ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getFilterWorkflowEntity(), ApplicationState.getInstance().getFilterLabEntity(), ApplicationState.getInstance().isStrictlyFilteredByOwner());
        this.resources = new VerticalPanel();
        this.resources.getElement().setClassName("listGrid");
        Label pageHeader = this.getHeaderLabel();
        this.innerPanel.add((Widget)this.filterPanel);
        this.innerPanel.add((Widget)pageHeader);
        this.innerPanel.add((Widget)this.resources);
        this.headerPanel.setStyleName("resourcesHeaderPanel");
        Label emptyHeader = new Label(this.getEmptyListMessage());
        this.headerPanel.add((Widget)emptyHeader);
        this.resources.add((Widget)this.headerPanel);
    }

    private String getEmptyListMessage() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            return "No resources refer to " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        }
        return "To see a list of resources that you can view or edit, click the resource type, such as Instrument, or filter by Status or Laboratory above.";
    }

    private void drawFromApplicationState() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            return;
        }
        if (ApplicationState.getInstance().getMode() != QueryTokenObject.Mode.list && ApplicationState.getInstance().getMode() != QueryTokenObject.Mode.labs && ApplicationState.getInstance().getMode() != QueryTokenObject.Mode.filter && ApplicationState.getInstance().getMode() != QueryTokenObject.Mode.references) {
            this.resources.clear();
            return;
        }
        this.filterPanel.setCount(this.instances.size());
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            this.filterPanel.disable();
        }
        if (this.instances.size() == 0) {
            this.resources.remove((Widget)this.headerPanel);
            this.resources.clear();
            Label noInstances = new Label(this.getNoResourcesMessage());
            this.resources.add((Widget)noInstances);
            return;
        }
        this.resources.clear();
        this.setGridHeaders();
        this.updateGrid(0, this.instances);
    }

    private String getNoResourcesMessage() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            return "No resources refer to " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        }
        return "No resources found";
    }

    private void setGridHeaders() {
        HorizontalPanel header = new HorizontalPanel();
        for (int i = 0; i < RESOURCE_COLUMN_NAMES.length; ++i) {
            String columnName = RESOURCE_COLUMN_NAMES[i];
            Anchor label = new Anchor(columnName);
            String width = Integer.toString(widths[i] - 1) + "px";
            header.add((Widget)label);
            header.setCellWidth((Widget)label, width);
            label.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!ApplicationState.getInstance().hasLabType()) {
            ListBox actionList = this.makeListBoxOfActions();
            header.add((Widget)actionList);
            header.setCellWidth((Widget)actionList, Integer.toString(widths[4] + widths[5] + widths[6] - 33) + "px");
            CheckBox selectAllCheckBox = this.makeCheckBoxToSelectAll();
            header.add((Widget)selectAllCheckBox);
            header.setCellWidth((Widget)selectAllCheckBox, Integer.toString(widths[7] - 1) + "px");
        } else {
            Label placeholder = new Label("");
            header.add((Widget)placeholder);
            header.setCellWidth((Widget)placeholder, Integer.toString(widths[4] + widths[5] + widths[6] - 33) + "px");
        }
        this.resources.add((Widget)header);
        header.setStyleName("dtListGridHeader");
    }

    private CheckBox makeCheckBoxToSelectAll() {
        CheckBox chkBox = new CheckBox("");
        chkBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return chkBox;
    }

    private void removeRow(EIInstanceMinimal toRemove) {
        if (this.instanceRowMap.containsKey(toRemove)) {
            this.resources.remove((Widget)this.instanceRowMap.get(toRemove));
            this.instanceRowMap.remove(toRemove);
            this.instances.remove(toRemove);
        }
        this.filterPanel.setCount(this.instances.size());
    }

    private void sortGrid(List<EIInstanceMinimal> eiInstanceList, Comparator<EIInstanceMinimal> sorter) {
        Collections.sort(this.instances, sorter);
        for (EIInstanceMinimal instance : eiInstanceList) {
            this.resources.remove((Widget)this.instanceRowMap.get(instance));
            this.resources.add((Widget)this.instanceRowMap.get(instance));
        }
    }

    private void updateGrid(int initialRowNumber, List<EIInstanceMinimal> eiInstanceList) {
        int i = initialRowNumber;
        for (EIInstanceMinimal instance : eiInstanceList) {
            GridRowWidget gridRowWidget = new GridRowWidget(instance, (RowDeletionListener)this);
            this.instanceRowMap.put(instance, gridRowWidget);
            this.resources.add((Widget)gridRowWidget);
            ++i;
        }
    }

    private Label getHeaderLabel() {
        String labelContent = "";
        if (ApplicationState.getInstance().hasType()) {
            labelContent = ApplicationState.getInstance().getTypeEntity().getLabel();
        } else if (ApplicationState.getInstance().getFilterTypeEntity() != EIEntity.NULL_ENTITY) {
            labelContent = ApplicationState.getInstance().getFilterTypeEntity().getLabel();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            labelContent = "Resources that reference " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        }
        Label headerLabel = new Label(labelContent);
        headerLabel.setStyleName("pageHeader");
        return headerLabel;
    }

    private void initializeSorters() {
        resourceSorters.put(RESOURCE_COLUMN_NAMES[0], new /* Unavailable Anonymous Inner Class!! */);
        resourceSorters.put(RESOURCE_COLUMN_NAMES[1], new /* Unavailable Anonymous Inner Class!! */);
        resourceSorters.put(RESOURCE_COLUMN_NAMES[2], new /* Unavailable Anonymous Inner Class!! */);
        resourceSorters.put(RESOURCE_COLUMN_NAMES[3], new /* Unavailable Anonymous Inner Class!! */);
    }

    private ListBox makeListBoxOfActions() {
        ListBox actionList = new ListBox();
        actionList.addItem("Actions");
        if (WorkflowUtils.canUserChangeState((EIURI)WorkFlowAction.CurationAction.getFromState())) {
            actionList.addItem(WorkFlowAction.CurationAction.getName());
        }
        if (WorkflowUtils.canUserChangeState((EIURI)WorkFlowAction.ReturnToDraftAction.getFromState())) {
            actionList.addItem(WorkFlowAction.ReturnToDraftAction.getName());
        }
        if (WorkflowUtils.canUserChangeState((EIURI)WorkFlowAction.PublishAction.getFromState())) {
            actionList.addItem(WorkFlowAction.PublishAction.getName());
        }
        if (WorkflowUtils.canUserChangeState((EIURI)WorkFlowAction.WithdrawAction.getFromState())) {
            actionList.addItem(WorkFlowAction.WithdrawAction.getName());
        }
        actionList.addItem("Claim");
        actionList.addItem("Share");
        actionList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionList;
    }

    private boolean isPublishedOrWithdrawn(EIInstanceMinimal instance) {
        return WorkFlowConstants.PUBLISH_ENTITY.equals((Object)instance.getWFState()) || WorkFlowConstants.WITHDRAW_ENTITY.equals((Object)instance.getWFState());
    }

    protected boolean instanceMeetsFilterCriteria(EIInstanceMinimal eiInstance) {
        if (ApplicationState.getInstance().isStrictlyFilteredByOwner()) {
            return WorkflowUtils.isNotNull((EIEntity)eiInstance.getWFOwner());
        }
        return true;
    }

    protected void bulkClaimOrRelease(ActionRedisplay redisplay, OwnershipAction ClaimOrReleaseaction, String seletecChoice) {
        ArrayList instanceList = new ArrayList();
        VerticalPanel vpanel = this.makeVerticalpanelWithHeading("The following resources will be " + seletecChoice + "ed");
        WorkFlowConstants wfc = new WorkFlowConstants();
        ScrollPanel scrPanel = this.getScrollPanelWithDimensionsSet();
        FlexTable flexTable = this.getFlextableWithHeadingSet();
        int i = 0;
        for (EIInstanceMinimal eiInstance : this.instances) {
            EIEntity status = eiInstance.getWFState();
            GridRowWidget row = (GridRowWidget)this.instanceRowMap.get(eiInstance);
            if (row.getCheckBox() == null || !row.getCheckBox().isVisible() || !row.getCheckBox().getValue().booleanValue()) continue;
            if (seletecChoice.equals("Claim") && WorkflowUtils.canUserChangeState((EIURI)eiInstance.getWFState().getURI()) && !this.isPublishedOrWithdrawn(eiInstance) && !row.instanceHasOwner()) {
                i = this.addRowToTableAndInstanceList(instanceList, wfc, flexTable, i, eiInstance, status);
                continue;
            }
            if (!seletecChoice.equals("Share") || !row.instanceHasOwner()) continue;
            i = this.addRowToTableAndInstanceList(instanceList, wfc, flexTable, i, eiInstance, status);
        }
        if (i == 0) {
            Window.alert((String)OwnershipAction.getErrorMsgOfOwnershipAction((String)seletecChoice));
            return;
        }
        if (instanceList.size() > 0) {
            EIConfirmationPopup popup = new EIConfirmationPopup("100%", "100%");
            popup.addConfirmClickHandler(this.makeHandlerforBulkClaimOrRelease(redisplay, ClaimOrReleaseaction, instanceList, (PopupPanel)popup));
            vpanel.add((Widget)scrPanel);
            scrPanel.add((Widget)flexTable);
            popup.add((Widget)vpanel);
            popup.show();
        }
    }

    private int addRowToTableAndInstanceList(ArrayList<EIInstanceMinimal> instanceList, WorkFlowConstants wfc, FlexTable flexTable, int i, EIInstanceMinimal eiInstance, EIEntity status) {
        instanceList.add(eiInstance);
        flexTable.setText(i + 2, 0, eiInstance.getInstanceLabel());
        flexTable.setText(i + 2, 1, eiInstance.getInstanceType().getLabel());
        flexTable.setText(i + 2, 2, status.getLabel());
        return ++i;
    }

    public void bulkOperation(WorkFlowAction action) {
        try {
            ArrayList<EIInstanceMinimal> instancesToChange = new ArrayList<EIInstanceMinimal>();
            WorkFlowConstants wfc = new WorkFlowConstants();
            VerticalPanel vpanel = this.makeVerticalpanelWithHeading("The following resources will be set to " + wfc.getStatusLabel(action.getToState()) + ":");
            ScrollPanel scrPanel = this.getScrollPanelWithDimensionsSet();
            FlexTable flexTable = this.getFlextableWithHeadingSet();
            boolean somethingSelected = false;
            boolean actionValidForAllItems = true;
            int unclaimedResourcesCount = 0;
            int loopCount = 0;
            int i = 0;
            for (EIInstanceMinimal eiInstance : this.instances) {
                GridRowWidget row = (GridRowWidget)this.instanceRowMap.get(eiInstance);
                EIEntity status = eiInstance.getWFState();
                if (row.getCheckBox() == null || !row.getCheckBox().isVisible() || !row.getCheckBox().getValue().booleanValue()) continue;
                if (!WorkflowUtils.instanceHasAnyOwner((EIInstanceMinimal)eiInstance)) {
                    ++unclaimedResourcesCount;
                }
                if (action.getFromState().equals((Object)status.getURI()) && WorkflowUtils.instanceHasAnyOwner((EIInstanceMinimal)eiInstance)) {
                    instancesToChange.add(eiInstance);
                    flexTable.setText(i + 2, 0, eiInstance.getInstanceLabel());
                    flexTable.setText(i + 2, 1, eiInstance.getInstanceType().getLabel());
                    flexTable.setText(i + 2, 2, status.getLabel());
                    ++i;
                    somethingSelected = true;
                } else {
                    actionValidForAllItems = false;
                }
                ++loopCount;
            }
            if (unclaimedResourcesCount == loopCount) {
                Window.alert((String)WorkFlowAction.getAlertMessageForUnclaimed((WorkFlowAction)action));
                return;
            }
            if (!actionValidForAllItems && !somethingSelected) {
                Window.alert((String)WorkFlowAction.getAlertMessage((WorkFlowAction)action));
                return;
            }
            if (!somethingSelected && actionValidForAllItems) {
                Window.alert((String)"Select resources and choose an action.");
                return;
            }
            EIConfirmationPopup popup = new EIConfirmationPopup("100%", "100%");
            popup.addConfirmClickHandler(this.makeHandlerForBulkWorkflow(action, instancesToChange, (PopupPanel)popup));
            scrPanel.add((Widget)flexTable);
            vpanel.add((Widget)scrPanel);
            popup.add((Widget)vpanel);
            popup.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private VerticalPanel makeVerticalpanelWithHeading(String headingString) {
        VerticalPanel vpanel = new VerticalPanel();
        Label heading = new Label(headingString);
        heading.setStyleName("dataPanelLabel");
        vpanel.add((Widget)heading);
        return vpanel;
    }

    private ClickHandler makeHandlerforBulkClaimOrRelease(ActionRedisplay redisplay, OwnershipAction ClaimOrReleaseaction, List<EIInstanceMinimal> instanceList, PopupPanel popup) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ClickHandler makeHandlerForBulkWorkflow(WorkFlowAction action, List<EIInstanceMinimal> instancesToChange, PopupPanel popup) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FlexTable getFlextableWithHeadingSet() {
        FlexTable flexTable = new FlexTable();
        flexTable.setStyleName("dataPanel");
        flexTable.setHTML(1, 0, "<b>Resource Name</b>");
        flexTable.setHTML(1, 1, "<b>Type</b>");
        flexTable.setHTML(1, 2, "<b>Status</b>");
        return flexTable;
    }

    private ScrollPanel getScrollPanelWithDimensionsSet() {
        ScrollPanel scrPanel = new ScrollPanel();
        scrPanel.setHeight("270px");
        scrPanel.setWidth("1000px");
        scrPanel.setHorizontalScrollPosition(-1);
        return scrPanel;
    }

    public void onRowDeletion(EIInstanceMinimal instance) {
        this.removeRow(instance);
    }

    static /* synthetic */ List access$000(EIResourcesGrid x0) {
        return x0.instances;
    }

    static /* synthetic */ Map access$100() {
        return resourceSorters;
    }

    static /* synthetic */ void access$200(EIResourcesGrid x0, List x1, Comparator x2) {
        x0.sortGrid(x1, x2);
    }

    static /* synthetic */ Map access$300(EIResourcesGrid x0) {
        return x0.instanceRowMap;
    }

    static /* synthetic */ void access$400(EIResourcesGrid x0, EIInstanceMinimal x1) {
        x0.removeRow(x1);
    }
}

