/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ui.EIFormsPanel;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.ViewFormRedisplay;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.LabelValuesWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

public class ViewFormsPanel
extends EIFormsPanel {
    private ViewFormRedisplay viewRedisplay;

    public ViewFormsPanel(EIInstance instance, ViewFormRedisplay redisplay) {
        super(instance, (FormRedisplay)redisplay);
        this.viewRedisplay = redisplay;
        this.shouldShowReadOnlyProperties = true;
    }

    void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.formPanel.add((Widget)widget);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
    }

    void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        boolean hadValue = false;
        for (EIEntity propEntity : propertyValues) {
            if (propEntity == null || propEntity == EIEntity.NULL_ENTITY || propEntity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) continue;
            widget.add(this.handleReadOnlyTextProperty(propEntity.getLabel()));
            hadValue = true;
        }
        if (hadValue) {
            nonOntologyPanel.add((Widget)widget);
        }
    }

    void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.formPanel.add((Widget)widget);
        boolean hadValue = false;
        for (EIEntity entity : propertyValues) {
            if (entity == null || entity == EIEntity.NULL_ENTITY || entity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) {
                Log.info((String)"no value entity");
                continue;
            }
            hadValue = true;
            Anchor a = new Anchor(WidgetUtils.formatText((String)entity.getLabel()));
            widget.add((Widget)a);
            a.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!hadValue) {
            this.formPanel.remove((Widget)widget);
        }
    }

    void drawReferencedBy() {
        Anchor referencedBy = new Anchor("Referenced by...");
        referencedBy.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel referencePanel = new HorizontalPanel();
        referencePanel.add((Widget)referencedBy);
        referencedBy.setStyleName("referencedBy");
        this.formPanel.add((Widget)referencePanel);
    }

    Collection<EIEntity> getDataTypeEntities() {
        return this.eiInstance.getDatatypeProperties().keySet();
    }

    Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        return this.eiInstance.getNonOntologyLiteralProperties().keySet();
    }

    Collection<EIEntity> getNonOntologyResourcePropEntities() {
        return this.eiInstance.getNonOntologyResourceProperties().keySet();
    }

    Collection<EIEntity> getObjectTypeEntities() {
        return this.eiInstance.getObjectProperties().keySet();
    }

    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
    }

    void setButtonState() {
        this.buttonPanel.saveButton.setVisible(false);
        this.buttonPanel.copyResourceButton.setVisible(true);
        this.buttonPanel.cancelButton.setVisible(false);
        this.buttonPanel.editButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }
}

