package org.eaglei.datatools.client;

import org.eaglei.datatools.User;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.UserCallback;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.EagleiGlassPane;
import org.eaglei.datatools.client.ui.LabCache;
import org.eaglei.datatools.client.ui.LeftListPanel;
import org.eaglei.datatools.client.ui.MainController;
import org.eaglei.datatools.client.ui.TopPanel;
import org.eaglei.datatools.client.ui.Workbench;
import org.eaglei.datatools.client.ui.widgets.BreadcrumbWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.FooterPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * This is the Entry point class, mainly responsible for creating the Top level Tabs
 * 
 * @author pp101
 * 
 */
public class Datatools implements ClientRepositoryToolsManager.SessionListener {

	private static String currentUser;
	private static User userObject;
	private HorizontalPanel mainPanel;
	public static boolean isRefresh;
	private TopPanel topPanel = null;
	private boolean initialized = false;
	private LeftListPanel leftList;
	private MainController mainController;
	private static final VerticalPanel dataPanel = new VerticalPanel();
	private static Workbench workbench = null; // TODO: UGH!
	protected static final EagleiGlassPane glasspane = new EagleiGlassPane();
	private LabCache labCache = null;
	private BreadcrumbWidget breadcrumbs;

	private static GWTLogger log = GWTLogger.getLogger( "Datatools" );

	/**
	 * Entry point method
	 */
	public void onModuleLoad() {
		initialized = false;
		log.info( "making new main controller" );
		if ( !Window.Location.getHash().equals( "" ) ) {
			isRefresh = true;
			// need to do this here because otherwise the MainController will make a new one willy-nilly, and may not stay subscribed
		//	ApplicationState.newInstance( Window.Location.getHash() );
		} 
		mainController = new MainController();  
		final RootPanel footerSlot = RootPanel.get( "footer_container" );
		final String version = footerSlot.getElement().getInnerText();
		footerSlot.getElement().setInnerText( "" );
		final FooterPanel footerPanel = new FooterPanel( version );
		footerSlot.add( footerPanel );

		currentUser = DatatoolsCookies.getUserName();
		// If there are cookies, check that they're real by talking to the client manager. If not, reset user & user URI to null.
		// Since userUri is necessarily a mutable local variable, do this by checking currentUser and *then* nulling userUri afterward.
		if ( currentUser != null ) {
			// Window.alert("Datatools current user: " + currentUser);
			// Window.alert("do we have a manager? " + (ClientRepositoryToolsManager.INSTANCE == null ? "no" : "yes"));
			try {
				ClientRepositoryToolsManager.INSTANCE.whoami( new UserCallback() {

					@Override
					public void onSuccess(final User userInfo) {
						if ( userInfo == null ) {
							log.debug( "failed to get any user info from whoami" );
							handleNotLoggedIn();
							initialize();
							return;
						}
						Datatools.setUser( userInfo );
						final String user = userInfo.getUserName();
						if ( user == null ) {
							log.debug( "did whoami; user null, removing cookies" );
							handleNotLoggedIn();
							initialize();
							return;
						}
						if ( !user.equals( currentUser ) ) {
							log.debug( "did whoami; user not same as current user, removing cookies" );
							handleNotLoggedIn();
							initialize();
							return;
						}
						// Log.debug( "did whoami: confirms signed in as " + user + "; had " + ( userInfo.getWFSStateList().size() ) + " workflow states" );
						initialize();
						return;
					}

					@Override
					public void loginRequired() {
						log.debug( "did whoami; login required, removing cookies" );
						handleNotLoggedIn();
						initialize();
						return;
					}

					@Override
					public void onFailure() {
						log.debug( "other failure in whoami" );
						handleNotLoggedIn();
						initialize();
						return;
					}
				} );
			} catch (final Exception e) {
				log.warn( "did whoami; exception thrown--setting user to null & removing cookies" );
				log.warn( e.getMessage() );
				handleNotLoggedIn();
				initialize();
			}
		} else {
			// Window.alert("Datatools: no user; is initialized? " + initialized);
			if ( !initialized ) {
				initialize();
				return;
			}
		}
	}

	private void initialize() {
		initialized = true;
		if ( !Window.Location.getHash().equals( "" ) ) {
			isRefresh = true;
			log.debug( "token from window: " + Window.Location.getHash() );
			//ApplicationState.newInstance( Window.Location.getHash() );
		} 

		String userUri = DatatoolsCookies.getUserUri();
		if ( currentUser == null ) {
			userUri = null;
		}

		if ( userUri != null ) {
			ApplicationState.getInstance().setUser( EIEntity.create( EIURI.create( userUri ), currentUser ) );
			log.debug( "User uri " + ApplicationState.getInstance().getUserURI() + "; label " + ApplicationState.getInstance().getUserID() );
		}

		if ( topPanel == null ) {
			topPanel = new TopPanel();
			RootPanel.get( "header_container" ).add( topPanel );
		}
		
		if ( breadcrumbs == null ) {
			breadcrumbs = new BreadcrumbWidget();
			RootPanel.get( "back_container" ).add ( breadcrumbs );
			breadcrumbs.setVisible( false );
		} 
		
		labCache = ApplicationState.getInstance().getLabCache();

		mainPanel = new HorizontalPanel();
		dataPanel.setStyleName( "dataPanel" );
		leftList = new LeftListPanel( ApplicationState.getInstance().getLabCache() );

		workbench = new Workbench( ApplicationState.getInstance().getLabCache() );

		mainPanel.add( leftList );
		mainPanel.add( dataPanel );
		RootPanel.get( "main_container" ).add( mainPanel );
		if ( userUri != null ) {
			topPanel.onLogIn( currentUser, userUri );
			// FIXME verify and maybe move other things into this method
			ClientRepositoryToolsManager.INSTANCE.initializeAfterRefresh();
			breadcrumbs.setVisible( true );
			labCache.onLogIn( currentUser, userUri );
		}
		ClientRepositoryToolsManager.INSTANCE.addSessionListener( this );
		leftList.onApplicationStateChange();
		mainController.onApplicationStateChange();
		ApplicationState.getInstance().addApplicationStateListener( breadcrumbs );
	}

	private void handleNotLoggedIn() {
		ApplicationState.getInstance().setUser( EIEntity.NULL_ENTITY );
		DatatoolsCookies.removeCookies();
		currentUser = null;
		// isRefresh = false;
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

	@Override
	public void onLogIn(final String username, final String userUri) {
		ApplicationState.getInstance().setUser( EIEntity.create( userUri, username ) );
		breadcrumbs.setVisible( true );
		topPanel.onLogIn( username, userUri );
		labCache.onLogIn( currentUser, userUri );
		mainController.onLogIn( username, userUri );
		isRefresh = true;
	}

	@Override
	public void onLogOut() {
		log.info( "datatools logging out; redirecting to " + GWT.getModuleBaseURL() );
		ApplicationState.getInstance().setUser( EIEntity.NULL_ENTITY );
		mainController.onLogOut();
		leftList.onLogOut();
		if ( !isRefresh ) {
			Window.Location.assign( "" );
			breadcrumbs.setVisible( false );
			breadcrumbs.reset();
			
			ApplicationState.getInstance().clearApplicationState();
		}
	}

	public static void showGlasspane() {
		glasspane.add( new Image( "images/ajax-loader.gif" ) );
		glasspane.show();
	}

	public static void hideGlasspane() {
		glasspane.hide();
	}

	public static void clearDataPanel() {
		dataPanel.clear();
	}

	public static void handleLoginRequired() {
		clearDataPanel();
		final HTML errorMessage = new HTML( "<font color='red'><b> Please sign in.</b></font>" );
		dataPanel.add( errorMessage );
	}

	public static void showData(final Widget widget) {
		clearDataPanel();
		hideGlasspane();
		dataPanel.add( widget );
	}

	public static User getUser() {
		return userObject;
	}

	public static void setUser(final User user) {
		Datatools.userObject = user;
		currentUser = user.getUserName();
	}

	public static void showWorkbench() {
		showData( workbench );
	}
	
	public static void setIsRefresh(final boolean refreshing) {
		isRefresh = refreshing;
	}
}
