package org.eaglei.datatools.client.event;

import org.eaglei.datatools.client.ui.QueryTokenObject;

import com.google.gwt.event.shared.GwtEvent;

public class BrowserBackOrForwardEvent extends GwtEvent<BrowserBackOrForwardEventHandler> {
	public static Type<BrowserBackOrForwardEventHandler> TYPE = new Type<BrowserBackOrForwardEventHandler>();
	private QueryTokenObject querytokenobject;

	public BrowserBackOrForwardEvent(final QueryTokenObject querytokenobject) {
		this.querytokenobject = querytokenobject;
	}

	@Override
	public Type<BrowserBackOrForwardEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(final BrowserBackOrForwardEventHandler handler) {
		if ( handler.getMode().contains( querytokenobject.getMode().toString() ) ) {
			handler.onBrowserBackOrForwardClicked( this );
		}

	}

	public QueryTokenObject getToken() {
		return querytokenobject;
	}

	public void setToken(final QueryTokenObject querytokenobject) {
		this.querytokenobject = querytokenobject;
	}
}
