package org.eaglei.datatools.client.rpc;

import java.util.List;
import java.util.Map;

import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The client side stub for the RPC service.
 */
public interface RepositoryToolsModelServiceAsync {

	public void EIQuery(Session session, String query, AsyncCallback<List<EIInstanceMinimal>> callback); // QueryProvider

	public void retrieveLabel(Session session, EIURI uri, AsyncCallback<String> callback); // QueryProvider

	/*
	 * instance functionality
	 */

	public void getNewInstanceID(Session session, int count, AsyncCallback<List<EIURI>> callback) throws Exception; // CrudProvider

	public void getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity, AsyncCallback<EIInstance> asyncCallback); // CrudProvider

	public void getEmptyEIInstance(Session session, EIURI classUri, AsyncCallback<EIInstance> asyncCallback); // CrudProvider

	public void getInstance(Session session, EIURI instanceID, AsyncCallback<EIInstance> callback) throws Exception; // InstanceProvider

	public void updateInstance(Session session, EIInstance instance, String token, AsyncCallback<String> callback) throws Exception; // CrudProvider

	public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity, AsyncCallback callback) throws Exception; // CrudProvider

	public void deleteInstance(Session session, EIURI instanceUri, AsyncCallback callback) throws Exception; // CrudProvider

	public void deepCopy(Session session, EIURI originalUri, AsyncCallback callback) throws Exception; // CrudProvider

	public void getFilterQuery(Session session, final EIURI classUri, final EIURI state, final EIURI lab, AsyncCallback<List<EIInstanceMinimal>> instances) throws Exception; // QueryProvider

	public void getFilterQuery(Session session, final EIURI classUri, final EIURI state, final EIURI lab, boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> instances) throws Exception; // QueryProvider

	public void getWorkspaces(Session session, AsyncCallback<List<Workspace>> callback); // DatatoolsSecurityProvider

	public void referencedByQuery(Session session, final EIURI resourceUri, final boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> instances) throws Exception; // QueryProvider

	public void getModifiedDates(Session session, List<EIURI> uris, AsyncCallback<Map<EIURI, String>> callback) throws Exception;
	
	/*
	 * free form SPARQL end point
	 */

	public void query(Session session, String sparql, AsyncCallback<String> callback) throws Exception; // QueryProvider

	/*
	 * login/logout etc
	 */
	public void login(String user, String password, AsyncCallback<User> callback) throws Exception; // DatatoolsSecurityProvider

	public void logout(Session session, AsyncCallback callback) throws Exception; // DatatoolsSecurityProvider

	public void whoami(Session session, AsyncCallback callback) throws Exception; // DatatoolsSecurityProvider

	public void isOnline(AsyncCallback callback) throws Exception; // DatatoolsSecurityProvider

	/* workflow REST API */
	public void claim(Session session, List<EIURI> uris, AsyncCallback<List<EIURI>> callback) throws Exception; // WorkFlowProvider

	public void release(Session session, List<EIURI> uris, AsyncCallback<List<EIURI>> callback) throws Exception; // WorkFlowProvider

	public void getInstanceWithWorkflowState(Session session, EIURI instanceUri, AsyncCallback<EIInstance> callback) throws Exception; // WorkFlowProvider

	public void listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> callback) throws Exception;

	public void listReferencingResources(Session session, EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> callback) throws Exception;

	public void listWorkFlowTransitions(Session session, EIEntity workspaceEntity, AsyncCallback<List<WorkFlowTransition>> callback); // WorkFlowProvider

	public void transition(Session session, List<EIURI> uris, EIEntity transitionEntity, AsyncCallback<List<EIURI>> callback) throws Exception; // WorkFlowProvider
	
	/* hybrid repository/ontology method(s) not found on provider */
	public void getRootSuperclassForInstanceUri(Session session, EIURI instanceUri, AsyncCallback<EIClass> callback) throws Exception;

	public void getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri, AsyncCallback<List<EIClass>> callback) throws Exception;

	/* ontology methods moved to the repository service so we can just use ModelService */
	void getSuperClass(EIClass eclass, AsyncCallback<EIClass> callback);

	void getRootSuperClass(EIClass eclass, AsyncCallback<EIClass> callback);

	public void getAllEquivalentClasses(List<EIProperty> propertiesToPopulate, AsyncCallback<List<EIProperty>> asyncCallback);

	public void getTopClassesAnotatedByDataModelCreate(AsyncCallback<List<EIClass>> callback);
	
	/*to check if the URI is ontology term or repository instance*/
	public void isModelClassURI(EIURI uri,AsyncCallback<Boolean> callback);
}
