package org.eaglei.datatools.client.ui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;

public class ButtonsPanel extends Composite {

	private static final int MINIMUM_EDIT_TRANSITIONS = 0; 

	interface Binder extends UiBinder<Widget, ButtonsPanel> {
	}

	private static final Binder binder = GWT.create( Binder.class );
	@UiField
	protected Label formControlLabel;
	@UiField
	protected Label wfLabel;
	// Workflow operation buttons
	@UiField
	protected Button workFlowActionButton1;
	@UiField
	protected Button workFlowActionButton2;
	@UiField
	protected Button workFlowActionButton3;
	@UiField
	protected Button workFlowActionButton4;
	@UiField
	protected Button claimReleaseButton;
	// CRUD operation Buttons
	@UiField
	protected Button saveButton;
	@UiField
	protected Button editButton;
	@UiField
	protected Button cancelButton;
	@UiField
	protected Button copyResourceButton;
	@UiField
	protected Button deleteButton;
	@UiField
	protected RadioButton onlyThisLab;
	@UiField
	protected RadioButton all;

	private final EIInstance instance;
	private EIClass rootSuperClass;
	private final FormRedisplay redisplay;

	private OwnershipAction ownershipAction;
	private final Map<Button, WorkFlowTransition> buttonTransitions = new HashMap<Button, WorkFlowTransition>();
	private final List<Button> workFlowButtons;

	private static final GWTLogger log = GWTLogger.getLogger( "ButtonsPanel" );

	public interface LabRestrictionListener {
		public void selectOnlyLab();

		public void selectAll();
	}

	ButtonsPanel(final EIInstance anInstance, final FormRedisplay aRedisplay) {
		initWidget( binder.createAndBindUi( this ) );
		instance = anInstance;
		redisplay = aRedisplay;
		workFlowButtons = Arrays.asList( workFlowActionButton1, workFlowActionButton2, workFlowActionButton3, workFlowActionButton4 );
		setClaimOrReleaseButtonAction();
		setDeleteButtonAction();
		setWorkflowButtons();
		all.setVisible( false );
		onlyThisLab.setVisible( false );
	}

	/**
	 * Set whether pick list values are restricted to lab or to all. By default only this lab.
	 */
	// FIXME re-enable when we are ready to wire
	public void setLabRestrictionSelector(final LabRestrictionListener listener) {
		all.setValue( false );
		onlyThisLab.setValue( true );
		all.setVisible( false );
		onlyThisLab.setVisible( false );

		// FIXME could be done with only one clickHandler and sending onlyThisLab.getValue()
		onlyThisLab.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				listener.selectOnlyLab();

			}

		} );
		all.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				listener.selectAll();

			}
		} );

	}

	public void setWorkflowButtons() {
		setEditingButtonState();

		buttonTransitions.clear();
		final List<WorkFlowTransition> legalTransitions = ClientRepositoryToolsManager.INSTANCE.getAllowedTransitions( instance );
		log.debug( "Found " + ( legalTransitions == null ? "null" : legalTransitions.size() ) + " legal transitions" );
		wfLabel.setVisible( false );
		if ( legalTransitions != null && legalTransitions.size() > MINIMUM_EDIT_TRANSITIONS ) {
			int i = 0;
			for (final WorkFlowTransition transition : legalTransitions) {
				if ( transition.getFromStateURI().equals( transition.getToStateURI() ) ) {
					log.debug( "skipping " + transition.getName() + " because from and to are same" );
					continue;
				}
				
				if ( !wfLabel.isVisible() ) {
					wfLabel.setVisible( true );
				}

				final Button currentButton = workFlowButtons.get( i );
				currentButton.setVisible( true );
				setEnable( currentButton, ClientRepositoryToolsManager.INSTANCE.canEdit( instance ) );
				currentButton.setText( transition.getName() );
				buttonTransitions.put( currentButton, transition );
				currentButton.addClickHandler( new ClickHandler() {

					@Override
					public void onClick(final ClickEvent event) {
						ClientRepositoryToolsManager.INSTANCE.transition( instance, buttonTransitions.get( currentButton ), new EIInstanceCallback() {

							@Override
							public void onSuccess(final EIInstance success) {
								if ( success == null || success.equals( EIInstance.NULL_INSTANCE ) ) {
									Window.alert( "Unable to transition these resources:\n" + instance.getInstanceLabel() );
								}

								instance.setWFState( success.getWFState() );
								redisplay.drawAfterPromote( instance );
							}

							@Override
							public void onFailure(final String error) {
								Window.alert( "Transition failed" );
							}

							@Override
							public void loginRequired() {
								// TODO Auto-generated method stub

							}
						} );

					}
				} );
				++i;
			}
			while ( i < 4 ) {
				hide( workFlowButtons.get( i ) );
				++i;
			}
		} else {
			wfLabel.setVisible( false );
			hide( workFlowActionButton1 );
			hide( workFlowActionButton2 );
			hide( workFlowActionButton3 );
			hide( workFlowActionButton4 );
		}
	}

	private void setEditingButtonState() {
		setEnable( editButton, ClientRepositoryToolsManager.INSTANCE.canEdit( instance ) );
		setEnable( deleteButton, ClientRepositoryToolsManager.INSTANCE.canEdit( instance ) );
	}

	private void hide(final Button button) {
		setEnable( button, false );
		button.setVisible( false );
	}

	protected void setEnable(final Button workflowButton, final boolean enable) {
		workflowButton.setEnabled( enable );
		if ( enable ) {
			workflowButton.removeStyleName( "btnDisabled" );
		} else {
			workflowButton.addStyleName( "btnDisabled" );
		}
	}

	public Button getSaveButton() {
		return saveButton;
	}

	public Button getCancelButton() {
		return cancelButton;
	}

	public Button getEditButton() {
		return editButton;
	}

	public void setRootSuperClass(final EIClass superclass) {
		rootSuperClass = superclass;
	}

	public void setClaimOrReleaseButtonAction() {
		claimReleaseButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				try {
					if ( claimReleaseButton.getText().equalsIgnoreCase( "Claim" ) ) {
						// Log.info( "claiming instance: " + instance.getInstanceLabel() );
						claimOrRelease();
					} else {
						// Log.info( "releasing instance: " + instance.getInstanceLabel() );
						claimOrRelease();
					}
				} catch (final Exception e) {
					log.warn( "error while claiming" + e.getMessage() );
					Window.alert( e.getMessage() );
				}
			}
		} );

		if ( ClientRepositoryToolsManager.INSTANCE.canClaim( instance ) ) {
			claimReleaseButton.setText( "Claim" );
			ownershipAction = OwnershipAction.ClaimAction;
		} else if ( ClientRepositoryToolsManager.INSTANCE.canEdit( instance ) ) {
			claimReleaseButton.setText( "Share" );
			ownershipAction = OwnershipAction.ReleaseAction;
		} else {
			ownershipAction = OwnershipAction.ClaimAction;
			claimReleaseButton.setText( "Claim" );
			claimReleaseButton.setVisible( true );
			setEnable( claimReleaseButton, false );
		}

	}

	private void setDeleteButtonAction() {
		final AsyncCallback<String> aynccallback = new AsyncCallback<String>() {

			@Override
			public void onFailure(final Throwable caught) {
				Window.alert( caught.getMessage() );
			}

			@Override
			public void onSuccess(final String result) {
				if ( Lab.isLabType( instance.getInstanceType() ) ) {
					ApplicationState.getInstance().updateLabCache();
				}
				EIEntity typeEntity = rootSuperClass == null ? instance.getInstanceType() : rootSuperClass.getEntity();
				EIEntity labEntity = Lab.isLabType( instance.getInstanceType() ) ? EIEntity.NULL_ENTITY : ApplicationState.getInstance().getLabEntity();
				ApplicationState.getInstance().updateApplicationState( Mode.list, EIEntity.NULL_ENTITY, typeEntity, labEntity );
			}
		};
		deleteButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				if ( Window.confirm( UIMessages.DELETE_CONFIRM_MESSAGE ) ) {
					try {
						ClientRepositoryToolsManager.repositoryService.deleteInstance( DatatoolsCookies.getSession(), instance.getInstanceURI(), aynccallback );
					} catch (final Exception e) {
						Window.alert( e.getMessage() );
					}
				}
			}
		} );
	}

	private void claimOrRelease() throws Exception {
		ownershipAction.perform( instance, new ActionRedisplay() {

			@Override
			public void handleFailedTransition(final String error) {
				Window.alert( "Action failed; error is " + error ); // TODO: real message!
			}

			@Override
			public void drawAfterClaim(final EIInstanceMinimal[] instances, final List<EIInstanceMinimal> successes) {
				if ( successes.size() == 0 ) {
					Window.alert( "Unable to claim " + instance.getInstanceLabel() ); // TODO: real message!
				} else {
					ownershipAction = ownershipAction.toggle();
					claimReleaseButton.setText( ownershipAction.getName() );
					final EIInstanceMinimal claimedMinimal = instances[0];
					instance.setWFOwner( claimedMinimal.getWFOwner() );
					setWorkflowButtons();
					redisplay.drawAfterPromote( instance );
				}
			}

			@Override
			public void drawAfterPromote(final EIInstanceMinimal[] instances, final List<EIInstanceMinimal> failures) {
				// deliberate no-op
			}

			@Override
			public void needsRefresh(final String message) {
				Window.alert( UIMessages.REFRESH_SINGLE_MESSAGE );
			}
		} );
	}

	public void hideAllWorkflowButtons() {
		wfLabel.setVisible( false );
		hide( workFlowActionButton1 );
		hide( workFlowActionButton2 );
		hide( workFlowActionButton3 );
		hide( workFlowActionButton4 );
	}

	public boolean isPresenlyOwner() {
		if ( instance.getWFOwner() != null && instance.getWFOwner().getURI().equals( ApplicationState.getInstance().getUserURI() ) ) {
			return true;
		} else {
			return false;
		}
	}
}
