package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.DatatoolsClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EquivalentClassesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SaveResultsCallback;
import org.eaglei.datatools.client.ui.ButtonsPanel.LabRestrictionListener;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.datatools.client.ui.widgets.EIResourceListWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.ObjectWidget;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.datatools.client.ui.widgets.TypeWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class EditFormsPanel extends DatatoolsInstancePanel {

	static enum EditFormType {
		Edit, New, Dialog;
	}

	private final List<EIEntity> dataPropEntityList = new ArrayList<EIEntity>();
	private final List<EIEntity> booleanPropEntityList = new ArrayList<EIEntity>();
	private final List<EIEntity> objPropEntityList = new ArrayList<EIEntity>();
	private final Map<EIEntity, List<EIClass>> objectPropertyRanges = new HashMap<EIEntity, List<EIClass>>();
	private final EIEntity labEntity;
	private String editToken;
	private final EditFormType formType;
	private final EditFormRedisplay formRedisplayCallbacks;
	
	private static final GWTLogger log = GWTLogger.getLogger("EditFormsPanel");

	public static EditFormsPanel createEditForm(final EIInstance instance, final EIURI labUri, final EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel( instance, labUri, displayCallbacks, EditFormType.Edit );
	}

	public static EditFormsPanel createNewForm(final EIInstance instance, final EIURI labUri, final EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel( instance, labUri, displayCallbacks, EditFormType.New );
	}

	public static EditFormsPanel createDialogForm(final EIInstance instance, final EIURI labUri, final EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel( instance, labUri, displayCallbacks, EditFormType.Dialog );
	}

	private EditFormsPanel(final EIInstance instance, final EIURI labUri, final EditFormRedisplay displayCallbacks, final EditFormType formType) {
		super( instance, displayCallbacks );
		shouldShowReadOnlyProperties = true;
		formRedisplayCallbacks = displayCallbacks;
		// initializeProperties(); // call finishSetup inside the callback--don't do anything until we have properties
		this.formType = formType;
		setButtonState(); // in order to get new/edit
		labEntity = ( labUri == null || labUri.toString().equals( "" ) ) ? null : EIEntity.create( labUri, "" ); // TODO: FIX ME!!
		if ( !isNewForm() ) {
			getEditToken();
		}
		
		if ( buttonPanel.getSaveButton().isEnabled() ) {
			buttonPanel.getSaveButton().addClickHandler( new ClickHandler() {

				@Override
				public void onClick(final ClickEvent event) {
					save();
				}
			} );
		}
		
		if ( buttonPanel.getCancelButton().isEnabled() ) {
			buttonPanel.getCancelButton().addClickHandler( new ClickHandler() {

				@Override
				public void onClick(final ClickEvent event) {
					cancel();
				}
			} );
		}
		
		buttonPanel.setLabRestrictionSelector( new LabRestrictionListener() {

			@Override
			public void selectAll() {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void selectOnlyLab() {
				// TODO Auto-generated method stub
				
			}
			
		});
	}

	@Override
	protected void finishSetup() {
		buttonPanel.setRootSuperClass( rootSuperClass );

		dataPropEntityList.clear();
		objPropEntityList.clear();
		objectPropertyRanges.clear();
		booleanPropEntityList.clear();
		// initializeEquivalentClasses(eiProperties); // TODO: reinstate this & remove below once getting the equivalent classes really works at the server level
		propertyInitializationCallback( eiProperties );
	}

	private void propertyInitializationCallback(final List<EIProperty> populatedProperties) {
		for (final EIProperty property : eiProperties) {
			if ( property instanceof EIDatatypeProperty ) {
				dataPropEntityList.add( property.getEntity() );
				if ( ( (EIDatatypeProperty)property ).getTypeLabel().equals( "boolean" ) ) {
					booleanPropEntityList.add( property.getEntity() );
				}
			} else if ( property instanceof EIObjectProperty ) {
				objPropEntityList.add( property.getEntity() );
				// Deal with equivalent classes
				final List<EIClass> assertedRanges = ( ( (EIObjectProperty)property ).getRangeList() );
				final List<EIClass> inferredRanges = new ArrayList<EIClass>();
				// inferredRanges will contain asserted ranges where no equivalent classes
				// are defined, otherwise equivalent classes

				for (final EIClass range : assertedRanges) {
					if ( range.hasEquivalentClass() ) { // do not add range but its equivalences
						log.debug( "Range has equivalent classes; substituting" );
						final List<EIEquivalentClass> equivalentClasses = range.getEquivalentClasses();
						for (final EIEquivalentClass eqClass : equivalentClasses) {
							log.debug( "adding ranges from equivalent class: " + eqClass );
							inferredRanges.addAll( eqClass.getEquivalentTo() );
						}
					} else {
						inferredRanges.add( range );
					}
				}
				// objectPropertyRanges.put(property.getEntity(), ((EIObjectProperty) property).getRangeList());
				objectPropertyRanges.put( property.getEntity(), inferredRanges );
			}
		}
		super.finishSetup();
	}

	private void initializeEquivalentClasses(final List<EIProperty> properties) {
		// FIXME
		// need call to get all at once or better, have them be set by default
		ClientRepositoryToolsManager.INSTANCE.getEquivalentClasses( properties, new EquivalentClassesCallback() {
			@Override
			public void onSuccess(final List<EIProperty> populatedProperties) {
				// Log.debug("Got class with equivalent classes: " + result);
				propertyInitializationCallback( populatedProperties );
			}

			@Override
			public void onFailure(final String result) {

			}
		} );

	}

	public boolean isNewForm() {
		return formType == EditFormType.New || formType == EditFormType.Dialog;
	}

	@Override
	protected void drawDataProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<String> propertyValues) {
		if ( propertyEntity.equals( EagleIEntityConstants.RDFS_LABEL_ENTITY ) ) {
			formPanel.add( TextWidget.makeLabelTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValues.iterator().next() ) );
		} else if ( propertyValues == null || propertyValues.size() == 0 ) {
			if ( booleanPropEntityList.contains( propertyEntity ) ) {
				formPanel.add( WidgetUtils.createRadioButon( eiInstance, propertyEntity, propertyDefinition, isRequired, null ) );
			} else {
				formPanel.add( new EditWidgetCollection( eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, null ) ) );
			}
		} else {
			final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
			for (final String value : propertyValues) {
				if ( booleanPropEntityList.contains( propertyEntity ) ) {
					fields.addWithoutModifiers( WidgetUtils.createRadioButon( eiInstance, propertyEntity, propertyDefinition, isRequired, value ) );
				} else {
					fields.addWidget( TextWidget.makeDatatypeTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, value ) );
				}
			}
			fields.setStyleName( "required" );
			formPanel.add( fields );

		}
	}

	@Override
	protected void drawNonOntologyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final VerticalPanel nonOntologyPanel) {
		if ( !propertyEntity.getURI().toString().equals( DatatoolsUIConstants.COMMENTS ) && !propertyEntity.getURI().toString().equals( DatatoolsUIConstants.CURATOR_NOTE ) ) {
			final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
			nonOntologyPanel.add( fields );
			for (final String value : propertyValues) {
				fields.addWidget( TextWidget.makeNonOntologyTextWidget( eiInstance, propertyEntity, value ) );
			}
		}
	}

	@Override
	protected void drawNonOntologyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final VerticalPanel nonOntologyPanel) {
		final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
		nonOntologyPanel.add( fields );
		for (final EIEntity value : propertyValues) {
			fields.addWidget( TextWidget.makeNonOntologyTextWidget( eiInstance, propertyEntity, value.getLabel() ) );
		}
	}

	@Override
	protected void drawObjectProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<EIEntity> propertyValues) {
		if ( propertyEntity.equals( EagleIEntityConstants.RDF_TYPE_ENTITY ) ) { // Type does not have a range
			drawTypeProperty();
		} else if ( objectPropertyRanges.get( propertyEntity ) != null && objectPropertyRanges.get( propertyEntity ).size() > 0 ) {
			final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
			formPanel.add( fields );
			if ( objectPropertyRanges.get( propertyEntity ).size() == 1 ) { // Single range
				drawSingleObjectProperty( propertyEntity, propertyDefinition, isRequired, propertyValues, fields );
			} else { // Multiple ranges
				log.info( propertyEntity + " is a multi-range item  with " + ( propertyValues == null ? "<null>" : propertyValues.size() ) + "entries" );
				if ( propertyValues == null || propertyValues.size() == 0 ) {
					createWidgetForMultiRanges( propertyEntity, propertyDefinition, isRequired, null, fields );
				} else {
					for (final EIEntity selectedEntity : propertyValues) {
						createWidgetForMultiRanges( propertyEntity, propertyDefinition, isRequired, selectedEntity, fields );
					}
				}
			}
		}
	}

	private void drawSingleObjectProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<EIEntity> propertyValues, final EditWidgetCollection fields) {
		final EIClass range = objectPropertyRanges.get( propertyEntity ).iterator().next();

		if ( hasLabUri() && InstanceWidgetUtils.isLabProperty( range ) ) {
			log.info( "making disabled widget for lab uri '" + labEntity + "' property " + range.getEntity().getLabel() );
			eiInstance.addObjectProperty( propertyEntity, labEntity );
			createWidgetForRange( propertyEntity, propertyDefinition, isRequired, range, labEntity, fields, true );
		} else if ( propertyValues == null || propertyValues.size() == 0 ) { // new
			if ( InstanceWidgetUtils.isLabProperty( range ) ) {
				log.info( "drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab" );
			}
			createWidgetForRange( propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, fields, false );
		} else { // existing
			if ( InstanceWidgetUtils.isLabProperty( range ) ) {
				log.info( "drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab" );
			}
			for (final EIEntity selectedEntity : propertyValues) {
				createWidgetForRange( propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, false );
			}
		}
	}

	private void drawTypeProperty() {
		final HorizontalPanel temp = new HorizontalPanel();
		formPanel.add( temp );
		if ( InstanceWidgetUtils.isLabProperty( eiInstance.getInstanceClass() ) ) {
			ClientRepositoryToolsManager.INSTANCE.getLabRootSuperclass( new DatatoolsClassCallback() {

				@Override
				public void onSuccess(final EIClass superclass) {
					final TypeWidget typeWidget = new TypeWidget( eiInstance, EagleIEntityConstants.RDF_TYPE_ENTITY, superclass, eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler() {

						@Override
						public void onTypeChange() {
							log.info( "redrawing; type changed to " + eiInstance.getInstanceClass() );
							formPanel.clear();
							formPanel.add( buttonPanel );
							eiClass = eiInstance.getInstanceClass();
							initializeProperties(); // re-gets lists, re-draws form. Also adds as a session listener *again*
						}
					} );
					temp.add( typeWidget );
				}

				@Override
				public void onFailure(String error) {
					// TODO Auto-generated method stub
					
				}
			} );
		} else {
			ClientRepositoryToolsManager.INSTANCE.getRootSuperClass( eiInstance.getInstanceClass(), new DatatoolsClassCallback() {

				@Override
				public void onSuccess(final EIClass superclass) {
					final TypeWidget typeWidget = new TypeWidget( eiInstance, EagleIEntityConstants.RDF_TYPE_ENTITY, superclass, eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler() {

						@Override
						public void onTypeChange() {
							log.info( "redrawing; type changed to " + eiInstance.getInstanceClass() );
							formPanel.clear();
							formPanel.add( buttonPanel );
							eiClass = eiInstance.getInstanceClass();
							initializeProperties(); // re-gets lists, re-draws form. Also adds as a session listener *again*
						}
					} );
					temp.add( typeWidget );
				}

				@Override
				public void onFailure(String error) {
					// TODO Auto-generated method stub
					
				}
			} );
		}
	}

	private void createWidgetForMultiRanges(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIEntity selectedEntity, final EditWidgetCollection fields) {
		log.info( "making multi-range widget with " + objectPropertyRanges.get( propertyEntity ).size() + " ranges" );
		final ObjectWidget widget = new ObjectWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, objectPropertyRanges.get( propertyEntity ), labEntity, selectedEntity );
		fields.addWidget( widget, widget.isDisabled() );
	}

	private void createWidgetForRange(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedEntity, final EditWidgetCollection fields, final boolean isLab) {
		if ( range.isEagleIResource() ) {
			final EIResourceListWidget resourceWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, true );
			fields.addWidget( resourceWidget, isLab );
			if ( isLab ) {
				resourceWidget.disable();
			}
		} else {
			WidgetUtils.addTermWidgetToPanel( eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, true );
		}
	}

	@Override
	protected Collection<EIEntity> getDataTypeEntities() {
		return dataPropEntityList;
	}

	@Override
	protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getObjectTypeEntities() {
		return objPropEntityList;
	}

	@Override
	protected void drawExtraFields(final Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		final Label commentOnComments = new Label( UIMessages.COMMENT_ON_COMMENTS );
		commentOnComments.setStyleName( "commentOnComments" );
		formPanel.add( commentOnComments );
		final EIEntity comments = EIEntity.create( DatatoolsUIConstants.COMMENTS, DatatoolsUIConstants.COMMENTS_LABEL );
		final EIEntity curatorComments = EIEntity.create( DatatoolsUIConstants.CURATOR_NOTE, DatatoolsUIConstants.CURATOR_LABEL );
		final String commentValue = nonOntologyLiteralProperties.containsKey( comments ) ? nonOntologyLiteralProperties.get( comments ).iterator().next() : null;
		final TextAreaWidget commentsArea = TextAreaWidget.makeNonOntologyTextArea( eiInstance, comments, "", false, commentValue );
		formPanel.add( commentsArea );
		final String curatorValue = nonOntologyLiteralProperties.containsKey( curatorComments ) ? nonOntologyLiteralProperties.get( curatorComments ).iterator().next() : null;
		final TextAreaWidget curatorArea = TextAreaWidget.makeNonOntologyTextArea( eiInstance, curatorComments, "", false, curatorValue );
		formPanel.add( curatorArea );
	}

	// TODO: make a static on WidgetUtils
	protected boolean hasLabUri() {
		return ( labEntity != null ) && ( labEntity.getURI() != EIURI.NULL_EIURI ) && ( !labEntity.getURI().toString().equals( "" ) );
	}

	protected void save() { // TODO: handle stale token correctly
		try {
			if ( eiInstance.getInstanceLabel() == null || eiInstance.getInstanceLabel().trim().equals( "" ) ) {
				Window.alert( UIMessages.LABEL_REQUIRED );
				return;
			}
			if ( isNewForm() ) {
				saveNewForm();
			} else {
				ClientRepositoryToolsManager.INSTANCE.updateInstance( eiInstance, editToken, new SaveResultsCallback() {

					@Override
					public void onSuccess(final String str) {
						formRedisplayCallbacks.drawAfterSave( eiInstance );
					}

					@Override
					public void loginRequired() {
						Window.alert( UIMessages.PLEASE_LOGIN );
					}

					@Override
					public void onFailure() {
						Window.alert( UIMessages.SAVE_FAILURE );
						formRedisplayCallbacks.drawAfterCancel( eiInstance );
					}
				} );
			}
		} catch (final Exception e) {
			log.error( "could not (re-) get instance" );
		}
	}

	private void saveNewForm() throws Exception {
		ClientRepositoryToolsManager.INSTANCE.createInstance( eiInstance, new EIInstanceCallback() {

			@Override
			public void onSuccess(final EIInstance saved) {
				log.info( "drawing " + saved.getInstanceLabel() + " after saving" );
				formRedisplayCallbacks.drawAfterSave( saved );
			}

			@Override
			public void loginRequired() {
				Window.alert( UIMessages.PLEASE_LOGIN );
			}

			@Override
			public void onFailure(String error) {
				Window.alert( UIMessages.SAVE_FAILURE );
				formRedisplayCallbacks.drawAfterCancel( eiInstance );
			}
		} );
	}

	private void cancel() {
		try {
			if ( formType == EditFormType.New ) {
				if ( Lab.isLabType( eiInstance.getInstanceType() ) ) {
					ApplicationState.getInstance().updateApplicationState( Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
				} else {
					EIEntity typeEntity = rootSuperClass == null ? eiInstance.getInstanceType() : rootSuperClass.getEntity();
					ApplicationState.getInstance().updateApplicationState( Mode.list, EIEntity.NULL_ENTITY, typeEntity, ApplicationState.getInstance().getLabEntity() );
				}
			} else if ( formType == EditFormType.Dialog ) {
				formRedisplayCallbacks.drawAfterCancel( eiInstance );
			} else {
				ClientRepositoryToolsManager.INSTANCE.getInstance( eiInstance.getInstanceURI(), new EIInstanceCallback() {

					@Override
					public void loginRequired() {
					}

					@Override
					public void onSuccess(final EIInstance fetched) {
						formRedisplayCallbacks.drawAfterCancel( fetched );
					}

					@Override
					public void onFailure(String error) {
						formRedisplayCallbacks.drawAfterCancel( eiInstance );
					}
				} );
			}
		} catch (final Exception e) {
			log.error( "could not get instance" );
		}
	}

	@Override
	protected void setButtonState() {
		buttonPanel.saveButton.setVisible( true );
		if ( formType == EditFormType.New ) {
			buttonPanel.copyResourceButton.setVisible( false );
			buttonPanel.cancelButton.setVisible( true );

		} else if ( formType == EditFormType.Dialog ) {
			buttonPanel.copyResourceButton.setVisible( false );
			buttonPanel.cancelButton.setVisible( true );
		} else {
			buttonPanel.copyResourceButton.setVisible( true );
			buttonPanel.cancelButton.setVisible( true );
			buttonPanel.hideAllWorkflowButtons();
		}
		buttonPanel.editButton.setVisible( false );
		buttonPanel.claimReleaseButton.setVisible( false );
		buttonPanel.deleteButton.setVisible( false );
	}

	private void getEditToken() {
		try {
			ClientRepositoryToolsManager.INSTANCE.updateInstance( eiInstance, null, new SaveResultsCallback() {

				@Override
				public void loginRequired() {
					Window.alert( UIMessages.PLEASE_LOGIN );
				}

				@Override
				public void onFailure() {
					log.warn( "failed to get edit token for " + eiInstance );
					Window.alert( UIMessages.NO_TOKEN_AVAILABLE );
				}

				@Override
				public void onSuccess(final String arg0) {
					editToken = arg0;
				}
			} );
		} catch (final Exception e) {
			log.error( "failed to get edit token for " + eiInstance + " with exception" );
			Window.alert( UIMessages.NO_TOKEN_AVAILABLE );
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.ui.EIFormsPanel#drawReferencedBy()
	 */
	@Override
	protected void drawReferencedBy() {
		// deliberate no-op
		// Edit form doesn't display referenced by link
	}

}
