package org.eaglei.datatools.client.ui;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.datatools.User;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.UserCallback;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * The top panel, header logo, sign in, etc
 */
public class TopPanel extends Composite implements ClientRepositoryToolsManager.SessionListener {

	private static final String BLANK = "_blank";

	interface Binder extends UiBinder<Widget, TopPanel> {
	}

	private static final Binder binder = GWT.create( Binder.class );
	@UiField
	protected Label welcomeLabel;
	@UiField
	protected Anchor logoutAnchor;
	@UiField
	protected Label logoutSeparator;
	@UiField
	protected Anchor changePassword;
	@UiField
	protected Label changePasswordSeparator;
	@UiField
	protected UListElement loginList;
	@UiField
	protected TextBox userTextBox;
	@UiField
	protected PasswordTextBox passTextBox;
	@UiField
	protected Button loginButton;
	@UiField
	protected Image logo;
	@UiField
	protected Anchor searchLink;
	@UiField
	protected Anchor glossaryLink;
	@UiField
	protected Anchor helpLink;
	
	private boolean signedIn = false;
	public static String[] wfStates;
	public static Map<String, Boolean> accessMap = new HashMap<String, Boolean>();

	public TopPanel() {
		initWidget( binder.createAndBindUi( this ) );
		passTextBox.addKeyUpHandler( new KeyUpHandler() {

			@Override
			public void onKeyUp(final KeyUpEvent event) {
				if ( event.getNativeKeyCode() == KeyCodes.KEY_ENTER ) {
					performLogin();
				}
			}
		} );
		if ( !signedIn ) {
			logoutAnchor.setVisible( false );
			logoutSeparator.setVisible( false );
			changePassword.setVisible( false );
			changePasswordSeparator.setVisible( false );
		}
		searchLink.setHref( getSearchURL() == null ? "http://search.eagle-i.net/central/" : getSearchURL() );
		searchLink.setTarget( BLANK );
		glossaryLink.setHref( WidgetUtils.getGlossaryURL() == null ? "http://search.eagle-i.net/model/" : WidgetUtils.getGlossaryURL() );
		glossaryLink.setTarget( BLANK );
		helpLink.addClickHandler( new ClickHandler() {

			public void onClick(final ClickEvent clickEvent) {
				Window.open( WidgetUtils.getHelpURL(), BLANK, "height=" + ( getHelpWindowHeight() ) + ",width=" + getHelpWindowWidth() + ",left=" + ( getHelpWindowLeft() ) + ",top=0" );
			}
		} );
		final String imageName = WidgetUtils.getNodeNameFromURL();
		logo.setUrl( "images/" + imageName + "_logo.png" );
		loginButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				performLogin();
			}
		} );
		logoutAnchor.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				if ( signedIn ) {
					Datatools.setIsRefresh( false );
					performLogout();
				}
			}
		} );
		changePassword.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {

				if ( signedIn ) {
					Window.open( WidgetUtils.getChangePasswordURL(), BLANK, "height=" + ( getHelpWindowHeight() ) + ",width=" + getHelpWindowWidth() + ",left=" + ( getHelpWindowLeft() ) + ",top=0" );
				}
			}
		} );
		if ( DatatoolsCookies.hasSession() ) {
			signedIn = true;
		}
		ClientRepositoryToolsManager.INSTANCE.addSessionListener( this );
	}

	private void performLogin() {
		final String user = userTextBox.getText();
		if ( user == null || user.trim().length() == 0 ) {
			Window.alert( UIMessages.NO_USER );
			return;
		}
		final String pass = passTextBox.getText();
		if ( pass == null || pass.trim().length() == 0 ) {
			Window.alert( UIMessages.NO_PASSWORD );
			return;
		}
		ClientRepositoryToolsManager.INSTANCE.logIn( user.trim(), pass.trim(), new UserCallback() {

			@Override
			public void onSuccess(User userInfo) {
				Datatools.setUser( userInfo );
			}

			@Override
			public void loginRequired() {
				Window.alert( "Error logging in. " );
			}

			@Override
			public void onFailure() {
				Window.alert( "Error logging in. " );
			}
		} );
	}

	private void performLogout() {
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

	@Override
	public void onLogOut() {
		welcomeLabel.setText( "Please login" );
		loginList.getStyle().setVisibility( Style.Visibility.VISIBLE );
		changePassword.setVisible( false );
		signedIn = false;
		userTextBox.setText( "" );
		passTextBox.setText( "" );
		logoutAnchor.setVisible( false );
		logoutSeparator.setVisible( false );
	}

	@Override
	public void onLogIn(final String username, final String userUri) {
		welcomeLabel.setText( "Welcome, " + username );
		changePassword.setVisible( true );
		changePasswordSeparator.setVisible( true );
		logoutAnchor.setVisible( true );
		logoutSeparator.setVisible( true );
		// userURI.setText(text);
		loginList.getStyle().setVisibility( Style.Visibility.HIDDEN );
		signedIn = true;
	}

	private String getSearchURL() {
		final String url = GWT.getHostPageBaseURL();
		final String node = WidgetUtils.getNodeNameFromURL();
		if ( node != null ) {
			final String searchUrl = url.replace( node + ".", "search." ).replace( "/datatools/", "" ) + "/central/";
			return searchUrl;
		} else {
			return null;
		}
	}

	private int getHelpWindowHeight() {
		return Window.getClientHeight() + Window.getClientHeight() / 12;
	}

	private int getHelpWindowWidth() {
		return 600;
	}

	private int getHelpWindowLeft() {
		return Window.getClientWidth() - getHelpWindowWidth();
	}
}
