package org.eaglei.datatools.client.ui;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.allen_sauer.gwt.log.client.Logger;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Displays the Form for viewing. All the fields are disabled and no editing is possible.
 * 
 */
public class ViewFormsPanel extends DatatoolsInstancePanel {

	private static final GWTLogger log = GWTLogger.getLogger( "ViewFormsPanel" );

	public ViewFormsPanel(final EIInstance instance, final ViewFormRedisplay redisplay) {
		super( instance, redisplay );
		shouldShowReadOnlyProperties = true;
	}

	@Override
	protected void drawDataProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<String> propertyValues) {
		final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
		formPanel.add( widget );
		for (final String value : propertyValues) {
			widget.add( handleReadOnlyTextProperty( value ) );
		}
	}

	@Override
	protected void drawNonOntologyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final VerticalPanel nonOntologyPanel) {
		final String propLabel = propertyEntity.getLabel();
		final LabelValuesWidget widget = new LabelValuesWidget( propLabel );
		for (final String value : propertyValues) {
			widget.add( handleReadOnlyTextProperty( value ) );
		}
		nonOntologyPanel.add( widget );
	}

	@Override
	protected void drawNonOntologyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final VerticalPanel nonOntologyPanel) {
		final String propLabel = propertyEntity.getLabel();
		final LabelValuesWidget widget = new LabelValuesWidget( propLabel );
		boolean hadValue = false;
		for (final EIEntity propEntity : propertyValues) {
			// Not sure if it's possible to delete the referred-to entity for a non-ontology literal, but we might as well take care of it...
			if ( propEntity != null && propEntity != EIEntity.NULL_ENTITY && !propEntity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
				widget.add( handleReadOnlyTextProperty( propEntity.getLabel() ) );
				hadValue = true;
			}
		}
		if ( hadValue ) {
			nonOntologyPanel.add( widget );
		}
	}

	@Override
	protected void drawObjectProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<EIEntity> propertyValues) {
		final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
		formPanel.add( widget );
		boolean hadValue = false;
		for (final EIEntity entity : propertyValues) {
			if ( entity == null || entity == EIEntity.NULL_ENTITY || entity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
				continue;
			}
			hadValue = true;
			final Anchor a = new Anchor( InstanceWidgetUtils.formatText( entity.getLabel() ) );
			widget.add( a );

			a.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(final ClickEvent arg0) {
					/* this is to check if entity is Ontology term or Repository instance */
					ClientRepositoryToolsManager.INSTANCE.isModelClassURI( entity.getURI(), new AsyncCallback<Boolean>() {
						@Override
						public void onFailure(Throwable caught) {
							log.error( "there is async error in org.eaglei.datatools.client.ui.ViewFormsPanel#draObjectProperty when calling isModelClassURI(EIURI) Async method " );
						}

						@Override
						public void onSuccess(Boolean result) {
							/* if it is ontology entity then open glossary window otherwise get new instance from repository and show it */
							if ( result )
								Window.open( WidgetUtils.getGlossaryURL() + "#t=" + entity.getURI().toString(), "", "" );
							else
								getInstanceByURI( entity );
						}
					} );
				}

			} );

		}

		if ( !hadValue ) {
			formPanel.remove( widget );
		}

	}

	private void getInstanceByURI(final EIEntity entity) {
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance( entity.getURI(), new EIInstanceCallback() {
				@Override
				public void loginRequired() {
					log.error( " getInstance(EIURI) of org.eaglei.datatools.client.ui.ViewFormsPanel#getInstanceByURI() async method ended in loginRequired() method " );
				}

				@Override
				public void onSuccess(final EIInstance eiInstance) {
					if ( eiInstance != null ) {
						EIEntity labEntity = Lab.getProperLabEntity( eiInstance );
						ApplicationState.getInstance().updateApplicationState( Mode.view, eiInstance.getEntity(), eiInstance.getInstanceType(), labEntity );
					} else {
						Window.open( WidgetUtils.getGlossaryURL() + "#t=" + entity.getURI().toString(), "", "" );
					}
				}

				@Override
				public void onFailure(String error) {

					Window.alert( UIMessages.NO_SUCH_RESOURCE );
				}
			} );
		} catch (final Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	protected void drawReferencedBy() {
		final Anchor referencedBy = new Anchor( "Referenced by..." );
		referencedBy.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent arg0) {
				log.info( "trying to get references for " + eiInstance );
				ApplicationState.getInstance().updateApplicationState( Mode.references, eiInstance.getEntity(), EIEntity.NULL_ENTITY, ApplicationState.getInstance().getLabEntity() );
			}

		} );
		final HorizontalPanel referencePanel = new HorizontalPanel();
		referencePanel.add( referencedBy );
		referencedBy.setStyleName( "referencedBy" );
		formPanel.add( referencePanel );
	}

	@Override
	protected Collection<EIEntity> getDataTypeEntities() {
		return eiInstance.getDatatypeProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getObjectTypeEntities() {
		return eiInstance.getObjectProperties().keySet();
	}

	@Override
	protected void drawExtraFields(final Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		// deliberate no-op
	}

	@Override
	protected void setButtonState() {
		buttonPanel.saveButton.setVisible( false );
		buttonPanel.copyResourceButton.setVisible( true );
		buttonPanel.cancelButton.setVisible( false );
		// buttonPanel.editButton.setVisible(true);
		buttonPanel.editButton.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(final ClickEvent event) {
				ApplicationState.getInstance().setMode( Mode.edit ); // TODO: anything else we need to set here?
			}
		} );

	}
}
