package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.widgets.EIPopup;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.TermWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Collection of static utility methods required for form generation
 */
public class WidgetUtils {
	
	private static final GWTLogger log = GWTLogger.getLogger("WidgetUtils");

	public interface InstanceSaveCallback {

		public void updateState(EIInstance newInstance);

		public void reset();
	}

	public static TextBox createTextField() {
		final TextBox textField = new TextBox();
		textField.setStyleName( "formText" );
		return textField;
	}

	public static TextBox createTextFieldForResourceWidget() {
		final TextBox textField = new TextBox();
		textField.setStyleName( "textSuggest" );
		return textField;
	}

	public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedClassEntity,
			final EditWidgetCollection fields, final boolean showLabel) {
		if ( selectedClassEntity == null || selectedClassEntity.equals( EIEntity.NULL_ENTITY ) ) {
			fields.addWidget( new TermWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, EIClass.NULL_CLASS, showLabel ) );
		} else {
			ClientModelManager.INSTANCE.getClass( selectedClassEntity.getURI(), new ClassCallback() {

				@Override
				public void onSuccess(final EIClass result) {
					log.info( "got root superclass for " + selectedClassEntity.getURI() + " Superclass is " + result );
					fields.addWidget( new TermWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, result, showLabel ) );
				}
			} );
		}
	}

	public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedClassEntity,
			final HorizontalPanel tempPanel, final boolean showLabel) {
		if ( selectedClassEntity == null || selectedClassEntity.equals( EIEntity.NULL_ENTITY ) ) {
			tempPanel.add( new TermWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, EIClass.NULL_CLASS, showLabel ) );
		} else {
			ClientModelManager.INSTANCE.getClass( selectedClassEntity.getURI(), new ClassCallback() {

				@Override
				public void onSuccess(final EIClass result) {
					log.info( "got class for " + selectedClassEntity + " class is " + result );
					tempPanel.add( new TermWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, result, showLabel ) );
				}
			} );
		}
	}

	public static HorizontalPanel createRadioButon(final EIInstance instance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String originalValue) {
		final HorizontalPanel hPanel = new HorizontalPanel();
		final CheckBox checkBox = new CheckBox();
		if ( originalValue != null ) {
			Boolean booleanValue = Boolean.valueOf( originalValue );
			if ( booleanValue == Boolean.FALSE ) {
				if ( originalValue.toLowerCase().startsWith( "yes" ) ) {
					booleanValue = Boolean.TRUE;
				}
			}
			log.info( "original value: " + originalValue + "; parsed value " + booleanValue );
			checkBox.setValue( booleanValue );
		}
		hPanel.add( InstanceWidgetUtils.createLabel( propertyEntity, propertyDefinition, isRequired ) );
		hPanel.add( checkBox );
		checkBox.addValueChangeHandler( new ValueChangeHandler<Boolean>() {

			@Override
			public void onValueChange(final ValueChangeEvent<Boolean> arg0) {
				final Boolean oldValue = !( arg0.getValue() );
				instance.replaceDatatypePropertyValue( propertyEntity, oldValue.toString(), arg0.getValue().toString() );
				instance.replaceDatatypePropertyValue( propertyEntity, originalValue, arg0.getValue().toString() );
			}
		} );
		return hPanel;
	}

	public static boolean isInstanceUri(final String selectedUri) {
		if ( selectedUri == null || selectedUri.equals( "" ) || selectedUri.equals( EIURI.NULL_EIURI.toString() ) ) {
			return false;
		}
		return selectedUri.indexOf( "/i/" ) != -1; // TODO: TOTAL HACK
	}
	
	public static boolean isInstance(final EIEntity selectedEntity) {
		if ( selectedEntity == null || selectedEntity.equals( EIEntity.NULL_ENTITY ) ) {
			return false;
		}
		return selectedEntity.getURI().toString().indexOf( "/i/" ) != -1; // TODO: TOTAL HACK
	}

	public static EIEntity getSelectedEntity(final ListBox listBox) {
		final int selectedIndex = listBox.getSelectedIndex();
		return EIEntity.create( getSelectedUri( listBox ), listBox.getItemText( selectedIndex ) );
	}

	@Deprecated
	public static EIURI getSelectedUri(final ListBox listBox) {
		final EIURI selectedUri = EIURI.create( listBox.getValue( listBox.getSelectedIndex() ) );
		return selectedUri;
	}

	public static PopupPanel createDialog(final EIInstance parentInstance, final EIClass range, final EIEntity propertyEntity, final EIURI oldValue, final int position, final InstanceSaveCallback innerCallback) {
		final PopupPanel window = new EIPopup( "100%", "100%" );
		final VerticalPanel vPanel = new VerticalPanel();
		window.setWidget( vPanel );
		window.setModal( false );
		window.setAnimationEnabled( true );
		final EditFormRedisplay redisplay = new EditFormRedisplay() {

			@Override
			public void drawAfterPromote(final EIInstance instance) {
			}

			@Override
			public void drawAfterDuplicate(final EIInstance instance) {
			}

			@Override
			public void drawAfterSave(final EIInstance instance) {
				innerCallback.updateState( instance );
				window.hide();
			}

			@Override
			public void drawAfterCancel(final EIInstance instance) {
				innerCallback.reset();
				window.hide();
			}
		};
		final VerticalPanel newPanel = FormsPanelFactory.generateNewForm( range.getEntity().getURI(), true, redisplay );
		vPanel.add( newPanel );
		return window;
	}

	public static String formatDate(final String dt) {
		String date = "";
		if ( dt != null ) {
			date = dt.substring( 0, dt.indexOf( "T" ) );
		}
		return date;
	}

	public static String lowerCaseFirst(final String original) {
		final char first = original.charAt( 0 );
		return Character.toLowerCase( first ) + original.substring( 1 );
	}

	/* utilites for url making for search,glossary and help links */
	public static String getGlossaryURL() {
		final String url = GWT.getHostPageBaseURL();
		final String node = getNodeNameFromURL();
		if ( node != null ) {
			final String searchUrl = url.replace( node + ".", "search." ).replace( "/datatools/", "" ) + "/model/";
			return searchUrl;
		} else {
			return null;
		}
	}

	public static String getHelpURL() {
		return replaceURLWithString( "/datatools/", "/help/eagle-i.htm" );
	}

	public static String getChangePasswordURL() {

		return replaceURLWithString( "/datatools/", "/repository/editUser.html" );
	}

	private static String replaceURLWithString(final String target, final String replacement) {
		final String url = GWT.getHostPageBaseURL();
		final String urlToReturn = url.replace( target, replacement );
		return urlToReturn;
	}

	public static String getNodeNameFromURL() {
		final String url = GWT.getHostPageBaseURL();
		int startIndex = -1;
		final int endIndex = url.indexOf( ".eagle-i.net" );
		if ( url.indexOf( "." ) > 0 && url.indexOf( "." ) < endIndex ) {
			startIndex = url.indexOf( "." ) + 1;
		} else {
			startIndex = url.indexOf( "//" ) + 2;
		}
		if ( endIndex == -1 || startIndex == -1 ) {
			return null;
		} else {
			final String node = url.substring( startIndex, endIndex );
			return node;
		}
	}

}
