package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.User;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

public class WorkflowUtils {

	@Deprecated
	//repeated in ClientRepositoryToolsManager
	public static boolean instanceHasAnyOwner(final EIInstance instance) {
		return isNotNull( instance.getWFOwner() );
	}

	@Deprecated
	//repeated in ClientRepositoryToolsManager
	public static boolean instanceHasCurrentOwner(final EIInstance instance, final User currentUser) {
		return isNotNull( instance.getWFOwner() ) && instance.getWFOwner().equals( EIEntity.create( currentUser.getUserURI(), currentUser.getUserName() ) );
	}

	@Deprecated
	//repeated in ClientRepositoryToolsManager
	public static boolean instanceHasAnyOwner(final EIInstanceMinimal instance) {
		return isNotNull( instance.getWFOwner() );
	}

	@Deprecated
	//repeated in ClientRepositoryToolsManager
	public static boolean instanceHasCurrentOwner(final EIInstanceMinimal instance, final User currentUser) {
		return isNotNull( instance.getWFOwner() ) && instance.getWFOwner().equals( EIEntity.create( currentUser.getUserURI(), currentUser.getUserName() ) );
	}

	public static boolean instanceHasWorkflowState(final EIInstance instance) {
		return isNotNull( instance.getWFState() );
	}

	public static boolean instanceHasWorkflowState(final EIInstanceMinimal instance) {
		return isNotNull( instance.getWFState() );
	}

	public static boolean isNotNull(final EIEntity entity) {
		return entity != null && !EIEntity.NULL_ENTITY.equals( entity );
	}

	@Deprecated
	public static boolean canUserChangeState(final EIURI currentWFState) {
		if ( currentWFState == null ) {
			return false;
		}
		return ClientRepositoryToolsManager.INSTANCE.canEdit( currentWFState );
	}
}
