package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIEntity;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;

public class BreadcrumbWidget extends HorizontalPanel implements ApplicationStateChangeListener { // TODO: FlowPanel? Check with Seth

	private final Anchor homeLink;
	private final Anchor workbenchLink;
	private Anchor labLink;
	private Anchor resourcesLink;
	private EIEntity labEntity = EIEntity.NULL_ENTITY;
	private final static String nextCrumb = "  >  ";

	private static final GWTLogger log = GWTLogger.getLogger( "BreadcrumbWidget" );

	public BreadcrumbWidget() {
		homeLink = new Anchor( "Home" );
//		homeLink.addClickHandler( new ClickHandler() {
//
//			@Override
//			public void onClick(ClickEvent event) {
//				labEntity = EIEntity.NULL_ENTITY;
//				hideFollowing( homeLink );
//			}
//		} );
		add( homeLink );
		homeLink.setEnabled( false );
		homeLink.setStyleName( "disabledLink" );

		addNextCrumb();

		workbenchLink = new Anchor( "Workbench" );
		workbenchLink.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				hideFollowing( workbenchLink );
				labEntity = EIEntity.NULL_ENTITY;
				ApplicationState.getInstance().updateApplicationState( Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY );
			}
		} );
		add( workbenchLink );
		showPrevious( workbenchLink );

		addNextCrumb();

		labLink = new Anchor( "" );
		labLink.setVisible( false );
		labLink.setEnabled( false );
		labLink.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				hideFollowing( labLink );
				log.debug("updating lab to " + labEntity);
				ApplicationState.getInstance().updateApplicationState( Mode.view, labEntity, EagleIEntityConstants.EI_LAB_ENTITY, labEntity );
			}
		} );
		add( labLink );

		addNextCrumb();

		resourcesLink = new Anchor( "Resources" );
		resourcesLink.setVisible( false );
		resourcesLink.setEnabled( false );
		add( resourcesLink );
	}

	@Override
	public void onApplicationStateChange() {
		log.debug( "breadcrumb widget app state changed" );
		labEntity = ApplicationState.getInstance().getLabEntity();
		if ( ApplicationState.getInstance().hasLab() ) {
			log.debug( "has lab" );
			labLink.setText( ApplicationState.getInstance().getLabEntity().getLabel() );
			labLink.setVisible( true );
			labLink.setEnabled( true );
			showPrevious( labLink );
			hideFollowing( labLink );
		} else if ( ApplicationState.getInstance().getMode() == Mode.workbench ) {
			log.debug( "workbench mode" );
			workbenchLink.setVisible( true );
			showPrevious( workbenchLink );
			hideFollowing( workbenchLink );
		}

		if ( ( labEntity != EIEntity.NULL_ENTITY ) && Mode.isResourcesList( ApplicationState.getInstance().getMode() ) ) {
			String label = ApplicationState.getInstance().getTypeEntity().equals( EIEntity.NULL_ENTITY ) ? "Resources" : ApplicationState.getInstance().getTypeEntity().getLabel();
			
			resourcesLink.setText( label );
			resourcesLink.setVisible( true );
			resourcesLink.setEnabled( true );
			showPrevious( resourcesLink );
		}
	}
	
	public void reset() {
		hideFollowing( workbenchLink );
		
		labLink.setText( "" );
		labLink.setVisible( false );
		labLink.setEnabled( false );
		hideFollowing( labLink );
		
		resourcesLink.setText("");
		resourcesLink.setVisible( false );
		resourcesLink.setEnabled( false );
		
	}

	private void addNextCrumb() {
		final Label nextWidgetLabel = new Label( nextCrumb );
		nextWidgetLabel.setStyleName("breadCrumbArrow");
		add( nextWidgetLabel );
		nextWidgetLabel.setVisible( false );
	}

	private void showPrevious(Anchor anchor) {
		if ( getWidgetIndex( anchor ) > 0 ) {
			getWidget( getWidgetIndex( anchor ) - 1 ).setVisible( true );
		}
	}

	private void hideFollowing(Anchor clickedAnchor) {
		int clickedWidgetIndex = getWidgetIndex( clickedAnchor );
		for (int i = clickedWidgetIndex + 1; i < getWidgetCount(); i++) {
			getWidget( i ).setVisible( false );
		}
	}
}
