package org.eaglei.datatools.client.ui.widgets;

import java.util.List;

import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.WidgetUtils.InstanceSaveCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;

public class EIResourceListWidget extends EditWidget {

	private static final String CREATE_NEW_VALUE = "<create new>";
	private static final String NO_VALUE = "<none>";
	private final ListBox instances = new ListBox();
	private final EIClass range;
	private final boolean shouldHaveLabel;
	
	private static GWTLogger log = GWTLogger.getLogger("EIResourceListWidget");

	public EIResourceListWidget(final EIInstance instance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedEntity, final boolean shouldShowLabel) {
		super( instance, propertyEntity, propertyDefinition, isRequired );
		this.range = range;
		if ( selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY ) {
			oldValue = selectedEntity.getURI().toString();
			if ( selectedEntity.getLabel().equals( "" ) || selectedEntity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
				selectedEntity.setLabel( selectedEntity.getURI().toString() );
			}
		}
		shouldHaveLabel = shouldShowLabel;
		if ( !shouldHaveLabel ) {
			widgetPanel.remove( label );
		}
		setup();
		intializeInstances();
	}

	private void intializeInstances() {
		instances.setStyleName("formDropdown");
		addDefaultInstanceValues();
		if ( range.equals( EIClass.NULL_CLASS ) ) {
			log.info( "skipping get instances" );
			if ( hasOldValue() ) {
				instances.removeItem( instances.getItemCount() - 1 );
				final String probablyDeletedLabel = "[non-standard link] " + getOldStringValue();
				instances.addItem( probablyDeletedLabel, getOldStringValue() );
				instances.setSelectedIndex( instances.getItemCount() - 1 );
			}
		} else {
			try {
				final AuthSearchRequest request = new AuthSearchRequest();
				request.setType( range.getEntity().getURI() );
				request.setPaginated( false );
				//FIXME hook checkboxes for "buckets" - my lab, status, TBD
				ClientRepositoryToolsManager.INSTANCE.listResources( request, SortByProperties.label, false, new EIInstancesCallback() {

					public void onSuccess(final List<EIInstanceMinimal> result) {
						instances.removeItem( instances.getItemCount() - 1 );
						// Move resources with current lab to beginning of the list
						if ( ApplicationState.getInstance().hasLab() ) {
							for (int i = 0, j = result.size() - 1; i < result.size(); i++) {
								if ( result.get( j ).getLab().equals( ApplicationState.getInstance().getLabEntity() ) ) {
									result.add( 0, result.remove( j ) );
								} else {
									j--;
								}
							}
						}
						for (final EIInstanceMinimal valueInstance : result) {
							instances.addItem( formatInstanceForListBox( valueInstance ), valueInstance.getInstanceURI().toString() );
							if ( ApplicationState.getInstance().hasLab() && valueInstance.getLab().equals( ApplicationState.getInstance().getLabEntity() ) ) {
								final Element childElement = (Element)instances.getElement().getChild( instances.getItemCount() - 1 );
								childElement.setClassName( "ownlabTxt" );
							}
							if ( valueInstance.getInstanceURI().toString().equals( oldValue ) ) {
								instances.setSelectedIndex( instances.getItemCount() - 1 );
							}
						}
						/*if ( instances.getSelectedIndex() == -1 && oldValue != null ) {
							// TODO display broken link?
						}*/
					}

					@Override
					public void loginRequired() {
						// handleLoginRequired();
					}

					@Override
					public void onFailure(String error) {
						Window.alert(UIMessages.COULD_NOT_FIND_RESOURCES_MESSAGE);
					}
				} );
			} catch (final Exception e) {
				log.error( e.getMessage() );
				// TODO do something intelligent
			}
		}

		instances.addChangeHandler( new ChangeHandler() {

			@Override
			public void onChange(final ChangeEvent arg0) {
				doOnChange( eiInstance, range, propertyEntity, oldValue, instances );
			}
		} );
	}

	private void addDefaultInstanceValues() {
		instances.addItem( NO_VALUE, null );
		instances.addItem( CREATE_NEW_VALUE, null );
		instances.addItem( "...loading...", null );
	}

	private void doOnChange(final EIInstance instance, final EIClass range, final EIEntity propertyEntity, final String propertyValue, final ListBox subClassList) {
		if ( subClassList.getItemText( subClassList.getSelectedIndex() ).equals( NO_VALUE ) ) {
			removeValue();
		} else if ( subClassList.getItemText( subClassList.getSelectedIndex() ).equals( CREATE_NEW_VALUE ) ) {
			final int currentPosition = widgetPanel.getAbsoluteTop();
			final PopupPanel dialog = WidgetUtils.createDialog( instance, range, propertyEntity, EIURI.create( oldValue ), currentPosition, new InstanceSaveCallback() {

				@Override
				public void updateState(final EIInstance newInstance) {
					subClassList.addItem( formatInstanceForListBox( newInstance ), newInstance.getInstanceURI().toString() );
					subClassList.setSelectedIndex( subClassList.getItemCount() - 1 );
					if ( hasOldValue() ) {
						eiInstance.replaceObjectPropertyValue( propertyEntity, EIURI.create( oldValue ), newInstance.getEntity() );
					} else {
						eiInstance.addObjectProperty( propertyEntity, newInstance.getEntity() );
					}
					updateOldValue( WidgetUtils.getSelectedUri( subClassList ) );
				}

				@Override
				public void reset() {
					int i = 0;
					for (i = 0; i < instances.getItemCount(); i++) {
						if ( instances.getValue( i ).equals( getOldStringValue() ) ) {
							instances.setSelectedIndex( i );
							break;
						}
					}
					if ( i == instances.getItemCount() ) {
						log.info( "no actual old value" );
						subClassList.setSelectedIndex( 0 );
					}
				}
			} );
			dialog.show();
			final Style style = dialog.getElement().getStyle();
			style.clearOverflow();
		} else {
			if ( hasOldValue() ) {
				eiInstance.replaceObjectPropertyValue( propertyEntity, EIURI.create( oldValue ), WidgetUtils.getSelectedEntity( subClassList ) );
			} else {
				eiInstance.addObjectProperty( propertyEntity, WidgetUtils.getSelectedEntity( subClassList ) );
			}
			updateOldValue( WidgetUtils.getSelectedUri( subClassList ) );
		}
	}

	private void setup() {
		instances.setName( propertyEntity.getURI().toString() + "_instances" );
		widgetPanel.add( instances );
	}

	private String formatInstanceForListBox(final EIInstanceMinimal valueInstance) {
		return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">" + ( !valueInstance.getLab().equals( EIEntity.NULL_ENTITY ) ? ", " + valueInstance.getLab().getLabel() : "" );
	}

	private String formatInstanceForListBox(final EIInstance valueInstance) {
		return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">";
	}

	@Override
	public EditWidget duplicateBlank() {
		return new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, (EIEntity)null, true );
	}

	@Override
	protected void removeValue() {
		if ( hasOldValue() ) {
			eiInstance.replaceObjectPropertyValue( propertyEntity, getOldEIURIValue(), null );
		}
	}

	public void disable() {
		instances.setEnabled( false );
	}

}
