/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.DatatoolsInstancePanel;
import org.eaglei.datatools.client.ui.EditFormRedisplay;
import org.eaglei.datatools.client.ui.EditFormsPanel;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.Lab;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.EIResourceListWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.ObjectWidget;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class EditFormsPanel
extends DatatoolsInstancePanel {
    private final List<EIEntity> dataPropEntityList = new ArrayList();
    private final List<EIEntity> booleanPropEntityList = new ArrayList();
    private final List<EIEntity> objPropEntityList = new ArrayList();
    private final Map<EIEntity, List<EIClass>> objectPropertyRanges = new HashMap();
    private final EIEntity labEntity;
    private String editToken;
    private final EditFormType formType;
    private final EditFormRedisplay formRedisplayCallbacks;
    private static final GWTLogger log = GWTLogger.getLogger((String)"EditFormsPanel");

    public static EditFormsPanel createEditForm(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, labUri, displayCallbacks, EditFormType.Edit);
    }

    public static EditFormsPanel createNewForm(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, labUri, displayCallbacks, EditFormType.New);
    }

    public static EditFormsPanel createDialogForm(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, labUri, displayCallbacks, EditFormType.Dialog);
    }

    private EditFormsPanel(EIInstance instance, EIURI labUri, EditFormRedisplay displayCallbacks, EditFormType formType) {
        super(instance, (FormRedisplay)displayCallbacks);
        this.shouldShowReadOnlyProperties = true;
        this.formRedisplayCallbacks = displayCallbacks;
        this.formType = formType;
        this.setButtonState();
        EIEntity eIEntity = this.labEntity = labUri == null || labUri.toString().equals("") ? null : EIEntity.create((EIURI)labUri, (String)"");
        if (!this.isNewForm()) {
            this.getEditToken();
        }
        if (this.buttonPanel.getSaveButton().isEnabled()) {
            this.buttonPanel.getSaveButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.buttonPanel.getCancelButton().isEnabled()) {
            this.buttonPanel.getCancelButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.buttonPanel.setLabRestrictionSelector((ButtonsPanel.LabRestrictionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void finishSetup() {
        this.buttonPanel.setRootSuperClass(this.rootSuperClass);
        this.dataPropEntityList.clear();
        this.objPropEntityList.clear();
        this.objectPropertyRanges.clear();
        this.booleanPropEntityList.clear();
        this.propertyInitializationCallback(this.eiProperties);
    }

    private void propertyInitializationCallback(List<EIProperty> populatedProperties) {
        for (EIProperty property : this.eiProperties) {
            if (property instanceof EIDatatypeProperty) {
                this.dataPropEntityList.add(property.getEntity());
                if (!((EIDatatypeProperty)property).getTypeLabel().equals("boolean")) continue;
                this.booleanPropEntityList.add(property.getEntity());
                continue;
            }
            if (!(property instanceof EIObjectProperty)) continue;
            this.objPropEntityList.add(property.getEntity());
            List assertedRanges = ((EIObjectProperty)property).getRangeList();
            ArrayList<EIClass> inferredRanges = new ArrayList<EIClass>();
            for (EIClass range : assertedRanges) {
                if (range.hasEquivalentClass()) {
                    log.debug("Range has equivalent classes; substituting");
                    List equivalentClasses = range.getEquivalentClasses();
                    for (EIEquivalentClass eqClass : equivalentClasses) {
                        log.debug("adding ranges from equivalent class: " + eqClass);
                        inferredRanges.addAll(eqClass.getEquivalentTo());
                    }
                    continue;
                }
                inferredRanges.add(range);
            }
            this.objectPropertyRanges.put(property.getEntity(), inferredRanges);
        }
        super.finishSetup();
    }

    private void initializeEquivalentClasses(List<EIProperty> properties) {
        ClientRepositoryToolsManager.INSTANCE.getEquivalentClasses(properties, (ClientRepositoryToolsManager.EquivalentClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isNewForm() {
        return this.formType == EditFormType.New || this.formType == EditFormType.Dialog;
    }

    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        if (propertyEntity.equals((Object)EagleIEntityConstants.RDFS_LABEL_ENTITY)) {
            this.formPanel.add((Widget)TextWidget.makeLabelTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (String)propertyValues.iterator().next()));
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (this.booleanPropEntityList.contains(propertyEntity)) {
                this.formPanel.add((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, null));
            } else {
                this.formPanel.add((Widget)new EditWidgetCollection(this.eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, null)));
            }
        } else {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            for (String value : propertyValues) {
                if (this.booleanPropEntityList.contains(propertyEntity)) {
                    fields.addWithoutModifiers((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (String)value));
                    continue;
                }
                fields.addWidget(TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (String)value));
            }
            fields.setStyleName("required");
            this.formPanel.add((Widget)fields);
        }
    }

    protected void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, VerticalPanel nonOntologyPanel) {
        if (!propertyEntity.getURI().toString().equals("http://eagle-i.org/ont/datatools/1.0/user_comments") && !propertyEntity.getURI().toString().equals("http://purl.obolibrary.org/obo/IAO_0000232")) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            nonOntologyPanel.add((Widget)fields);
            for (String value : propertyValues) {
                fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
            }
        }
    }

    protected void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, VerticalPanel nonOntologyPanel) {
        EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
        nonOntologyPanel.add((Widget)fields);
        for (EIEntity value : propertyValues) {
            fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value.getLabel()));
        }
    }

    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        if (propertyEntity.equals((Object)EagleIEntityConstants.RDF_TYPE_ENTITY)) {
            this.drawTypeProperty();
        } else if (this.objectPropertyRanges.get(propertyEntity) != null && ((List)this.objectPropertyRanges.get(propertyEntity)).size() > 0) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            this.formPanel.add((Widget)fields);
            if (((List)this.objectPropertyRanges.get(propertyEntity)).size() == 1) {
                this.drawSingleObjectProperty(propertyEntity, propertyDefinition, isRequired, propertyValues, fields);
            } else {
                log.info(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : Integer.valueOf(propertyValues.size())) + "entries");
                if (propertyValues == null || propertyValues.size() == 0) {
                    this.createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, null, fields);
                } else {
                    for (EIEntity selectedEntity : propertyValues) {
                        this.createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, selectedEntity, fields);
                    }
                }
            }
        }
    }

    private void drawSingleObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues, EditWidgetCollection fields) {
        EIClass range = (EIClass)((List)this.objectPropertyRanges.get(propertyEntity)).iterator().next();
        if (this.hasLabUri() && InstanceWidgetUtils.isLabProperty((EIClass)range)) {
            log.info("making disabled widget for lab uri '" + this.labEntity + "' property " + range.getEntity().getLabel());
            this.eiInstance.addObjectProperty(propertyEntity, this.labEntity);
            this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, this.labEntity, fields, true);
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (InstanceWidgetUtils.isLabProperty((EIClass)range)) {
                log.info("drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
            }
            this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, fields, false);
        } else {
            if (InstanceWidgetUtils.isLabProperty((EIClass)range)) {
                log.info("drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
            }
            for (EIEntity selectedEntity : propertyValues) {
                this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, false);
            }
        }
    }

    private void drawTypeProperty() {
        HorizontalPanel temp = new HorizontalPanel();
        this.formPanel.add((Widget)temp);
        if (InstanceWidgetUtils.isLabProperty((EIClass)this.eiInstance.getInstanceClass())) {
            ClientRepositoryToolsManager.INSTANCE.getLabRootSuperclass((ClientRepositoryToolsManager.DatatoolsClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(this.eiInstance.getInstanceClass(), (ClientRepositoryToolsManager.DatatoolsClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void createWidgetForMultiRanges(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIEntity selectedEntity, EditWidgetCollection fields) {
        log.info("making multi-range widget with " + ((List)this.objectPropertyRanges.get(propertyEntity)).size() + " ranges");
        ObjectWidget widget = new ObjectWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, (List)this.objectPropertyRanges.get(propertyEntity), this.labEntity, selectedEntity);
        fields.addWidget((EditWidget)widget, widget.isDisabled());
    }

    private void createWidgetForRange(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, EditWidgetCollection fields, boolean isLab) {
        if (range.isEagleIResource()) {
            EIResourceListWidget resourceWidget = new EIResourceListWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, true);
            fields.addWidget((EditWidget)resourceWidget, isLab);
            if (isLab) {
                resourceWidget.disable();
            }
        } else {
            WidgetUtils.addTermWidgetToPanel((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (EIClass)range, (EIEntity)selectedEntity, (EditWidgetCollection)fields, (boolean)true);
        }
    }

    protected Collection<EIEntity> getDataTypeEntities() {
        return this.dataPropEntityList;
    }

    protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        return this.eiInstance.getNonOntologyLiteralProperties().keySet();
    }

    protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
        return this.eiInstance.getNonOntologyResourceProperties().keySet();
    }

    protected Collection<EIEntity> getObjectTypeEntities() {
        return this.objPropEntityList;
    }

    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        Label commentOnComments = new Label("Comments and curator notes will not be published.");
        commentOnComments.setStyleName("commentOnComments");
        this.formPanel.add((Widget)commentOnComments);
        EIEntity comments = EIEntity.create((String)"http://eagle-i.org/ont/datatools/1.0/user_comments", (String)"Comments");
        EIEntity curatorComments = EIEntity.create((String)"http://purl.obolibrary.org/obo/IAO_0000232", (String)"Curator note");
        String commentValue = nonOntologyLiteralProperties.containsKey(comments) ? nonOntologyLiteralProperties.get(comments).iterator().next() : null;
        TextAreaWidget commentsArea = TextAreaWidget.makeNonOntologyTextArea((EIInstance)this.eiInstance, (EIEntity)comments, (String)"", (boolean)false, (String)commentValue);
        this.formPanel.add((Widget)commentsArea);
        String curatorValue = nonOntologyLiteralProperties.containsKey(curatorComments) ? nonOntologyLiteralProperties.get(curatorComments).iterator().next() : null;
        TextAreaWidget curatorArea = TextAreaWidget.makeNonOntologyTextArea((EIInstance)this.eiInstance, (EIEntity)curatorComments, (String)"", (boolean)false, (String)curatorValue);
        this.formPanel.add((Widget)curatorArea);
    }

    protected boolean hasLabUri() {
        return this.labEntity != null && this.labEntity.getURI() != EIURI.NULL_EIURI && !this.labEntity.getURI().toString().equals("");
    }

    protected void save() {
        try {
            if (this.eiInstance.getInstanceLabel() == null || this.eiInstance.getInstanceLabel().trim().equals("")) {
                Window.alert((String)"Name is a required field.");
                return;
            }
            if (this.isNewForm()) {
                this.saveNewForm();
            } else {
                ClientRepositoryToolsManager.INSTANCE.updateInstance(this.eiInstance, this.editToken, (ClientRepositoryToolsManager.SaveResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            log.error("could not (re-) get instance");
        }
    }

    private void saveNewForm() throws Exception {
        ClientRepositoryToolsManager.INSTANCE.createInstance(this.eiInstance, (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cancel() {
        try {
            if (this.formType == EditFormType.New) {
                if (Lab.isLabType((EIEntity)this.eiInstance.getInstanceType())) {
                    ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
                } else {
                    EIEntity typeEntity = this.rootSuperClass == null ? this.eiInstance.getInstanceType() : this.rootSuperClass.getEntity();
                    ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.list, EIEntity.NULL_ENTITY, typeEntity, ApplicationState.getInstance().getLabEntity());
                }
            } else if (this.formType == EditFormType.Dialog) {
                this.formRedisplayCallbacks.drawAfterCancel(this.eiInstance);
            } else {
                ClientRepositoryToolsManager.INSTANCE.getInstance(this.eiInstance.getInstanceURI(), (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            log.error("could not get instance");
        }
    }

    protected void setButtonState() {
        this.buttonPanel.saveButton.setVisible(true);
        if (this.formType == EditFormType.New) {
            this.buttonPanel.copyResourceButton.setVisible(false);
            this.buttonPanel.cancelButton.setVisible(true);
        } else if (this.formType == EditFormType.Dialog) {
            this.buttonPanel.copyResourceButton.setVisible(false);
            this.buttonPanel.cancelButton.setVisible(true);
        } else {
            this.buttonPanel.copyResourceButton.setVisible(true);
            this.buttonPanel.cancelButton.setVisible(true);
            this.buttonPanel.hideAllWorkflowButtons();
        }
        this.buttonPanel.editButton.setVisible(false);
        this.buttonPanel.claimReleaseButton.setVisible(false);
        this.buttonPanel.deleteButton.setVisible(false);
    }

    private void getEditToken() {
        try {
            ClientRepositoryToolsManager.INSTANCE.updateInstance(this.eiInstance, null, (ClientRepositoryToolsManager.SaveResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error("failed to get edit token for " + this.eiInstance + " with exception");
            Window.alert((String)"Currently unable to edit this resource. Logout and try again.");
        }
    }

    protected void drawReferencedBy() {
    }

    static /* synthetic */ void access$000(EditFormsPanel x0) {
        x0.cancel();
    }

    static /* synthetic */ void access$100(EditFormsPanel x0, List x1) {
        x0.propertyInitializationCallback(x1);
    }

    static /* synthetic */ EIInstance access$200(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EIInstance access$300(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EIInstance access$400(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ GWTLogger access$500() {
        return log;
    }

    static /* synthetic */ VerticalPanel access$600(EditFormsPanel x0) {
        return x0.formPanel;
    }

    static /* synthetic */ VerticalPanel access$700(EditFormsPanel x0) {
        return x0.formPanel;
    }

    static /* synthetic */ EIClass access$802(EditFormsPanel x0, EIClass x1) {
        x0.eiClass = x1;
        return x0.eiClass;
    }

    static /* synthetic */ EIInstance access$900(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ void access$1000(EditFormsPanel x0) {
        x0.initializeProperties();
    }

    static /* synthetic */ EIInstance access$1100(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EIInstance access$1200(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EIInstance access$1300(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ VerticalPanel access$1400(EditFormsPanel x0) {
        return x0.formPanel;
    }

    static /* synthetic */ VerticalPanel access$1500(EditFormsPanel x0) {
        return x0.formPanel;
    }

    static /* synthetic */ EIClass access$1602(EditFormsPanel x0, EIClass x1) {
        x0.eiClass = x1;
        return x0.eiClass;
    }

    static /* synthetic */ EIInstance access$1700(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ void access$1800(EditFormsPanel x0) {
        x0.initializeProperties();
    }

    static /* synthetic */ EIInstance access$1900(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EditFormRedisplay access$2000(EditFormsPanel x0) {
        return x0.formRedisplayCallbacks;
    }

    static /* synthetic */ EIInstance access$2100(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EIInstance access$2200(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EIInstance access$2300(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ EIInstance access$2400(EditFormsPanel x0) {
        return x0.eiInstance;
    }

    static /* synthetic */ String access$2502(EditFormsPanel x0, String x1) {
        x0.editToken = x1;
        return x0.editToken;
    }
}

